/*
 * Decompiled with CFR 0.152.
 */
package org.supercsv.ext.builder;

import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.Optional;
import org.supercsv.cellprocessor.ConvertNullTo;
import org.supercsv.cellprocessor.constraint.Equals;
import org.supercsv.cellprocessor.constraint.NotNull;
import org.supercsv.cellprocessor.constraint.Unique;
import org.supercsv.cellprocessor.ift.CellProcessor;
import org.supercsv.ext.annotation.CsvColumn;
import org.supercsv.ext.builder.CellProcessorBuilder;
import org.supercsv.ext.cellprocessor.Trim;
import org.supercsv.ext.exception.SuperCsvInvalidAnnotationException;

public abstract class AbstractCellProcessorBuilder<T>
implements CellProcessorBuilder<T> {
    protected static <A extends Annotation> Optional<A> getAnnotation(Annotation[] annos, Class<A> clazz) {
        return Arrays.stream(annos).filter(a -> clazz.isAssignableFrom(a.getClass())).map(a -> (Annotation)clazz.cast(a)).findFirst();
    }

    protected CsvColumn getColumnAnnotation(Annotation[] annos) {
        return AbstractCellProcessorBuilder.getAnnotation(annos, CsvColumn.class).orElseThrow(() -> new SuperCsvInvalidAnnotationException(String.format("not found anotation '%s'", CsvColumn.class.getName())));
    }

    @Override
    public CellProcessor buildOutputCellProcessor(Class<T> type, Annotation[] annos, boolean ignoreValidationProcessor) {
        CsvColumn csvColumnAnno = this.getColumnAnnotation(annos);
        CellProcessor cellProcessor = null;
        if (csvColumnAnno.trim()) {
            cellProcessor = this.prependTrimProcessor(type, annos, cellProcessor);
        }
        cellProcessor = this.buildOutputCellProcessor(type, annos, cellProcessor, ignoreValidationProcessor);
        if (csvColumnAnno.unique() && !ignoreValidationProcessor) {
            cellProcessor = this.prependUniqueProcessor(type, annos, cellProcessor);
        }
        if (!csvColumnAnno.equalsValue().isEmpty() && !ignoreValidationProcessor) {
            cellProcessor = this.prependEqualsProcessor(type, annos, cellProcessor, this.parseValue(type, annos, csvColumnAnno.equalsValue()).get());
        }
        cellProcessor = csvColumnAnno.optional() ? this.prependOptionalProcessor(type, annos, cellProcessor) : this.prependNotNullProcessor(type, annos, cellProcessor);
        cellProcessor = this.buildOutputCellProcessorWithConvertNullTo(type, annos, cellProcessor, ignoreValidationProcessor, csvColumnAnno);
        return cellProcessor;
    }

    @Override
    public CellProcessor buildInputCellProcessor(Class<T> type, Annotation[] annos) {
        CsvColumn csvColumnAnno = this.getColumnAnnotation(annos);
        CellProcessor cellProcessor = null;
        cellProcessor = this.buildInputCellProcessor(type, annos, cellProcessor);
        if (csvColumnAnno.unique()) {
            cellProcessor = this.prependUniqueProcessor(type, annos, cellProcessor);
        }
        if (!csvColumnAnno.equalsValue().isEmpty()) {
            cellProcessor = this.prependEqualsProcessor(type, annos, cellProcessor, csvColumnAnno.equalsValue());
        }
        if (csvColumnAnno.trim()) {
            cellProcessor = this.prependTrimProcessor(type, annos, cellProcessor);
        }
        cellProcessor = csvColumnAnno.optional() ? this.prependOptionalProcessor(type, annos, cellProcessor) : this.prependNotNullProcessor(type, annos, cellProcessor);
        cellProcessor = this.buildInputCellProcessorWithConvertNullTo(type, annos, cellProcessor, csvColumnAnno);
        return cellProcessor;
    }

    protected CellProcessor buildOutputCellProcessorWithConvertNullTo(Class<T> type, Annotation[] annos, CellProcessor cellProcessor, boolean ignoreValidationProcessor, CsvColumn csvColumnAnno) {
        if (!csvColumnAnno.outputDefaultValue().isEmpty()) {
            String defaultValue = csvColumnAnno.outputDefaultValue();
            return this.prependConvertNullToProcessor(type, annos, cellProcessor, defaultValue);
        }
        return cellProcessor;
    }

    protected CellProcessor buildInputCellProcessorWithConvertNullTo(Class<T> type, Annotation[] annos, CellProcessor cellProcessor, CsvColumn csvColumnAnno) {
        if (!csvColumnAnno.inputDefaultValue().isEmpty()) {
            Optional<T> value = this.parseValue(type, annos, csvColumnAnno.inputDefaultValue());
            return this.prependConvertNullToProcessor(type, annos, cellProcessor, value.get());
        }
        return cellProcessor;
    }

    protected CellProcessor prependConvertNullToProcessor(Class<T> type, Annotation[] annos, CellProcessor cellProcessor, Object value) {
        return cellProcessor == null ? new ConvertNullTo(value) : new ConvertNullTo(value, cellProcessor);
    }

    protected CellProcessor prependEqualsProcessor(Class<T> type, Annotation[] annos, CellProcessor cellProcessor, Object value) {
        return cellProcessor == null ? new Equals(value) : new Equals(value, cellProcessor);
    }

    protected CellProcessor prependUniqueProcessor(Class<T> type, Annotation[] annos, CellProcessor cellProcessor) {
        return cellProcessor == null ? new Unique() : new Unique(cellProcessor);
    }

    protected CellProcessor prependOptionalProcessor(Class<T> type, Annotation[] annos, CellProcessor cellProcessor) {
        return cellProcessor == null ? new org.supercsv.cellprocessor.Optional() : new org.supercsv.cellprocessor.Optional(cellProcessor);
    }

    protected CellProcessor prependNotNullProcessor(Class<T> type, Annotation[] annos, CellProcessor cellProcessor) {
        return cellProcessor == null ? new NotNull() : new NotNull(cellProcessor);
    }

    protected CellProcessor prependTrimProcessor(Class<T> type, Annotation[] annos, CellProcessor cellProcessor) {
        return cellProcessor == null ? new Trim() : new Trim(cellProcessor);
    }

    public abstract CellProcessor buildOutputCellProcessor(Class<T> var1, Annotation[] var2, CellProcessor var3, boolean var4);

    public abstract CellProcessor buildInputCellProcessor(Class<T> var1, Annotation[] var2, CellProcessor var3);

    public abstract Optional<T> parseValue(Class<T> var1, Annotation[] var2, String var3);
}

