/*
 * Decompiled with CFR 0.152.
 */
package org.supercsv.ext.localization;

import java.util.Map;

public class MapVariableInterpolator {
    private static final String[][] escapeMapRegex = new String[][]{{"$", "\\$"}, {"^", "\\^"}, {".", "\\."}, {"*", "\\*"}, {"|", "\\|"}, {"?", "\\?"}, {"+", "\\+"}, {"\\", "\\\\"}, {"(", "\\("}, {")", "\\)"}, {"[", "\\["}, {"]", "\\]"}, {"{", "\\{"}, {"}", "\\}"}};

    private MapVariableInterpolator() {
    }

    public static String interpolate(String message, Map<String, ?> variables) {
        if (message == null) {
            throw new IllegalArgumentException("message must be not null.");
        }
        if (message.indexOf(123) < 0) {
            return message;
        }
        if (variables == null || variables.isEmpty()) {
            return message;
        }
        String value = message;
        for (Map.Entry<String, ?> entry : variables.entrySet()) {
            String varName = MapVariableInterpolator.escapeRegexPattern("${" + entry.getKey() + "}");
            value = value.replaceAll(varName, MapVariableInterpolator.convertObjectToString(entry.getValue()));
        }
        return value;
    }

    public static String interpolate(String message) {
        if (message == null) {
            throw new IllegalArgumentException("message must be not null.");
        }
        return message;
    }

    private static String convertObjectToString(Object value) {
        if (value == null) {
            return "";
        }
        if (value instanceof String) {
            return (String)value;
        }
        return value.toString();
    }

    private static String escapeRegexPattern(String value) {
        return MapVariableInterpolator.escapeStringRecursive(value, escapeMapRegex);
    }

    private static String escapeStringRecursive(String str, String[][] escapeMaps) {
        if (str == null || str.isEmpty()) {
            return "";
        }
        int index = -1;
        String[][] stringArray = escapeMaps;
        int n = escapeMaps.length;
        int n2 = 0;
        while (n2 < n) {
            String[] escapeMap = stringArray[n2];
            index = str.indexOf(escapeMap[0]);
            if (index >= 0) {
                return String.valueOf(MapVariableInterpolator.escapeStringRecursive(str.substring(0, index), escapeMaps)) + escapeMap[1] + MapVariableInterpolator.escapeStringRecursive(str.substring(index + escapeMap[0].length()), escapeMaps);
            }
            ++n2;
        }
        return str;
    }
}

