/*
 * Decompiled with CFR 0.152.
 */
package org.supercsv.ext.io;

import java.io.IOException;
import java.io.Writer;
import java.util.Collection;
import org.supercsv.ext.builder.CsvAnnotationBeanParser;
import org.supercsv.ext.builder.CsvBeanMapping;
import org.supercsv.ext.io.BeanMappingCache;
import org.supercsv.ext.io.ValidatableCsvBeanWriter;
import org.supercsv.prefs.CsvPreference;

public class CsvAnnotationBeanWriter<T>
extends ValidatableCsvBeanWriter {
    protected CsvAnnotationBeanParser beanParser = new CsvAnnotationBeanParser();
    protected final CsvBeanMapping<T> beanMapping;
    protected final BeanMappingCache mappingCache;

    public CsvAnnotationBeanWriter(Class<T> clazz, Writer writer, CsvPreference preferences) {
        this(clazz, writer, preferences, false);
    }

    public CsvAnnotationBeanWriter(Class<T> clazz, Writer writer, CsvPreference preferences, boolean ignoreValidationProcessor, CsvAnnotationBeanParser beanParser) {
        super(writer, preferences);
        this.beanParser = beanParser;
        this.beanMapping = beanParser.parse(clazz, ignoreValidationProcessor);
        this.mappingCache = new BeanMappingCache(this.beanMapping);
    }

    public CsvAnnotationBeanWriter(Class<T> clazz, Writer writer, CsvPreference preferences, boolean ignoreValidationProcessor) {
        super(writer, preferences);
        this.beanMapping = this.beanParser.parse(clazz, ignoreValidationProcessor);
        this.mappingCache = new BeanMappingCache(this.beanMapping);
    }

    public CsvAnnotationBeanWriter(CsvBeanMapping<T> beanMapping, Writer writer, CsvPreference preferences) {
        super(writer, preferences);
        this.beanMapping = beanMapping;
        this.mappingCache = new BeanMappingCache(this.beanMapping);
    }

    public boolean hasHeader() {
        return this.getBeanMapping().isHeader();
    }

    public void writeHeader() throws IOException {
        this.writeHeader(this.getMappingCache().getHeader());
    }

    public void write(T source) throws IOException {
        this.write(source, this.getMappingCache().getNameMapping(), this.getMappingCache().getOutputCellProcessors());
    }

    public void writeAll(Collection<T> collection) throws IOException {
        for (T item : collection) {
            this.write(item, this.getMappingCache().getNameMapping(), this.getMappingCache().getOutputCellProcessors());
        }
    }

    public CsvBeanMapping<T> getBeanMapping() {
        return this.beanMapping;
    }

    public BeanMappingCache getMappingCache() {
        return this.mappingCache;
    }
}

