/*
 * Decompiled with CFR 0.152.
 */
package org.supercsv.ext.io;

import java.io.IOException;
import java.io.Reader;
import org.supercsv.exception.SuperCsvException;
import org.supercsv.ext.builder.CsvAnnotationBeanParser;
import org.supercsv.ext.builder.CsvBeanMapping;
import org.supercsv.ext.exception.SuperCsvNoMatchColumnSizeException;
import org.supercsv.ext.exception.SuperCsvNoMatchHeaderException;
import org.supercsv.ext.io.BeanMappingCache;
import org.supercsv.ext.io.ValidatableCsvBeanReader;
import org.supercsv.prefs.CsvPreference;
import org.supercsv.util.CsvContext;

public class CsvAnnotationBeanReader<T>
extends ValidatableCsvBeanReader {
    protected CsvAnnotationBeanParser beanParser = new CsvAnnotationBeanParser();
    protected final CsvBeanMapping<T> beanMapping;
    protected final BeanMappingCache mappingCache;

    public CsvAnnotationBeanReader(Class<T> clazz, Reader reader, CsvPreference preferences) {
        super(reader, preferences);
        this.beanMapping = this.beanParser.parse(clazz);
        this.mappingCache = new BeanMappingCache(this.beanMapping);
    }

    public CsvAnnotationBeanReader(Class<T> clazz, Reader reader, CsvPreference preferences, CsvAnnotationBeanParser beanParser) {
        super(reader, preferences);
        this.beanParser = beanParser;
        this.beanMapping = beanParser.parse(clazz);
        this.mappingCache = new BeanMappingCache(this.beanMapping);
    }

    public CsvAnnotationBeanReader(CsvBeanMapping<T> beanMapping, Reader reader, CsvPreference preferences) {
        super(reader, preferences);
        this.beanMapping = beanMapping;
        this.mappingCache = new BeanMappingCache(this.beanMapping);
    }

    public boolean hasHeader() {
        return this.getBeanMapping().isHeader();
    }

    @Override
    public String[] getDefinedHeader() {
        return this.hasHeader() ? this.mappingCache.getHeader() : null;
    }

    public String[] getHeader() throws IOException {
        return super.getHeader(this.hasHeader());
    }

    public String[] readHeader(boolean checkedHeader) throws IOException {
        if (!this.getBeanMapping().isHeader()) {
            return null;
        }
        String[] originalHeader = super.getHeader(this.hasHeader());
        if (checkedHeader) {
            try {
                this.validateHeader(originalHeader, this.getDefinedHeader());
            }
            catch (SuperCsvException e) {
                this.getCsvErrors().addAll(this.exceptionConverter.convertCsvError(e, this.getDefinedHeader()));
                throw e;
            }
        }
        return originalHeader;
    }

    protected void validateHeader(String[] sourceHeader, String[] definedHeader) {
        if (sourceHeader.length != definedHeader.length) {
            CsvContext context = new CsvContext(1, 1, 1);
            throw new SuperCsvNoMatchColumnSizeException(sourceHeader.length, definedHeader.length, context);
        }
        int i = 0;
        while (i < sourceHeader.length) {
            if (!sourceHeader[i].equals(definedHeader[i])) {
                CsvContext context = new CsvContext(1, 1, i + 1);
                throw new SuperCsvNoMatchHeaderException(sourceHeader, definedHeader, context);
            }
            ++i;
        }
    }

    public T read() throws IOException {
        return this.read(this.getBeanMapping().getType(), this.getMappingCache().getNameMapping(), this.getMappingCache().getInputCellProcessors());
    }

    public CsvBeanMapping<T> getBeanMapping() {
        return this.beanMapping;
    }

    public BeanMappingCache getMappingCache() {
        return this.mappingCache;
    }
}

