/*
 * Decompiled with CFR 0.152.
 */
package org.supercsv.ext.exception;

import java.util.ArrayList;
import java.util.List;
import org.supercsv.exception.SuperCsvCellProcessorException;
import org.supercsv.exception.SuperCsvException;
import org.supercsv.util.CsvContext;

public class SuperCsvRowException
extends SuperCsvException {
    private static final long serialVersionUID = 1L;
    protected final List<SuperCsvException> columnErrors = new ArrayList<SuperCsvException>();

    public SuperCsvRowException(String msg, CsvContext context) {
        super(msg, context);
    }

    public void addError(SuperCsvException error) {
        this.columnErrors.add(error);
    }

    public void addError(SuperCsvCellProcessorException error) {
        SuperCsvCellProcessorException cloned = new SuperCsvCellProcessorException(error.getMessage(), this.cloneCsvContext(error.getCsvContext()), error.getProcessor());
        this.columnErrors.add((SuperCsvException)cloned);
    }

    private CsvContext cloneCsvContext(CsvContext context) {
        CsvContext cloned = new CsvContext(context.getLineNumber(), context.getRowNumber(), context.getColumnNumber());
        ArrayList destRowSource = new ArrayList(context.getRowSource().size());
        for (Object obj : context.getRowSource()) {
            destRowSource.add(obj);
        }
        cloned.setRowSource(destRowSource);
        return cloned;
    }

    public void addAllErrors(List<SuperCsvException> errors) {
        for (SuperCsvException error : errors) {
            this.addError(error);
        }
    }

    public List<SuperCsvException> getColumnErrors() {
        return this.columnErrors;
    }

    public boolean isEmptyColumnErrors() {
        return this.getColumnErrors().isEmpty();
    }

    public boolean isNotEmptyColumnErrors() {
        return !this.isEmptyColumnErrors();
    }
}

