/*
 * Decompiled with CFR 0.152.
 */
package org.supercsv.ext.cellprocessor.constraint;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.supercsv.cellprocessor.CellProcessorAdaptor;
import org.supercsv.cellprocessor.ift.CellProcessor;
import org.supercsv.cellprocessor.ift.DateCellProcessor;
import org.supercsv.exception.SuperCsvConstraintViolationException;
import org.supercsv.ext.cellprocessor.ift.ValidationCellProcessor;
import org.supercsv.util.CsvContext;

public class PastDate<T extends Date>
extends CellProcessorAdaptor
implements DateCellProcessor,
ValidationCellProcessor {
    protected final T max;

    public PastDate(T max) {
        PastDate.checkPreconditions(max);
        this.max = max;
    }

    public PastDate(T max, CellProcessor next) {
        super(next);
        PastDate.checkPreconditions(max);
        this.max = max;
    }

    protected static <T extends Date> void checkPreconditions(T max) {
        if (max == null) {
            throw new IllegalArgumentException("max should not be null");
        }
    }

    public Object execute(Object value, CsvContext context) {
        this.validateInputNotNull(value, context);
        if (!(value instanceof Comparable)) {
            throw new SuperCsvConstraintViolationException(String.format("the value '%s' could not implement Comparable interface.", value), context, (CellProcessor)this);
        }
        Date result = (Date)value;
        if (result.compareTo((Date)this.max) < 0) {
            throw new SuperCsvConstraintViolationException(String.format("%s does not lie the max (%s) values (inclusive)", result, this.max), context, (CellProcessor)this);
        }
        return this.next.execute((Object)result, context);
    }

    public T getMax() {
        return this.max;
    }

    @Override
    public String getMessageCode() {
        return String.valueOf(PastDate.class.getCanonicalName()) + ".violated";
    }

    @Override
    public Map<String, ?> getMessageVariable() {
        HashMap<String, T> vars = new HashMap<String, T>();
        vars.put("max", this.getMax());
        return vars;
    }

    @Override
    public String formatValue(Object value) {
        if (value == null) {
            return "";
        }
        return value.toString();
    }
}

