/*
 * Decompiled with CFR 0.152.
 */
package org.supercsv.ext.cellprocessor.constraint;

import java.util.HashMap;
import java.util.Map;
import org.supercsv.cellprocessor.CellProcessorAdaptor;
import org.supercsv.cellprocessor.ift.CellProcessor;
import org.supercsv.cellprocessor.ift.DoubleCellProcessor;
import org.supercsv.cellprocessor.ift.LongCellProcessor;
import org.supercsv.exception.SuperCsvConstraintViolationException;
import org.supercsv.ext.cellprocessor.ift.ValidationCellProcessor;
import org.supercsv.util.CsvContext;

public class Min<T extends Number>
extends CellProcessorAdaptor
implements LongCellProcessor,
DoubleCellProcessor,
ValidationCellProcessor {
    protected final T min;

    public Min(T min) {
        Min.checkPreconditions(min);
        this.min = min;
    }

    public Min(T min, CellProcessor next) {
        super(next);
        Min.checkPreconditions(min);
        this.min = min;
    }

    protected static <T extends Number> void checkPreconditions(T min) {
        if (min == null) {
            throw new IllegalArgumentException("min should not be null");
        }
    }

    public Object execute(Object value, CsvContext context) {
        this.validateInputNotNull(value, context);
        if (!(value instanceof Comparable)) {
            throw new SuperCsvConstraintViolationException(String.format("the value '%s' could not implement Comparable interface.", value), context, (CellProcessor)this);
        }
        Number result = (Number)value;
        if (((Comparable)((Object)result)).compareTo(this.min) < 0) {
            throw new SuperCsvConstraintViolationException(String.format("%s does not lie the min (%s) values (inclusive)", result, this.min), context, (CellProcessor)this);
        }
        return this.next.execute((Object)result, context);
    }

    public T getMin() {
        return this.min;
    }

    @Override
    public String getMessageCode() {
        return String.valueOf(Min.class.getCanonicalName()) + ".violated";
    }

    @Override
    public Map<String, ?> getMessageVariable() {
        HashMap<String, T> vars = new HashMap<String, T>();
        vars.put("min", this.getMin());
        return vars;
    }

    @Override
    public String formatValue(Object value) {
        if (value == null) {
            return "";
        }
        return value.toString();
    }
}

