/*
 * Decompiled with CFR 0.152.
 */
package org.supercsv.ext.builder;

import java.lang.annotation.Annotation;
import org.supercsv.cellprocessor.constraint.ForbidSubStr;
import org.supercsv.cellprocessor.constraint.RequireSubStr;
import org.supercsv.cellprocessor.constraint.StrNotNullOrEmpty;
import org.supercsv.cellprocessor.constraint.StrRegEx;
import org.supercsv.cellprocessor.constraint.Strlen;
import org.supercsv.cellprocessor.ift.CellProcessor;
import org.supercsv.cellprocessor.ift.StringCellProcessor;
import org.supercsv.ext.annotation.CsvStringConverter;
import org.supercsv.ext.builder.AbstractCellProcessorBuilder;
import org.supercsv.ext.cellprocessor.constraint.Length;
import org.supercsv.ext.cellprocessor.constraint.MaxLength;
import org.supercsv.ext.cellprocessor.constraint.MinLength;

public class StringCellProcessorBuilder
extends AbstractCellProcessorBuilder<String> {
    public static final String CONVERT_NULL_STRING_EMPTY = "@empty";

    protected CsvStringConverter getAnnotation(Annotation[] annos) {
        if (annos == null || annos.length == 0) {
            return null;
        }
        Annotation[] annotationArray = annos;
        int n = annos.length;
        int n2 = 0;
        while (n2 < n) {
            Annotation anno = annotationArray[n2];
            if (anno instanceof CsvStringConverter) {
                return (CsvStringConverter)anno;
            }
            ++n2;
        }
        return null;
    }

    protected Integer getMinLength(CsvStringConverter converterAnno) {
        if (converterAnno == null) {
            return null;
        }
        if (converterAnno.minLength() < 0) {
            return null;
        }
        return converterAnno.minLength();
    }

    protected Integer getMaxLength(CsvStringConverter converterAnno) {
        if (converterAnno == null) {
            return null;
        }
        if (converterAnno.maxLength() < 0) {
            return null;
        }
        return converterAnno.maxLength();
    }

    protected Integer getExactLength(CsvStringConverter converterAnno) {
        if (converterAnno == null) {
            return null;
        }
        if (converterAnno.exactLength() < 0) {
            return null;
        }
        return converterAnno.exactLength();
    }

    protected String getRegex(CsvStringConverter converterAnno) {
        if (converterAnno == null) {
            return "";
        }
        return converterAnno.regex();
    }

    protected String[] getForbid(CsvStringConverter converterAnno) {
        if (converterAnno == null) {
            return new String[0];
        }
        return converterAnno.forbid();
    }

    protected String[] getContain(CsvStringConverter converterAnno) {
        if (converterAnno == null) {
            return new String[0];
        }
        return converterAnno.contain();
    }

    protected boolean getNotEmpty(CsvStringConverter converterAnno) {
        if (converterAnno == null) {
            return false;
        }
        return converterAnno.notEmpty();
    }

    @Override
    public CellProcessor buildOutputCellProcessor(Class<String> type, Annotation[] annos, CellProcessor processor, boolean ignoreValidationProcessor) {
        CsvStringConverter converterAnno = this.getAnnotation(annos);
        Integer minLength = this.getMinLength(converterAnno);
        Integer maxLength = this.getMaxLength(converterAnno);
        Integer exactLength = this.getExactLength(converterAnno);
        String regex = this.getRegex(converterAnno);
        String[] forbid = this.getForbid(converterAnno);
        String[] contain = this.getContain(converterAnno);
        boolean notEmpty = this.getNotEmpty(converterAnno);
        CellProcessor cellProcessor = processor;
        if (!ignoreValidationProcessor) {
            cellProcessor = this.prependRegExProcessor(cellProcessor, regex);
            cellProcessor = this.prependLengthProcessor(cellProcessor, minLength, maxLength, exactLength);
            cellProcessor = this.prependForbidProcessor(cellProcessor, forbid);
            cellProcessor = this.prependContainProcessor(cellProcessor, contain);
            cellProcessor = this.prependNotEmptyProcessor(cellProcessor, notEmpty);
        }
        return cellProcessor;
    }

    @Override
    public CellProcessor buildInputCellProcessor(Class<String> type, Annotation[] annos, CellProcessor processor) {
        CsvStringConverter converterAnno = this.getAnnotation(annos);
        Integer minLength = this.getMinLength(converterAnno);
        Integer maxLength = this.getMaxLength(converterAnno);
        Integer exactLength = this.getExactLength(converterAnno);
        String regex = this.getRegex(converterAnno);
        String[] forbid = this.getForbid(converterAnno);
        String[] contain = this.getContain(converterAnno);
        boolean notEmpty = this.getNotEmpty(converterAnno);
        CellProcessor cellProcessor = processor;
        cellProcessor = this.prependRegExProcessor(cellProcessor, regex);
        cellProcessor = this.prependLengthProcessor(cellProcessor, minLength, maxLength, exactLength);
        cellProcessor = this.prependForbidProcessor(cellProcessor, forbid);
        cellProcessor = this.prependContainProcessor(cellProcessor, contain);
        cellProcessor = this.prependNotEmptyProcessor(cellProcessor, notEmpty);
        return cellProcessor;
    }

    protected CellProcessor prependLengthProcessor(CellProcessor processor, Integer minLength, Integer maxLength, Integer exactLength) {
        Object cellProcessor = processor;
        if (minLength != null && maxLength != null) {
            cellProcessor = cellProcessor == null ? new Length(minLength, maxLength) : new Length(minLength, maxLength, (CellProcessor)cellProcessor);
        } else if (minLength != null) {
            cellProcessor = cellProcessor == null ? new MinLength(minLength) : new MinLength(minLength, (CellProcessor)cellProcessor);
        } else if (maxLength != null) {
            cellProcessor = cellProcessor == null ? new MaxLength(maxLength) : new MaxLength(maxLength, (CellProcessor)cellProcessor);
        } else if (exactLength != null) {
            cellProcessor = cellProcessor == null ? new Strlen(new int[]{exactLength}) : new Strlen(exactLength.intValue(), cellProcessor);
        }
        return cellProcessor;
    }

    protected CellProcessor prependRegExProcessor(CellProcessor processor, String regex) {
        CellProcessor cellProcessor = processor;
        if (regex.isEmpty()) {
            return cellProcessor;
        }
        cellProcessor = cellProcessor == null ? new StrRegEx(regex) : new StrRegEx(regex, (StringCellProcessor)cellProcessor);
        return cellProcessor;
    }

    protected CellProcessor prependForbidProcessor(CellProcessor processor, String[] forbid) {
        CellProcessor cellProcessor = processor;
        if (forbid == null || forbid.length == 0) {
            return cellProcessor;
        }
        cellProcessor = cellProcessor == null ? new ForbidSubStr(forbid) : new ForbidSubStr(forbid, (CellProcessor)((StringCellProcessor)cellProcessor));
        return cellProcessor;
    }

    protected CellProcessor prependContainProcessor(CellProcessor processor, String[] contain) {
        CellProcessor cellProcessor = processor;
        if (contain == null || contain.length == 0) {
            return cellProcessor;
        }
        cellProcessor = cellProcessor == null ? new RequireSubStr(contain) : new RequireSubStr(contain, (CellProcessor)((StringCellProcessor)cellProcessor));
        return cellProcessor;
    }

    protected CellProcessor prependNotEmptyProcessor(CellProcessor processor, boolean notEmpty) {
        CellProcessor cellProcessor = processor;
        if (!notEmpty) {
            return cellProcessor;
        }
        cellProcessor = cellProcessor == null ? new StrNotNullOrEmpty() : new StrNotNullOrEmpty((CellProcessor)((StringCellProcessor)cellProcessor));
        return cellProcessor;
    }

    @Override
    public String getParseValue(Class<String> type, Annotation[] annos, String defaultValue) {
        if (defaultValue.equals(CONVERT_NULL_STRING_EMPTY)) {
            return "";
        }
        return defaultValue;
    }
}

