/*
 * Decompiled with CFR 0.152.
 */
package org.supercsv.ext.builder;

import java.lang.annotation.Annotation;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Currency;
import java.util.Locale;
import org.supercsv.cellprocessor.ParseBigDecimal;
import org.supercsv.cellprocessor.ParseDouble;
import org.supercsv.cellprocessor.ParseInt;
import org.supercsv.cellprocessor.ParseLong;
import org.supercsv.cellprocessor.ift.CellProcessor;
import org.supercsv.cellprocessor.ift.DoubleCellProcessor;
import org.supercsv.cellprocessor.ift.LongCellProcessor;
import org.supercsv.cellprocessor.ift.StringCellProcessor;
import org.supercsv.ext.Utils;
import org.supercsv.ext.annotation.CsvNumberConverter;
import org.supercsv.ext.builder.AbstractCellProcessorBuilder;
import org.supercsv.ext.cellprocessor.FormatLocaleNumber;
import org.supercsv.ext.cellprocessor.ParseBigInteger;
import org.supercsv.ext.cellprocessor.ParseByte;
import org.supercsv.ext.cellprocessor.ParseFloat;
import org.supercsv.ext.cellprocessor.ParseLocaleNumber;
import org.supercsv.ext.cellprocessor.ParseShort;
import org.supercsv.ext.cellprocessor.constraint.Max;
import org.supercsv.ext.cellprocessor.constraint.Min;
import org.supercsv.ext.cellprocessor.constraint.Range;
import org.supercsv.ext.exception.SuperCsvInvalidAnnotationException;

public abstract class NumberCellProcessorBuilder<N extends Number>
extends AbstractCellProcessorBuilder<N> {
    protected CsvNumberConverter getAnnotation(Annotation[] annos) {
        if (annos == null || annos.length == 0) {
            return null;
        }
        Annotation[] annotationArray = annos;
        int n = annos.length;
        int n2 = 0;
        while (n2 < n) {
            Annotation anno = annotationArray[n2];
            if (anno instanceof CsvNumberConverter) {
                return (CsvNumberConverter)anno;
            }
            ++n2;
        }
        return null;
    }

    protected String getPattern(CsvNumberConverter converterAnno) {
        if (converterAnno == null) {
            return "";
        }
        return converterAnno.pattern();
    }

    protected boolean getLenient(CsvNumberConverter converterAnno) {
        if (converterAnno == null) {
            return false;
        }
        return converterAnno.lenient();
    }

    protected String getMin(CsvNumberConverter converterAnno) {
        if (converterAnno == null) {
            return "";
        }
        return converterAnno.min();
    }

    protected String getMax(CsvNumberConverter converterAnno) {
        if (converterAnno == null) {
            return "";
        }
        return converterAnno.max();
    }

    protected Locale getLocale(CsvNumberConverter converterAnno) {
        if (converterAnno == null) {
            return Locale.getDefault();
        }
        return Utils.getLocale(converterAnno.locale());
    }

    protected Currency getCurrency(CsvNumberConverter converterAnno) {
        if (converterAnno == null) {
            return null;
        }
        if (converterAnno.currency().isEmpty()) {
            return null;
        }
        return Currency.getInstance(converterAnno.currency());
    }

    public static ByteCellProcessorBuilder newByte() {
        return new ByteCellProcessorBuilder();
    }

    public static ShortCellProcessorBuilder newShort() {
        return new ShortCellProcessorBuilder();
    }

    public static IntegerCellProcessorBuilder newInteger() {
        return new IntegerCellProcessorBuilder();
    }

    public static LongCellProcessorBuilder newLong() {
        return new LongCellProcessorBuilder();
    }

    public static FloatCellProcessorBuilder newFloat() {
        return new FloatCellProcessorBuilder();
    }

    public static DoubleCellProcessorBuilder newDouble() {
        return new DoubleCellProcessorBuilder();
    }

    public static BigDecimalCellProcessorBuilder newBigDecimal() {
        return new BigDecimalCellProcessorBuilder();
    }

    public static BigIntegerCellProcessorBuilder newBigInteger() {
        return new BigIntegerCellProcessorBuilder();
    }

    protected CellProcessor prependRangeProcessor(N min, N max, CellProcessor processor) {
        Object cellProcessor = processor;
        if (min != null && max != null) {
            cellProcessor = cellProcessor == null ? new Range<N>(min, max) : new Range<N>(min, max, (CellProcessor)cellProcessor);
        } else if (min != null) {
            cellProcessor = cellProcessor == null ? new Min<N>(min) : new Min<N>(min, (CellProcessor)cellProcessor);
        } else if (max != null) {
            cellProcessor = cellProcessor == null ? new Max<N>(max) : new Max<N>(max, (CellProcessor)cellProcessor);
        }
        return cellProcessor;
    }

    protected NumberFormat createNumberFormat(String pattern, boolean lenient, Currency currency, DecimalFormatSymbols symbols) {
        if (pattern.isEmpty()) {
            return null;
        }
        DecimalFormat value = null;
        value = symbols != null ? new DecimalFormat(pattern, symbols) : new DecimalFormat(pattern);
        value.setParseBigDecimal(true);
        if (currency != null) {
            value.setCurrency(currency);
        }
        return value;
    }

    public static class BigDecimalCellProcessorBuilder
    extends NumberCellProcessorBuilder<BigDecimal> {
        @Override
        public CellProcessor buildOutputCellProcessor(Class<BigDecimal> type, Annotation[] annos, CellProcessor processor, boolean ignoreValidationProcessor) {
            CsvNumberConverter converterAnno = this.getAnnotation(annos);
            String pattern = this.getPattern(converterAnno);
            boolean lenient = this.getLenient(converterAnno);
            Locale locale = this.getLocale(converterAnno);
            Currency currency = this.getCurrency(converterAnno);
            DecimalFormatSymbols symbols = DecimalFormatSymbols.getInstance(locale);
            NumberFormat formatter = this.createNumberFormat(pattern, lenient, currency, symbols);
            BigDecimal min = this.parseNumber(this.getMin(converterAnno), formatter);
            BigDecimal max = this.parseNumber(this.getMax(converterAnno), formatter);
            Object cellProcessor = processor;
            if (formatter != null) {
                FormatLocaleNumber formatLocaleNumber = cellProcessor = cellProcessor == null ? new FormatLocaleNumber(formatter) : new FormatLocaleNumber(formatter, (StringCellProcessor)cellProcessor);
            }
            if (!ignoreValidationProcessor) {
                cellProcessor = this.prependRangeProcessor(min, max, (CellProcessor)cellProcessor);
            }
            return cellProcessor;
        }

        @Override
        public CellProcessor buildInputCellProcessor(Class<BigDecimal> type, Annotation[] annos, CellProcessor processor) {
            CsvNumberConverter converterAnno = this.getAnnotation(annos);
            String pattern = this.getPattern(converterAnno);
            boolean lenient = this.getLenient(converterAnno);
            Locale locale = this.getLocale(converterAnno);
            Currency currency = this.getCurrency(converterAnno);
            DecimalFormatSymbols symbols = DecimalFormatSymbols.getInstance(locale);
            NumberFormat formatter = this.createNumberFormat(pattern, lenient, currency, symbols);
            BigDecimal min = this.parseNumber(this.getMin(converterAnno), formatter);
            BigDecimal max = this.parseNumber(this.getMax(converterAnno), formatter);
            Object cellProcessor = processor;
            cellProcessor = this.prependRangeProcessor(min, max, (CellProcessor)cellProcessor);
            cellProcessor = formatter != null ? (cellProcessor == null ? new ParseLocaleNumber<BigDecimal>(type, pattern, lenient, currency, symbols) : new ParseLocaleNumber<BigDecimal>(type, pattern, lenient, currency, symbols, (CellProcessor)cellProcessor)) : (cellProcessor == null ? new ParseBigDecimal() : new ParseBigDecimal(cellProcessor));
            return cellProcessor;
        }

        protected BigDecimal parseNumber(String value, NumberFormat formatter) {
            if (value.isEmpty()) {
                return null;
            }
            if (formatter != null) {
                try {
                    return (BigDecimal)formatter.parse(value);
                }
                catch (ParseException e) {
                    throw new SuperCsvInvalidAnnotationException(String.format(" value '%s' cannot parse to BigDecimal", value, formatter), e);
                }
            }
            return new BigDecimal(value);
        }

        @Override
        public BigDecimal getParseValue(Class<BigDecimal> type, Annotation[] annos, String defaultValue) {
            CsvNumberConverter converterAnno = this.getAnnotation(annos);
            String pattern = this.getPattern(converterAnno);
            boolean lenient = this.getLenient(converterAnno);
            Locale locale = this.getLocale(converterAnno);
            Currency currency = this.getCurrency(converterAnno);
            DecimalFormatSymbols symbols = DecimalFormatSymbols.getInstance(locale);
            NumberFormat formatter = this.createNumberFormat(pattern, lenient, currency, symbols);
            return this.parseNumber(defaultValue, formatter);
        }
    }

    public static class BigIntegerCellProcessorBuilder
    extends NumberCellProcessorBuilder<BigInteger> {
        @Override
        public CellProcessor buildOutputCellProcessor(Class<BigInteger> type, Annotation[] annos, CellProcessor processor, boolean ignoreValidationProcessor) {
            CsvNumberConverter converterAnno = this.getAnnotation(annos);
            String pattern = this.getPattern(converterAnno);
            boolean lenient = this.getLenient(converterAnno);
            Locale locale = this.getLocale(converterAnno);
            Currency currency = this.getCurrency(converterAnno);
            DecimalFormatSymbols symbols = DecimalFormatSymbols.getInstance(locale);
            NumberFormat formatter = this.createNumberFormat(pattern, lenient, currency, symbols);
            BigInteger min = this.parseNumber(this.getMin(converterAnno), formatter);
            BigInteger max = this.parseNumber(this.getMax(converterAnno), formatter);
            Object cellProcessor = processor;
            if (formatter != null) {
                FormatLocaleNumber formatLocaleNumber = cellProcessor = cellProcessor == null ? new FormatLocaleNumber(formatter) : new FormatLocaleNumber(formatter, (StringCellProcessor)cellProcessor);
            }
            if (!ignoreValidationProcessor) {
                cellProcessor = this.prependRangeProcessor(min, max, (CellProcessor)cellProcessor);
            }
            return cellProcessor;
        }

        @Override
        public CellProcessor buildInputCellProcessor(Class<BigInteger> type, Annotation[] annos, CellProcessor processor) {
            CsvNumberConverter converterAnno = this.getAnnotation(annos);
            String pattern = this.getPattern(converterAnno);
            boolean lenient = this.getLenient(converterAnno);
            Locale locale = this.getLocale(converterAnno);
            Currency currency = this.getCurrency(converterAnno);
            DecimalFormatSymbols symbols = DecimalFormatSymbols.getInstance(locale);
            NumberFormat formatter = this.createNumberFormat(pattern, lenient, currency, symbols);
            BigInteger min = this.parseNumber(this.getMin(converterAnno), formatter);
            BigInteger max = this.parseNumber(this.getMax(converterAnno), formatter);
            Object cellProcessor = processor;
            cellProcessor = this.prependRangeProcessor(min, max, (CellProcessor)cellProcessor);
            cellProcessor = formatter != null ? (cellProcessor == null ? new ParseBigInteger() : new ParseBigInteger((CellProcessor)cellProcessor)) : (cellProcessor == null ? new ParseLocaleNumber<BigInteger>(type, pattern, lenient, currency, symbols) : new ParseLocaleNumber<BigInteger>(type, pattern, lenient, currency, symbols, (CellProcessor)cellProcessor));
            return cellProcessor;
        }

        protected BigInteger parseNumber(String value, NumberFormat formatter) {
            if (value.isEmpty()) {
                return null;
            }
            if (formatter != null) {
                try {
                    return ((BigDecimal)formatter.parse(value)).toBigIntegerExact();
                }
                catch (ParseException e) {
                    throw new SuperCsvInvalidAnnotationException(String.format(" value '%s' cannot parse to BigInteger", value, formatter), e);
                }
            }
            return new BigInteger(value);
        }

        @Override
        public BigInteger getParseValue(Class<BigInteger> type, Annotation[] annos, String defaultValue) {
            CsvNumberConverter converterAnno = this.getAnnotation(annos);
            String pattern = this.getPattern(converterAnno);
            boolean lenient = this.getLenient(converterAnno);
            Locale locale = this.getLocale(converterAnno);
            Currency currency = this.getCurrency(converterAnno);
            DecimalFormatSymbols symbols = DecimalFormatSymbols.getInstance(locale);
            NumberFormat formatter = this.createNumberFormat(pattern, lenient, currency, symbols);
            return this.parseNumber(defaultValue, formatter);
        }
    }

    public static class ByteCellProcessorBuilder
    extends NumberCellProcessorBuilder<Byte> {
        @Override
        public CellProcessor buildOutputCellProcessor(Class<Byte> type, Annotation[] annos, CellProcessor processor, boolean ignoreValidationProcessor) {
            CsvNumberConverter converterAnno = this.getAnnotation(annos);
            String pattern = this.getPattern(converterAnno);
            boolean lenient = this.getLenient(converterAnno);
            Locale locale = this.getLocale(converterAnno);
            Currency currency = this.getCurrency(converterAnno);
            DecimalFormatSymbols symbols = DecimalFormatSymbols.getInstance(locale);
            NumberFormat formatter = this.createNumberFormat(pattern, lenient, currency, symbols);
            Byte min = this.parseNumber(this.getMin(converterAnno), formatter);
            Byte max = this.parseNumber(this.getMax(converterAnno), formatter);
            Object cellProcessor = processor;
            if (formatter != null) {
                FormatLocaleNumber formatLocaleNumber = cellProcessor = cellProcessor == null ? new FormatLocaleNumber(formatter) : new FormatLocaleNumber(formatter, (StringCellProcessor)cellProcessor);
            }
            if (!ignoreValidationProcessor) {
                cellProcessor = this.prependRangeProcessor(min, max, (CellProcessor)cellProcessor);
            }
            return cellProcessor;
        }

        @Override
        public CellProcessor buildInputCellProcessor(Class<Byte> type, Annotation[] annos, CellProcessor processor) {
            CsvNumberConverter converterAnno = this.getAnnotation(annos);
            String pattern = this.getPattern(converterAnno);
            boolean lenient = this.getLenient(converterAnno);
            Locale locale = this.getLocale(converterAnno);
            Currency currency = this.getCurrency(converterAnno);
            DecimalFormatSymbols symbols = DecimalFormatSymbols.getInstance(locale);
            NumberFormat formatter = this.createNumberFormat(pattern, lenient, currency, symbols);
            Byte min = this.parseNumber(this.getMin(converterAnno), formatter);
            Byte max = this.parseNumber(this.getMax(converterAnno), formatter);
            Object cellProcessor = processor;
            cellProcessor = this.prependRangeProcessor(min, max, (CellProcessor)cellProcessor);
            cellProcessor = formatter != null ? (cellProcessor == null ? new ParseLocaleNumber<Byte>(type, pattern, lenient, currency, symbols) : new ParseLocaleNumber<Byte>(type, pattern, lenient, currency, symbols, (CellProcessor)cellProcessor)) : (cellProcessor == null ? new ParseByte() : new ParseByte((LongCellProcessor)cellProcessor));
            return cellProcessor;
        }

        protected Byte parseNumber(String value, NumberFormat formatter) {
            if (value.isEmpty()) {
                return null;
            }
            if (formatter != null) {
                try {
                    return formatter.parse(value).byteValue();
                }
                catch (ParseException e) {
                    throw new SuperCsvInvalidAnnotationException(String.format(" value '%s' cannot parse to Byte", value, formatter), e);
                }
            }
            return Byte.valueOf(value);
        }

        @Override
        public Byte getParseValue(Class<Byte> type, Annotation[] annos, String defaultValue) {
            CsvNumberConverter converterAnno = this.getAnnotation(annos);
            String pattern = this.getPattern(converterAnno);
            boolean lenient = this.getLenient(converterAnno);
            Locale locale = this.getLocale(converterAnno);
            Currency currency = this.getCurrency(converterAnno);
            DecimalFormatSymbols symbols = DecimalFormatSymbols.getInstance(locale);
            NumberFormat formatter = this.createNumberFormat(pattern, lenient, currency, symbols);
            return this.parseNumber(defaultValue, formatter);
        }
    }

    public static class DoubleCellProcessorBuilder
    extends NumberCellProcessorBuilder<Double> {
        @Override
        public CellProcessor buildOutputCellProcessor(Class<Double> type, Annotation[] annos, CellProcessor processor, boolean ignoreValidationProcessor) {
            CsvNumberConverter converterAnno = this.getAnnotation(annos);
            String pattern = this.getPattern(converterAnno);
            boolean lenient = this.getLenient(converterAnno);
            Locale locale = this.getLocale(converterAnno);
            Currency currency = this.getCurrency(converterAnno);
            DecimalFormatSymbols symbols = DecimalFormatSymbols.getInstance(locale);
            NumberFormat formatter = this.createNumberFormat(pattern, lenient, currency, symbols);
            Double min = this.parseNumber(this.getMin(converterAnno), formatter);
            Double max = this.parseNumber(this.getMax(converterAnno), formatter);
            Object cellProcessor = processor;
            if (formatter != null) {
                FormatLocaleNumber formatLocaleNumber = cellProcessor = cellProcessor == null ? new FormatLocaleNumber(formatter) : new FormatLocaleNumber(formatter, (StringCellProcessor)cellProcessor);
            }
            if (!ignoreValidationProcessor) {
                cellProcessor = this.prependRangeProcessor(min, max, (CellProcessor)cellProcessor);
            }
            return cellProcessor;
        }

        @Override
        public CellProcessor buildInputCellProcessor(Class<Double> type, Annotation[] annos, CellProcessor processor) {
            CsvNumberConverter converterAnno = this.getAnnotation(annos);
            String pattern = this.getPattern(converterAnno);
            boolean lenient = this.getLenient(converterAnno);
            Locale locale = this.getLocale(converterAnno);
            Currency currency = this.getCurrency(converterAnno);
            DecimalFormatSymbols symbols = DecimalFormatSymbols.getInstance(locale);
            NumberFormat formatter = this.createNumberFormat(pattern, lenient, currency, symbols);
            Double min = this.parseNumber(this.getMin(converterAnno), formatter);
            Double max = this.parseNumber(this.getMax(converterAnno), formatter);
            Object cellProcessor = processor;
            cellProcessor = this.prependRangeProcessor(min, max, (CellProcessor)cellProcessor);
            cellProcessor = formatter != null ? (cellProcessor == null ? new ParseLocaleNumber<Double>(type, pattern, lenient, currency, symbols) : new ParseLocaleNumber<Double>(type, pattern, lenient, currency, symbols, (CellProcessor)cellProcessor)) : (cellProcessor == null ? new ParseDouble() : new ParseDouble((DoubleCellProcessor)cellProcessor));
            return cellProcessor;
        }

        protected Double parseNumber(String value, NumberFormat formatter) {
            if (value.isEmpty()) {
                return null;
            }
            if (formatter != null) {
                try {
                    return formatter.parse(value).doubleValue();
                }
                catch (ParseException e) {
                    throw new SuperCsvInvalidAnnotationException(String.format(" value '%s' cannot parse to Double", value, formatter), e);
                }
            }
            return Double.valueOf(value);
        }

        @Override
        public Double getParseValue(Class<Double> type, Annotation[] annos, String defaultValue) {
            CsvNumberConverter converterAnno = this.getAnnotation(annos);
            String pattern = this.getPattern(converterAnno);
            boolean lenient = this.getLenient(converterAnno);
            Locale locale = this.getLocale(converterAnno);
            Currency currency = this.getCurrency(converterAnno);
            DecimalFormatSymbols symbols = DecimalFormatSymbols.getInstance(locale);
            NumberFormat formatter = this.createNumberFormat(pattern, lenient, currency, symbols);
            return this.parseNumber(defaultValue, formatter);
        }
    }

    public static class FloatCellProcessorBuilder
    extends NumberCellProcessorBuilder<Float> {
        @Override
        public CellProcessor buildOutputCellProcessor(Class<Float> type, Annotation[] annos, CellProcessor processor, boolean ignoreValidationProcessor) {
            CsvNumberConverter converterAnno = this.getAnnotation(annos);
            String pattern = this.getPattern(converterAnno);
            boolean lenient = this.getLenient(converterAnno);
            Locale locale = this.getLocale(converterAnno);
            Currency currency = this.getCurrency(converterAnno);
            DecimalFormatSymbols symbols = DecimalFormatSymbols.getInstance(locale);
            NumberFormat formatter = this.createNumberFormat(pattern, lenient, currency, symbols);
            Float min = this.parseNumber(this.getMin(converterAnno), formatter);
            Float max = this.parseNumber(this.getMax(converterAnno), formatter);
            Object cellProcessor = processor;
            if (formatter != null) {
                FormatLocaleNumber formatLocaleNumber = cellProcessor = cellProcessor == null ? new FormatLocaleNumber(formatter) : new FormatLocaleNumber(formatter, (StringCellProcessor)cellProcessor);
            }
            if (!ignoreValidationProcessor) {
                cellProcessor = this.prependRangeProcessor(min, max, (CellProcessor)cellProcessor);
            }
            return cellProcessor;
        }

        @Override
        public CellProcessor buildInputCellProcessor(Class<Float> type, Annotation[] annos, CellProcessor processor) {
            CsvNumberConverter converterAnno = this.getAnnotation(annos);
            String pattern = this.getPattern(converterAnno);
            boolean lenient = this.getLenient(converterAnno);
            Locale locale = this.getLocale(converterAnno);
            Currency currency = this.getCurrency(converterAnno);
            DecimalFormatSymbols symbols = DecimalFormatSymbols.getInstance(locale);
            NumberFormat formatter = this.createNumberFormat(pattern, lenient, currency, symbols);
            Float min = this.parseNumber(this.getMin(converterAnno), formatter);
            Float max = this.parseNumber(this.getMax(converterAnno), formatter);
            Object cellProcessor = processor;
            cellProcessor = this.prependRangeProcessor(min, max, (CellProcessor)cellProcessor);
            cellProcessor = formatter != null ? (cellProcessor == null ? new ParseLocaleNumber<Float>(type, pattern, lenient, currency, symbols) : new ParseLocaleNumber<Float>(type, pattern, lenient, currency, symbols, (CellProcessor)cellProcessor)) : (cellProcessor == null ? new ParseFloat() : new ParseFloat((DoubleCellProcessor)cellProcessor));
            return cellProcessor;
        }

        protected Float parseNumber(String value, NumberFormat formatter) {
            if (value.isEmpty()) {
                return null;
            }
            if (formatter != null) {
                try {
                    return Float.valueOf(formatter.parse(value).floatValue());
                }
                catch (ParseException e) {
                    throw new SuperCsvInvalidAnnotationException(String.format(" value '%s' cannot parse to Float", value, formatter), e);
                }
            }
            return Float.valueOf(value);
        }

        @Override
        public Float getParseValue(Class<Float> type, Annotation[] annos, String defaultValue) {
            CsvNumberConverter converterAnno = this.getAnnotation(annos);
            String pattern = this.getPattern(converterAnno);
            boolean lenient = this.getLenient(converterAnno);
            Locale locale = this.getLocale(converterAnno);
            Currency currency = this.getCurrency(converterAnno);
            DecimalFormatSymbols symbols = DecimalFormatSymbols.getInstance(locale);
            NumberFormat formatter = this.createNumberFormat(pattern, lenient, currency, symbols);
            return this.parseNumber(defaultValue, formatter);
        }
    }

    public static class IntegerCellProcessorBuilder
    extends NumberCellProcessorBuilder<Integer> {
        @Override
        public CellProcessor buildOutputCellProcessor(Class<Integer> type, Annotation[] annos, CellProcessor processor, boolean ignoreValidationProcessor) {
            CsvNumberConverter converterAnno = this.getAnnotation(annos);
            String pattern = this.getPattern(converterAnno);
            boolean lenient = this.getLenient(converterAnno);
            Locale locale = this.getLocale(converterAnno);
            Currency currency = this.getCurrency(converterAnno);
            DecimalFormatSymbols symbols = DecimalFormatSymbols.getInstance(locale);
            NumberFormat formatter = this.createNumberFormat(pattern, lenient, currency, symbols);
            Integer min = this.parseNumber(this.getMin(converterAnno), formatter);
            Integer max = this.parseNumber(this.getMax(converterAnno), formatter);
            Object cellProcessor = processor;
            if (formatter != null) {
                FormatLocaleNumber formatLocaleNumber = cellProcessor = cellProcessor == null ? new FormatLocaleNumber(formatter) : new FormatLocaleNumber(formatter, (StringCellProcessor)cellProcessor);
            }
            if (!ignoreValidationProcessor) {
                cellProcessor = this.prependRangeProcessor(min, max, (CellProcessor)cellProcessor);
            }
            return cellProcessor;
        }

        @Override
        public CellProcessor buildInputCellProcessor(Class<Integer> type, Annotation[] annos, CellProcessor processor) {
            CsvNumberConverter converterAnno = this.getAnnotation(annos);
            String pattern = this.getPattern(converterAnno);
            boolean lenient = this.getLenient(converterAnno);
            Locale locale = this.getLocale(converterAnno);
            Currency currency = this.getCurrency(converterAnno);
            DecimalFormatSymbols symbols = DecimalFormatSymbols.getInstance(locale);
            NumberFormat formatter = this.createNumberFormat(pattern, lenient, currency, symbols);
            Integer min = this.parseNumber(this.getMin(converterAnno), formatter);
            Integer max = this.parseNumber(this.getMax(converterAnno), formatter);
            Object cellProcessor = processor;
            cellProcessor = this.prependRangeProcessor(min, max, (CellProcessor)cellProcessor);
            cellProcessor = formatter != null ? (cellProcessor == null ? new ParseLocaleNumber<Integer>(type, pattern, lenient, currency, symbols) : new ParseLocaleNumber<Integer>(type, pattern, lenient, currency, symbols, (CellProcessor)cellProcessor)) : (cellProcessor == null ? new ParseInt() : new ParseInt((LongCellProcessor)cellProcessor));
            return cellProcessor;
        }

        protected Integer parseNumber(String value, NumberFormat formatter) {
            if (value.isEmpty()) {
                return null;
            }
            if (formatter != null) {
                try {
                    return formatter.parse(value).intValue();
                }
                catch (ParseException e) {
                    throw new SuperCsvInvalidAnnotationException(String.format(" value '%s' cannot parse to Integer", value, formatter), e);
                }
            }
            return Integer.valueOf(value);
        }

        @Override
        public Integer getParseValue(Class<Integer> type, Annotation[] annos, String defaultValue) {
            CsvNumberConverter converterAnno = this.getAnnotation(annos);
            String pattern = this.getPattern(converterAnno);
            boolean lenient = this.getLenient(converterAnno);
            Locale locale = this.getLocale(converterAnno);
            Currency currency = this.getCurrency(converterAnno);
            DecimalFormatSymbols symbols = DecimalFormatSymbols.getInstance(locale);
            NumberFormat formatter = this.createNumberFormat(pattern, lenient, currency, symbols);
            return this.parseNumber(defaultValue, formatter);
        }
    }

    public static class LongCellProcessorBuilder
    extends NumberCellProcessorBuilder<Long> {
        @Override
        public CellProcessor buildOutputCellProcessor(Class<Long> type, Annotation[] annos, CellProcessor processor, boolean ignoreValidationProcessor) {
            CsvNumberConverter converterAnno = this.getAnnotation(annos);
            String pattern = this.getPattern(converterAnno);
            boolean lenient = this.getLenient(converterAnno);
            Locale locale = this.getLocale(converterAnno);
            Currency currency = this.getCurrency(converterAnno);
            DecimalFormatSymbols symbols = DecimalFormatSymbols.getInstance(locale);
            NumberFormat formatter = this.createNumberFormat(pattern, lenient, currency, symbols);
            Long min = this.parseNumber(this.getMin(converterAnno), formatter);
            Long max = this.parseNumber(this.getMax(converterAnno), formatter);
            Object cellProcessor = processor;
            if (formatter != null) {
                FormatLocaleNumber formatLocaleNumber = cellProcessor = cellProcessor == null ? new FormatLocaleNumber(formatter) : new FormatLocaleNumber(formatter, (StringCellProcessor)cellProcessor);
            }
            if (!ignoreValidationProcessor) {
                cellProcessor = this.prependRangeProcessor(min, max, (CellProcessor)cellProcessor);
            }
            return cellProcessor;
        }

        @Override
        public CellProcessor buildInputCellProcessor(Class<Long> type, Annotation[] annos, CellProcessor processor) {
            CsvNumberConverter converterAnno = this.getAnnotation(annos);
            String pattern = this.getPattern(converterAnno);
            boolean lenient = this.getLenient(converterAnno);
            Locale locale = this.getLocale(converterAnno);
            Currency currency = this.getCurrency(converterAnno);
            DecimalFormatSymbols symbols = DecimalFormatSymbols.getInstance(locale);
            NumberFormat formatter = this.createNumberFormat(pattern, lenient, currency, symbols);
            Long min = this.parseNumber(this.getMin(converterAnno), formatter);
            Long max = this.parseNumber(this.getMax(converterAnno), formatter);
            Object cellProcessor = processor;
            cellProcessor = this.prependRangeProcessor(min, max, (CellProcessor)cellProcessor);
            cellProcessor = formatter != null ? (cellProcessor == null ? new ParseLocaleNumber<Long>(type, pattern, lenient, currency, symbols) : new ParseLocaleNumber<Long>(type, pattern, lenient, currency, symbols, (CellProcessor)cellProcessor)) : (cellProcessor == null ? new ParseLong() : new ParseLong((LongCellProcessor)cellProcessor));
            return cellProcessor;
        }

        protected Long parseNumber(String value, NumberFormat formatter) {
            if (value.isEmpty()) {
                return null;
            }
            if (formatter != null) {
                try {
                    return formatter.parse(value).longValue();
                }
                catch (ParseException e) {
                    throw new SuperCsvInvalidAnnotationException(String.format(" value '%s' cannot parse to Long", value, formatter), e);
                }
            }
            return Long.valueOf(value);
        }

        @Override
        public Long getParseValue(Class<Long> type, Annotation[] annos, String defaultValue) {
            CsvNumberConverter converterAnno = this.getAnnotation(annos);
            String pattern = this.getPattern(converterAnno);
            boolean lenient = this.getLenient(converterAnno);
            Locale locale = this.getLocale(converterAnno);
            Currency currency = this.getCurrency(converterAnno);
            DecimalFormatSymbols symbols = DecimalFormatSymbols.getInstance(locale);
            NumberFormat formatter = this.createNumberFormat(pattern, lenient, currency, symbols);
            return this.parseNumber(defaultValue, formatter);
        }
    }

    public static class ShortCellProcessorBuilder
    extends NumberCellProcessorBuilder<Short> {
        @Override
        public CellProcessor buildOutputCellProcessor(Class<Short> type, Annotation[] annos, CellProcessor processor, boolean ignoreValidationProcessor) {
            CsvNumberConverter converterAnno = this.getAnnotation(annos);
            String pattern = this.getPattern(converterAnno);
            boolean lenient = this.getLenient(converterAnno);
            Locale locale = this.getLocale(converterAnno);
            Currency currency = this.getCurrency(converterAnno);
            DecimalFormatSymbols symbols = DecimalFormatSymbols.getInstance(locale);
            NumberFormat formatter = this.createNumberFormat(pattern, lenient, currency, symbols);
            Short min = this.parseNumber(this.getMin(converterAnno), formatter);
            Short max = this.parseNumber(this.getMax(converterAnno), formatter);
            Object cellProcessor = processor;
            if (formatter != null) {
                FormatLocaleNumber formatLocaleNumber = cellProcessor = cellProcessor == null ? new FormatLocaleNumber(formatter) : new FormatLocaleNumber(formatter, (StringCellProcessor)cellProcessor);
            }
            if (!ignoreValidationProcessor) {
                cellProcessor = this.prependRangeProcessor(min, max, (CellProcessor)cellProcessor);
            }
            return cellProcessor;
        }

        @Override
        public CellProcessor buildInputCellProcessor(Class<Short> type, Annotation[] annos, CellProcessor processor) {
            CsvNumberConverter converterAnno = this.getAnnotation(annos);
            String pattern = this.getPattern(converterAnno);
            boolean lenient = this.getLenient(converterAnno);
            Locale locale = this.getLocale(converterAnno);
            Currency currency = this.getCurrency(converterAnno);
            DecimalFormatSymbols symbols = DecimalFormatSymbols.getInstance(locale);
            NumberFormat formatter = this.createNumberFormat(pattern, lenient, currency, symbols);
            Short min = this.parseNumber(this.getMin(converterAnno), formatter);
            Short max = this.parseNumber(this.getMax(converterAnno), formatter);
            Object cellProcessor = processor;
            cellProcessor = this.prependRangeProcessor(min, max, (CellProcessor)cellProcessor);
            cellProcessor = formatter != null ? (cellProcessor == null ? new ParseLocaleNumber<Short>(type, pattern, lenient, currency, symbols) : new ParseLocaleNumber<Short>(type, pattern, lenient, currency, symbols, (CellProcessor)cellProcessor)) : (cellProcessor == null ? new ParseShort() : new ParseShort((LongCellProcessor)cellProcessor));
            return cellProcessor;
        }

        protected Short parseNumber(String value, NumberFormat formatter) {
            if (value.isEmpty()) {
                return null;
            }
            if (formatter != null) {
                try {
                    return formatter.parse(value).shortValue();
                }
                catch (ParseException e) {
                    throw new SuperCsvInvalidAnnotationException(String.format(" value '%s' cannot parse to Short", value, formatter), e);
                }
            }
            return Short.valueOf(value);
        }

        @Override
        public Short getParseValue(Class<Short> type, Annotation[] annos, String defaultValue) {
            CsvNumberConverter converterAnno = this.getAnnotation(annos);
            String pattern = this.getPattern(converterAnno);
            boolean lenient = this.getLenient(converterAnno);
            Locale locale = this.getLocale(converterAnno);
            Currency currency = this.getCurrency(converterAnno);
            DecimalFormatSymbols symbols = DecimalFormatSymbols.getInstance(locale);
            NumberFormat formatter = this.createNumberFormat(pattern, lenient, currency, symbols);
            return this.parseNumber(defaultValue, formatter);
        }
    }
}

