/*
 * Decompiled with CFR 0.152.
 */
package org.supercsv.ext.builder;

import java.lang.annotation.Annotation;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Locale;
import java.util.TimeZone;
import org.supercsv.cellprocessor.ift.CellProcessor;
import org.supercsv.cellprocessor.ift.DateCellProcessor;
import org.supercsv.ext.Utils;
import org.supercsv.ext.annotation.CsvDateConverter;
import org.supercsv.ext.builder.AbstractCellProcessorBuilder;
import org.supercsv.ext.cellprocessor.FormatLocaleDate;
import org.supercsv.ext.cellprocessor.ParseLocaleDate;
import org.supercsv.ext.cellprocessor.ParseLocaleSqlDate;
import org.supercsv.ext.cellprocessor.ParseLocaleTime;
import org.supercsv.ext.cellprocessor.ParseLocaleTimestamp;
import org.supercsv.ext.cellprocessor.constraint.DateRange;
import org.supercsv.ext.cellprocessor.constraint.FutureDate;
import org.supercsv.ext.cellprocessor.constraint.PastDate;
import org.supercsv.ext.exception.SuperCsvInvalidAnnotationException;

public class DateCellProcessorBuilder
extends AbstractCellProcessorBuilder<java.util.Date> {
    protected DateFormat createDateFormat(String pattern, boolean lenient, Locale locale, TimeZone timeZone) {
        SimpleDateFormat value = new SimpleDateFormat(pattern, locale);
        value.setLenient(lenient);
        if (timeZone != null) {
            value.setTimeZone(timeZone);
        }
        return value;
    }

    protected CsvDateConverter getAnnotation(Annotation[] annos) {
        if (annos == null || annos.length == 0) {
            return null;
        }
        Annotation[] annotationArray = annos;
        int n = annos.length;
        int n2 = 0;
        while (n2 < n) {
            Annotation anno = annotationArray[n2];
            if (anno instanceof CsvDateConverter) {
                return (CsvDateConverter)anno;
            }
            ++n2;
        }
        return null;
    }

    protected String getPattern(CsvDateConverter converterAnno) {
        if (converterAnno == null) {
            return "yyyy-MM-dd";
        }
        return converterAnno.pattern();
    }

    protected boolean getLenient(CsvDateConverter converterAnno) {
        if (converterAnno == null) {
            return true;
        }
        return converterAnno.lenient();
    }

    protected Locale getLocale(CsvDateConverter converterAnno) {
        if (converterAnno == null) {
            return Locale.getDefault();
        }
        return Utils.getLocale(converterAnno.locale());
    }

    protected TimeZone getTimeZone(CsvDateConverter converterAnno) {
        if (converterAnno == null) {
            return null;
        }
        if (converterAnno.timezone().isEmpty()) {
            return TimeZone.getDefault();
        }
        return TimeZone.getTimeZone(converterAnno.timezone());
    }

    protected String getMin(CsvDateConverter converterAnno) {
        if (converterAnno == null) {
            return "";
        }
        return converterAnno.min();
    }

    protected String getMax(CsvDateConverter converterAnno) {
        if (converterAnno == null) {
            return "";
        }
        return converterAnno.max();
    }

    protected CellProcessor prependRangeProcessor(java.util.Date min, java.util.Date max, CellProcessor processor) {
        Object cellProcessor = processor;
        if (min != null && max != null) {
            cellProcessor = cellProcessor == null ? new DateRange<java.util.Date>(min, max) : new DateRange<java.util.Date>(min, max, (CellProcessor)cellProcessor);
        } else if (min != null) {
            cellProcessor = cellProcessor == null ? new FutureDate<java.util.Date>(min) : new FutureDate<java.util.Date>(min, (CellProcessor)cellProcessor);
        } else if (max != null) {
            cellProcessor = cellProcessor == null ? new PastDate<java.util.Date>(max) : new PastDate<java.util.Date>(max, (CellProcessor)cellProcessor);
        }
        return cellProcessor;
    }

    protected java.util.Date parseDate(String value, DateFormat formatter) {
        if (value.isEmpty()) {
            return null;
        }
        if (formatter == null) {
            return null;
        }
        try {
            return formatter.parse(value);
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public CellProcessor buildOutputCellProcessor(Class<java.util.Date> type, Annotation[] annos, CellProcessor processor, boolean ignoreValidationProcessor) {
        CsvDateConverter converterAnno = this.getAnnotation(annos);
        String pattern = this.getPattern(converterAnno);
        boolean lenient = this.getLenient(converterAnno);
        Locale locale = this.getLocale(converterAnno);
        TimeZone timeZone = this.getTimeZone(converterAnno);
        DateFormat formatter = this.createDateFormat(pattern, lenient, locale, timeZone);
        java.util.Date min = this.parseDate(this.getMin(converterAnno), formatter);
        java.util.Date max = this.parseDate(this.getMax(converterAnno), formatter);
        Object cellProcessor = processor;
        FormatLocaleDate formatLocaleDate = cellProcessor = cellProcessor == null ? new FormatLocaleDate(pattern, locale, timeZone) : new FormatLocaleDate(pattern, locale, timeZone, (DateCellProcessor)cellProcessor);
        if (!ignoreValidationProcessor) {
            cellProcessor = this.prependRangeProcessor(min, max, (CellProcessor)cellProcessor);
        }
        return cellProcessor;
    }

    @Override
    public CellProcessor buildInputCellProcessor(Class<java.util.Date> type, Annotation[] annos, CellProcessor processor) {
        CsvDateConverter converterAnno = this.getAnnotation(annos);
        String pattern = this.getPattern(converterAnno);
        boolean lenient = this.getLenient(converterAnno);
        Locale locale = this.getLocale(converterAnno);
        TimeZone timeZone = this.getTimeZone(converterAnno);
        DateFormat formatter = this.createDateFormat(pattern, lenient, locale, timeZone);
        java.util.Date min = this.parseDate(this.getMin(converterAnno), formatter);
        java.util.Date max = this.parseDate(this.getMax(converterAnno), formatter);
        Object cellProcessor = processor;
        cellProcessor = (cellProcessor = this.prependRangeProcessor(min, max, (CellProcessor)cellProcessor)) == null ? new ParseLocaleDate(pattern, lenient, locale, timeZone) : new ParseLocaleDate(pattern, lenient, locale, timeZone, (DateCellProcessor)cellProcessor);
        return cellProcessor;
    }

    public static SqlDateCellProcessorBuilder newSqlDate() {
        return new SqlDateCellProcessorBuilder();
    }

    public static TimestampCellProcessorBuilder newTimestamp() {
        return new TimestampCellProcessorBuilder();
    }

    public static TimeCellProcessorBuilder newTime() {
        return new TimeCellProcessorBuilder();
    }

    @Override
    public java.util.Date getParseValue(Class<java.util.Date> type, Annotation[] annos, String defaultValue) {
        CsvDateConverter converterAnno = this.getAnnotation(annos);
        String pattern = this.getPattern(converterAnno);
        boolean lenient = this.getLenient(converterAnno);
        Locale locale = this.getLocale(converterAnno);
        TimeZone timeZone = this.getTimeZone(converterAnno);
        DateFormat formatter = this.createDateFormat(pattern, lenient, locale, timeZone);
        try {
            return formatter.parse(defaultValue);
        }
        catch (ParseException e) {
            throw new SuperCsvInvalidAnnotationException(String.format(" default '%s' value cannot parse to Date with pattern '%s'", defaultValue, pattern), e);
        }
    }

    public static class SqlDateCellProcessorBuilder
    extends DateCellProcessorBuilder {
        @Override
        protected String getPattern(CsvDateConverter converterAnno) {
            if (converterAnno == null) {
                return "yyyy-MM-dd";
            }
            return converterAnno.pattern();
        }

        @Override
        public CellProcessor buildInputCellProcessor(Class<java.util.Date> type, Annotation[] annos, CellProcessor processor) {
            CsvDateConverter converterAnno = this.getAnnotation(annos);
            String pattern = this.getPattern(converterAnno);
            boolean lenient = this.getLenient(converterAnno);
            Locale locale = this.getLocale(converterAnno);
            TimeZone timeZone = this.getTimeZone(converterAnno);
            DateFormat formatter = this.createDateFormat(pattern, lenient, locale, timeZone);
            Date min = this.parseDate(this.getMin(converterAnno), formatter);
            Date max = this.parseDate(this.getMax(converterAnno), formatter);
            Object cellProcessor = processor;
            cellProcessor = (cellProcessor = this.prependRangeProcessor(min, max, (CellProcessor)cellProcessor)) == null ? new ParseLocaleSqlDate(pattern, lenient, locale, timeZone) : new ParseLocaleSqlDate(pattern, lenient, locale, timeZone, (DateCellProcessor)cellProcessor);
            return cellProcessor;
        }

        @Override
        protected Date parseDate(String value, DateFormat formatter) {
            java.util.Date date = super.parseDate(value, formatter);
            return date == null ? null : new Date(date.getTime());
        }

        @Override
        public java.util.Date getParseValue(Class<java.util.Date> type, Annotation[] annos, String defaultValue) {
            return new Date(((java.util.Date)super.getParseValue((Class)type, annos, defaultValue)).getTime());
        }
    }

    public static class TimeCellProcessorBuilder
    extends DateCellProcessorBuilder {
        @Override
        protected String getPattern(CsvDateConverter converterAnno) {
            if (converterAnno == null) {
                return "HH:mm";
            }
            return converterAnno.pattern();
        }

        @Override
        public CellProcessor buildInputCellProcessor(Class<java.util.Date> type, Annotation[] annos, CellProcessor processor) {
            CsvDateConverter converterAnno = this.getAnnotation(annos);
            String pattern = this.getPattern(converterAnno);
            boolean lenient = this.getLenient(converterAnno);
            Locale locale = this.getLocale(converterAnno);
            TimeZone timeZone = this.getTimeZone(converterAnno);
            DateFormat formatter = this.createDateFormat(pattern, lenient, locale, timeZone);
            Time min = this.parseDate(this.getMin(converterAnno), formatter);
            Time max = this.parseDate(this.getMax(converterAnno), formatter);
            Object cellProcessor = processor;
            cellProcessor = (cellProcessor = this.prependRangeProcessor(min, max, (CellProcessor)cellProcessor)) == null ? new ParseLocaleTime(pattern, lenient, locale, timeZone) : new ParseLocaleTime(pattern, lenient, locale, timeZone, (DateCellProcessor)cellProcessor);
            return cellProcessor;
        }

        @Override
        protected Time parseDate(String value, DateFormat formatter) {
            java.util.Date date = super.parseDate(value, formatter);
            return date == null ? null : new Time(date.getTime());
        }

        @Override
        public java.util.Date getParseValue(Class<java.util.Date> type, Annotation[] annos, String defaultValue) {
            return new Time(((java.util.Date)super.getParseValue((Class)type, annos, defaultValue)).getTime());
        }
    }

    public static class TimestampCellProcessorBuilder
    extends DateCellProcessorBuilder {
        @Override
        protected String getPattern(CsvDateConverter converterAnno) {
            if (converterAnno == null) {
                return "yyyy-MM-dd HH:mm:ss.SSS";
            }
            return converterAnno.pattern();
        }

        @Override
        public CellProcessor buildInputCellProcessor(Class<java.util.Date> type, Annotation[] annos, CellProcessor processor) {
            CsvDateConverter converterAnno = this.getAnnotation(annos);
            String pattern = this.getPattern(converterAnno);
            boolean lenient = this.getLenient(converterAnno);
            Locale locale = this.getLocale(converterAnno);
            TimeZone timeZone = this.getTimeZone(converterAnno);
            DateFormat formatter = this.createDateFormat(pattern, lenient, locale, timeZone);
            Timestamp min = this.parseDate(this.getMin(converterAnno), formatter);
            Timestamp max = this.parseDate(this.getMax(converterAnno), formatter);
            Object cellProcessor = processor;
            cellProcessor = (cellProcessor = this.prependRangeProcessor(min, max, (CellProcessor)cellProcessor)) == null ? new ParseLocaleTimestamp(pattern, lenient, locale, timeZone) : new ParseLocaleTimestamp(pattern, lenient, locale, timeZone, (DateCellProcessor)cellProcessor);
            return cellProcessor;
        }

        @Override
        protected Timestamp parseDate(String value, DateFormat formatter) {
            java.util.Date date = super.parseDate(value, formatter);
            return date == null ? null : new Timestamp(date.getTime());
        }

        @Override
        public java.util.Date getParseValue(Class<java.util.Date> type, Annotation[] annos, String defaultValue) {
            return new Timestamp(((java.util.Date)super.getParseValue((Class)type, annos, defaultValue)).getTime());
        }
    }
}

