/*
 * Decompiled with CFR 0.152.
 */
package org.supercsv.ext.builder;

import java.lang.annotation.Annotation;
import org.supercsv.cellprocessor.FmtBool;
import org.supercsv.cellprocessor.ift.BoolCellProcessor;
import org.supercsv.cellprocessor.ift.CellProcessor;
import org.supercsv.cellprocessor.ift.StringCellProcessor;
import org.supercsv.ext.annotation.CsvBooleanConverter;
import org.supercsv.ext.builder.AbstractCellProcessorBuilder;
import org.supercsv.ext.cellprocessor.ParseBoolean;
import org.supercsv.ext.exception.SuperCsvInvalidAnnotationException;

public class BooleanCellProcessorBuilder
extends AbstractCellProcessorBuilder<Boolean> {
    protected CsvBooleanConverter getAnnotation(Annotation[] annos) {
        if (annos == null || annos.length == 0) {
            return null;
        }
        Annotation[] annotationArray = annos;
        int n = annos.length;
        int n2 = 0;
        while (n2 < n) {
            Annotation anno = annotationArray[n2];
            if (anno instanceof CsvBooleanConverter) {
                return (CsvBooleanConverter)anno;
            }
            ++n2;
        }
        return null;
    }

    protected String getOutputTrueValue(CsvBooleanConverter converterAnno) {
        if (converterAnno == null) {
            return "true";
        }
        return converterAnno.outputTrueValue();
    }

    protected String getOutputFalseValue(CsvBooleanConverter converterAnno) {
        if (converterAnno == null) {
            return "false";
        }
        return converterAnno.outputFalseValue();
    }

    protected String[] getInputTrueValue(CsvBooleanConverter converterAnno) {
        if (converterAnno == null) {
            return new String[]{"true", "1", "yes", "on", "y", "t"};
        }
        return converterAnno.inputTrueValue();
    }

    protected String[] getInputFalseValue(CsvBooleanConverter converterAnno) {
        if (converterAnno == null) {
            return new String[]{"false", "0", "no", "off", "f", "n"};
        }
        return converterAnno.inputFalseValue();
    }

    protected boolean getLenient(CsvBooleanConverter converterAnno) {
        if (converterAnno == null) {
            return false;
        }
        return converterAnno.lenient();
    }

    protected boolean getFailToFalse(CsvBooleanConverter converterAnno) {
        if (converterAnno == null) {
            return false;
        }
        return converterAnno.failToFalse();
    }

    @Override
    public CellProcessor buildOutputCellProcessor(Class<Boolean> type, Annotation[] annos, CellProcessor processor, boolean ignoreValidationProcessor) {
        CsvBooleanConverter converterAnno = this.getAnnotation(annos);
        String trueValue = this.getOutputTrueValue(converterAnno);
        String falseValue = this.getOutputFalseValue(converterAnno);
        CellProcessor cellProcessor = processor;
        cellProcessor = cellProcessor == null ? new FmtBool(trueValue, falseValue) : new FmtBool(trueValue, falseValue, (StringCellProcessor)cellProcessor);
        return cellProcessor;
    }

    @Override
    public CellProcessor buildInputCellProcessor(Class<Boolean> type, Annotation[] annos, CellProcessor processor) {
        CsvBooleanConverter converterAnno = this.getAnnotation(annos);
        String[] trueValue = this.getInputTrueValue(converterAnno);
        String[] falseValue = this.getInputFalseValue(converterAnno);
        boolean lenient = this.getLenient(converterAnno);
        boolean failToFalse = this.getFailToFalse(converterAnno);
        Object cellProcessor = processor;
        cellProcessor = cellProcessor == null ? new ParseBoolean(trueValue, falseValue, lenient).setFailToFalse(failToFalse) : new ParseBoolean(trueValue, falseValue, lenient, (BoolCellProcessor)cellProcessor).setFailToFalse(failToFalse);
        return cellProcessor;
    }

    @Override
    public Boolean getParseValue(Class<Boolean> type, Annotation[] annos, String defaultValue) {
        CsvBooleanConverter converterAnno = this.getAnnotation(annos);
        String[] trueValue = this.getInputTrueValue(converterAnno);
        String[] falseValue = this.getInputFalseValue(converterAnno);
        boolean lenient = this.getLenient(converterAnno);
        boolean failToFalse = this.getFailToFalse(converterAnno);
        String[] stringArray = trueValue;
        int n = trueValue.length;
        int n2 = 0;
        while (n2 < n) {
            String trueStr = stringArray[n2];
            if (lenient && trueStr.equalsIgnoreCase(defaultValue)) {
                return Boolean.TRUE;
            }
            if (!lenient && trueStr.equals(defaultValue)) {
                return Boolean.TRUE;
            }
            ++n2;
        }
        stringArray = falseValue;
        n = falseValue.length;
        n2 = 0;
        while (n2 < n) {
            String falseStr = stringArray[n2];
            if (lenient && falseStr.equalsIgnoreCase(defaultValue)) {
                return Boolean.FALSE;
            }
            if (!lenient && falseStr.equals(defaultValue)) {
                return Boolean.FALSE;
            }
            ++n2;
        }
        if (failToFalse) {
            return Boolean.TRUE;
        }
        throw new SuperCsvInvalidAnnotationException(String.format("defaultValue'%s' cannot parse.", defaultValue));
    }
}

