/*
 * Decompiled with CFR 0.152.
 */
package org.supercsv.ext.builder;

import java.lang.annotation.Annotation;
import org.supercsv.cellprocessor.ConvertNullTo;
import org.supercsv.cellprocessor.Optional;
import org.supercsv.cellprocessor.constraint.Equals;
import org.supercsv.cellprocessor.constraint.NotNull;
import org.supercsv.cellprocessor.constraint.Unique;
import org.supercsv.cellprocessor.ift.CellProcessor;
import org.supercsv.ext.annotation.CsvColumn;
import org.supercsv.ext.builder.CellProcessorBuilder;
import org.supercsv.ext.cellprocessor.Trim;

public abstract class AbstractCellProcessorBuilder<T>
implements CellProcessorBuilder<T> {
    protected CsvColumn getCsvColumnAnnotation(Annotation[] annos) {
        Annotation[] annotationArray = annos;
        int n = annos.length;
        int n2 = 0;
        while (n2 < n) {
            Annotation anno = annotationArray[n2];
            if (anno instanceof CsvColumn) {
                return (CsvColumn)anno;
            }
            ++n2;
        }
        return null;
    }

    @Override
    public CellProcessor buildOutputCellProcessor(Class<T> type, Annotation[] annos, boolean ignoreValidationProcessor) {
        CsvColumn csvColumnAnno = this.getCsvColumnAnnotation(annos);
        CellProcessor cellProcessor = null;
        if (csvColumnAnno.trim()) {
            cellProcessor = this.prependTrimProcessor(cellProcessor);
        }
        cellProcessor = this.buildOutputCellProcessor(type, annos, cellProcessor, ignoreValidationProcessor);
        if (csvColumnAnno.unique() && !ignoreValidationProcessor) {
            cellProcessor = this.prependUniqueProcessor(cellProcessor);
        }
        if (!csvColumnAnno.equalsValue().isEmpty() && !ignoreValidationProcessor) {
            cellProcessor = this.prependEqualsProcessor(type, cellProcessor, this.getParseValue(type, annos, csvColumnAnno.equalsValue()));
        }
        cellProcessor = csvColumnAnno.optional() && !type.isPrimitive() ? this.prependOptionalProcessor(cellProcessor) : this.prependNotNullProcessor(cellProcessor);
        if (!csvColumnAnno.outputDefaultValue().isEmpty()) {
            cellProcessor = this.prependConvertNullToProcessor(type, cellProcessor, csvColumnAnno.outputDefaultValue());
        }
        return cellProcessor;
    }

    @Override
    public CellProcessor buildInputCellProcessor(Class<T> type, Annotation[] annos) {
        CsvColumn csvColumnAnno = this.getCsvColumnAnnotation(annos);
        CellProcessor cellProcessor = null;
        cellProcessor = this.buildInputCellProcessor(type, annos, cellProcessor);
        if (csvColumnAnno.unique()) {
            cellProcessor = this.prependUniqueProcessor(cellProcessor);
        }
        if (!csvColumnAnno.equalsValue().isEmpty()) {
            cellProcessor = this.prependEqualsProcessor(type, cellProcessor, this.getParseValue(type, annos, csvColumnAnno.equalsValue()));
        }
        if (csvColumnAnno.trim()) {
            cellProcessor = this.prependTrimProcessor(cellProcessor);
        }
        cellProcessor = csvColumnAnno.optional() && !type.isPrimitive() ? this.prependOptionalProcessor(cellProcessor) : this.prependNotNullProcessor(cellProcessor);
        if (!csvColumnAnno.inputDefaultValue().isEmpty()) {
            cellProcessor = this.prependConvertNullToProcessor(type, cellProcessor, this.getParseValue(type, annos, csvColumnAnno.inputDefaultValue()));
        }
        return cellProcessor;
    }

    protected CellProcessor prependConvertNullToProcessor(Class<T> type, CellProcessor processor, Object value) {
        return processor == null ? new ConvertNullTo(value) : new ConvertNullTo(value, processor);
    }

    protected CellProcessor prependEqualsProcessor(Class<T> type, CellProcessor processor, Object value) {
        return processor == null ? new Equals(value) : new Equals(value, processor);
    }

    protected CellProcessor prependUniqueProcessor(CellProcessor processor) {
        return processor == null ? new Unique() : new Unique(processor);
    }

    protected CellProcessor prependOptionalProcessor(CellProcessor processor) {
        return processor == null ? new Optional() : new Optional(processor);
    }

    protected CellProcessor prependNotNullProcessor(CellProcessor processor) {
        return processor == null ? new NotNull() : new NotNull(processor);
    }

    protected CellProcessor prependTrimProcessor(CellProcessor processor) {
        return processor == null ? new Trim() : new Trim(processor);
    }

    public abstract CellProcessor buildOutputCellProcessor(Class<T> var1, Annotation[] var2, CellProcessor var3, boolean var4);

    public abstract CellProcessor buildInputCellProcessor(Class<T> var1, Annotation[] var2, CellProcessor var3);

    public abstract T getParseValue(Class<T> var1, Annotation[] var2, String var3);
}

