/*
 * Decompiled with CFR 0.152.
 */
package com.github.mygreen.cellformatter.number;

import com.github.mygreen.cellformatter.number.DecimalNumber;
import com.github.mygreen.cellformatter.number.ExponentNumber;
import com.github.mygreen.cellformatter.number.FormattedNumber;
import com.github.mygreen.cellformatter.number.FractionNumber;
import com.github.mygreen.cellformatter.number.NativeNumber;
import com.github.mygreen.cellformatter.number.PercentNumber;

public abstract class NumberFactory {
    public static NumberFactory nativeNumber() {
        return new NumberFactory(){

            @Override
            public FormattedNumber create(double value) {
                return new NativeNumber(value);
            }
        };
    }

    public static DecimalNumberFactory decimalNumber(int scale, boolean useSeparator, int permilles) {
        return new DecimalNumberFactory(scale, useSeparator, permilles);
    }

    public static PercentNumberFactory percentNumber(int scale, boolean useSeparator, int permilles) {
        return new PercentNumberFactory(scale, useSeparator, permilles);
    }

    public static ExponentNumberFactory exponentNumber(int scale, boolean useSeparator) {
        return new ExponentNumberFactory(scale, useSeparator);
    }

    public static FractionNumberFactory fractionNumber(int denominator, boolean exactDenom, boolean wholeType) {
        return new FractionNumberFactory(denominator, exactDenom, wholeType);
    }

    public abstract FormattedNumber create(double var1);

    public static class FractionNumberFactory
    extends NumberFactory {
        private int denominator;
        private boolean exactDenom;
        private boolean wholeType;

        public FractionNumberFactory(int denominator, boolean exactDenom, boolean wholeType) {
            this.denominator = denominator;
            this.exactDenom = exactDenom;
            this.wholeType = wholeType;
        }

        @Override
        public FormattedNumber create(double value) {
            FractionNumber number = this.exactDenom ? FractionNumber.createExactDenominator(value, this.denominator, this.wholeType) : FractionNumber.createMaxDenominator(value, this.denominator, this.wholeType);
            return number;
        }
    }

    public static class PercentNumberFactory
    extends NumberFactory {
        private int scale;
        private boolean useSeparator;
        private int permilles;

        public PercentNumberFactory(int scale, boolean useSeparator, int permilles) {
            this.scale = scale;
            this.useSeparator = useSeparator;
            this.permilles = permilles;
        }

        @Override
        public FormattedNumber create(double value) {
            PercentNumber number = new PercentNumber(value, this.scale, this.permilles);
            number.setUseSeparator(this.useSeparator);
            return number;
        }
    }

    public static class ExponentNumberFactory
    extends NumberFactory {
        private int scale;
        private boolean useSeparator;

        public ExponentNumberFactory(int scale, boolean useSeparator) {
            this.scale = scale;
            this.useSeparator = useSeparator;
        }

        @Override
        public FormattedNumber create(double value) {
            ExponentNumber number = new ExponentNumber(value, this.scale);
            number.setUseSeparator(this.useSeparator);
            return number;
        }
    }

    public static class DecimalNumberFactory
    extends NumberFactory {
        private int scale;
        private boolean useSeparator;
        private int permilles;

        public DecimalNumberFactory(int scale, boolean useSeparator, int permilles) {
            this.scale = scale;
            this.useSeparator = useSeparator;
            this.permilles = permilles;
        }

        @Override
        public FormattedNumber create(double value) {
            DecimalNumber number = new DecimalNumber(value, this.scale, this.permilles);
            number.setUseSeparator(this.useSeparator);
            return number;
        }
    }
}

