/*
 * Decompiled with CFR 0.152.
 */
package com.github.mygreen.cellformatter.lang;

import com.github.mygreen.cellformatter.lang.ArgUtils;
import com.github.mygreen.cellformatter.lang.ExcelDateUtils;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;

public class EraPeriod {
    public static final EraPeriod UNKNOWN_PERIOD = new EraPeriod(){

        @Override
        public boolean isUnknown() {
            return true;
        }
    };
    private String abbrevRomanName;
    private String abbrevName;
    private String name;
    private Date startDate;
    private Date endDate;

    public boolean contains(Date date) {
        ArgUtils.notNull(date, "date");
        if (this.startDate == null) {
            return this.endDate.compareTo(date) >= 0;
        }
        if (this.endDate == null) {
            return this.startDate.compareTo(date) <= 0;
        }
        return this.endDate.compareTo(date) >= 0 && this.startDate.compareTo(date) <= 0;
    }

    public int getEraYear(Calendar cal) {
        ArgUtils.notNull(cal, "cal");
        Calendar startCal = Calendar.getInstance(TimeZone.getTimeZone("GMT-00:00"));
        startCal.setTime(this.startDate);
        int diff = cal.get(1) - startCal.get(1) + 1;
        return diff;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(EraPeriod.class.getSimpleName()).append("[").append(this.getName()).append("]");
        if (this.startDate != null) {
            sb.append("[start=").append(ExcelDateUtils.formatDate(this.startDate)).append("]");
        }
        if (this.endDate != null) {
            sb.append("[end=").append(ExcelDateUtils.formatDate(this.endDate)).append("]");
        }
        return sb.toString();
    }

    public String getAbbrevRomanName() {
        return this.abbrevRomanName;
    }

    void setAbbrevRomanName(String abbrevRomanName) {
        this.abbrevRomanName = abbrevRomanName;
    }

    public String getAbbrevName() {
        return this.abbrevName;
    }

    void setAbbrevName(String abbrevName) {
        this.abbrevName = abbrevName;
    }

    public String getName() {
        return this.name;
    }

    void setName(String name) {
        this.name = name;
    }

    public Date getStartDate() {
        return this.startDate;
    }

    void setStartDate(Date startDate) {
        this.startDate = startDate;
    }

    void setEndDate(Date endDate) {
        this.endDate = endDate;
    }

    public Date getEndDate() {
        return this.endDate;
    }

    public boolean isUnknown() {
        return false;
    }
}

