/*
 * Decompiled with CFR 0.152.
 */
package com.github.mygreen.cellformatter.callback;

import com.github.mygreen.cellformatter.callback.Callback;
import com.github.mygreen.cellformatter.lang.ArgUtils;
import com.github.mygreen.cellformatter.term.DateTerm;
import com.github.mygreen.cellformatter.term.Term;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;

public abstract class DBNumBase
implements Callback<Object> {
    private Set<String> allowedLanguages = new HashSet<String>();

    protected DBNumBase(String ... allowedLanguages) {
        ArgUtils.notEmpty(allowedLanguages, "allowedLanguages");
        for (String lang : allowedLanguages) {
            this.allowedLanguages.add(lang.toLowerCase());
        }
    }

    @Override
    public boolean isApplicable(Locale locale) {
        if (locale == null) {
            return false;
        }
        String language = locale.getLanguage().toLowerCase();
        return this.allowedLanguages.contains(language);
    }

    protected boolean is4YearTerm(Term<?> term) {
        if (!(term instanceof DateTerm.YearTerm)) {
            return false;
        }
        DateTerm.YearTerm yearTerm = (DateTerm.YearTerm)term;
        return yearTerm.getFormat().length() == 4;
    }
}

