/*
 * Decompiled with CFR 0.152.
 */
package com.github.mygreen.cellformatter;

import com.github.mygreen.cellformatter.BooleanCell;
import com.github.mygreen.cellformatter.CellFormatResult;
import com.github.mygreen.cellformatter.CellFormatter;
import com.github.mygreen.cellformatter.DateCell;
import com.github.mygreen.cellformatter.FormatCellType;
import com.github.mygreen.cellformatter.FormatterResolver;
import com.github.mygreen.cellformatter.NumberCell;
import com.github.mygreen.cellformatter.ObjectCell;
import com.github.mygreen.cellformatter.TextCell;
import java.util.Date;
import java.util.Locale;

public class ObjectCellFormatter {
    private FormatterResolver formatterResolver = new FormatterResolver();
    private boolean cache = true;

    public String formatAsString(String formatPattern, String value) {
        return this.format(formatPattern, value).getText();
    }

    public CellFormatResult format(String formatPattern, String value) {
        return this.format(formatPattern, value, Locale.getDefault());
    }

    public String formatAsString(String formatPattern, String value, Locale locale) {
        return this.format(formatPattern, value, locale).getText();
    }

    public CellFormatResult format(String formatPattern, String value, Locale locale) {
        return this.format(new TextCell(value, formatPattern), locale);
    }

    public String formatAsString(String formatPattern, boolean value, Locale locale) {
        return this.format(formatPattern, value, locale).getText();
    }

    public CellFormatResult format(String formatPattern, boolean value, Locale locale) {
        return this.format(new BooleanCell((Boolean)value, formatPattern), locale);
    }

    public String formatAsString(String formatPattern, boolean value) {
        return this.format(formatPattern, value).getText();
    }

    public CellFormatResult format(String formatPattern, boolean value) {
        return this.format(formatPattern, value, Locale.getDefault());
    }

    public <N extends Number> String formatAsString(String formatPattern, N value, Locale locale) {
        return this.format(formatPattern, value, locale).getText();
    }

    public <N extends Number> CellFormatResult format(String formatPattern, N value, Locale locale) {
        return this.format(new NumberCell<N>(value, formatPattern), locale);
    }

    public <N extends Number> String formatAsString(String formatPattern, N value) {
        return this.format(formatPattern, value).getText();
    }

    public <N extends Number> CellFormatResult format(String formatPattern, N value) {
        return this.format(formatPattern, value, Locale.getDefault());
    }

    public String formatAsString(String formatPattern, Date value, Locale locale) {
        return this.format(formatPattern, value, locale).getText();
    }

    public CellFormatResult format(String formatPattern, Date value, Locale locale) {
        return this.format(new DateCell(value, formatPattern), locale);
    }

    public String formatAsString(String formatPattern, Date value) {
        return this.format(formatPattern, value).getText();
    }

    public CellFormatResult format(String formatPattern, Date value) {
        return this.format(formatPattern, value, Locale.getDefault());
    }

    public String formatAsString(ObjectCell<?> cell) {
        return this.formatAsString(cell, Locale.getDefault());
    }

    public String formatAsString(ObjectCell<?> cell, Locale locale) {
        return this.format(cell, locale).getText();
    }

    public CellFormatResult format(ObjectCell<?> cell) {
        return this.format(cell, Locale.getDefault());
    }

    public CellFormatResult format(ObjectCell<?> cell, Locale locale) {
        if (cell == null) {
            CellFormatResult result = new CellFormatResult();
            result.setCellType(FormatCellType.Blank);
            result.setText("");
            return result;
        }
        Locale runtimeLocale = locale != null ? locale : Locale.getDefault();
        short formatIndex = cell.getFormatIndex();
        String formatPattern = cell.getFormatPattern();
        if (this.formatterResolver.canResolve(formatIndex)) {
            CellFormatter cellFormatter = this.formatterResolver.getFormatter(formatIndex);
            return cellFormatter.format(cell, runtimeLocale);
        }
        if (this.formatterResolver.canResolve(formatPattern)) {
            CellFormatter cellFormatter = this.formatterResolver.getFormatter(formatPattern);
            return cellFormatter.format(cell, runtimeLocale);
        }
        CellFormatter cellFormatter = this.formatterResolver.createFormatter(formatPattern);
        if (this.isCache()) {
            this.formatterResolver.registerFormatter(formatPattern, cellFormatter);
        }
        return cellFormatter.format(cell, runtimeLocale);
    }

    public FormatterResolver getFormatterResolver() {
        return this.formatterResolver;
    }

    public void setFormatterResolver(FormatterResolver formatterResolver) {
        this.formatterResolver = formatterResolver;
    }

    public boolean isCache() {
        return this.cache;
    }

    public void setCache(boolean cache) {
        this.cache = cache;
    }
}

