/*
 * Decompiled with CFR 0.152.
 */
package com.jcraft.jsch;

import com.jcraft.jsch.ConfigRepository;
import com.jcraft.jsch.HostKeyRepository;
import com.jcraft.jsch.Identity;
import com.jcraft.jsch.IdentityFile;
import com.jcraft.jsch.IdentityRepository;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.JavaVersion;
import com.jcraft.jsch.KnownHosts;
import com.jcraft.jsch.LocalIdentityRepository;
import com.jcraft.jsch.Logger;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.Util;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class JSch {
    static Hashtable<String, String> config = new Hashtable();
    private Vector<Session> sessionPool = new Vector();
    private IdentityRepository defaultIdentityRepository;
    private IdentityRepository identityRepository = this.defaultIdentityRepository = new LocalIdentityRepository(this);
    private ConfigRepository configRepository = null;
    private HostKeyRepository known_hosts = null;
    private static final Logger DEVNULL;
    static Logger logger;

    public synchronized void setIdentityRepository(IdentityRepository identityRepository) {
        this.identityRepository = identityRepository == null ? this.defaultIdentityRepository : identityRepository;
    }

    public synchronized IdentityRepository getIdentityRepository() {
        return this.identityRepository;
    }

    public ConfigRepository getConfigRepository() {
        return this.configRepository;
    }

    public void setConfigRepository(ConfigRepository configRepository) {
        this.configRepository = configRepository;
    }

    public Session getSession(String host) throws JSchException {
        return this.getSession(null, host, 22);
    }

    public Session getSession(String username, String host) throws JSchException {
        return this.getSession(username, host, 22);
    }

    public Session getSession(String username, String host, int port) throws JSchException {
        if (host == null) {
            throw new JSchException("host must not be null.");
        }
        Session s = new Session(this, username, host, port);
        return s;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addSession(Session session) {
        Vector<Session> vector = this.sessionPool;
        synchronized (vector) {
            this.sessionPool.addElement(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean removeSession(Session session) {
        Vector<Session> vector = this.sessionPool;
        synchronized (vector) {
            return this.sessionPool.remove(session);
        }
    }

    public void setHostKeyRepository(HostKeyRepository hkrepo) {
        this.known_hosts = hkrepo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setKnownHosts(String filename) throws JSchException {
        if (this.known_hosts == null) {
            this.known_hosts = new KnownHosts(this);
        }
        if (this.known_hosts instanceof KnownHosts) {
            HostKeyRepository hostKeyRepository = this.known_hosts;
            synchronized (hostKeyRepository) {
                ((KnownHosts)this.known_hosts).setKnownHosts(filename);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setKnownHosts(InputStream stream) throws JSchException {
        if (this.known_hosts == null) {
            this.known_hosts = new KnownHosts(this);
        }
        if (this.known_hosts instanceof KnownHosts) {
            HostKeyRepository hostKeyRepository = this.known_hosts;
            synchronized (hostKeyRepository) {
                ((KnownHosts)this.known_hosts).setKnownHosts(stream);
            }
        }
    }

    public HostKeyRepository getHostKeyRepository() {
        if (this.known_hosts == null) {
            this.known_hosts = new KnownHosts(this);
        }
        return this.known_hosts;
    }

    public void addIdentity(String prvkey) throws JSchException {
        this.addIdentity(prvkey, (byte[])null);
    }

    public void addIdentity(String prvkey, String passphrase) throws JSchException {
        byte[] _passphrase = null;
        if (passphrase != null) {
            _passphrase = Util.str2byte(passphrase);
        }
        this.addIdentity(prvkey, _passphrase);
        if (_passphrase != null) {
            Util.bzero(_passphrase);
        }
    }

    public void addIdentity(String prvkey, byte[] passphrase) throws JSchException {
        IdentityFile identity = IdentityFile.newInstance(prvkey, null, this);
        this.addIdentity(identity, passphrase);
    }

    public void addIdentity(String prvkey, String pubkey, byte[] passphrase) throws JSchException {
        IdentityFile identity = IdentityFile.newInstance(prvkey, pubkey, this);
        this.addIdentity(identity, passphrase);
    }

    public void addIdentity(String name, byte[] prvkey, byte[] pubkey, byte[] passphrase) throws JSchException {
        IdentityFile identity = IdentityFile.newInstance(name, prvkey, pubkey, this);
        this.addIdentity(identity, passphrase);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addIdentity(Identity identity, byte[] passphrase) throws JSchException {
        if (passphrase != null) {
            try {
                byte[] goo = new byte[passphrase.length];
                System.arraycopy(passphrase, 0, goo, 0, passphrase.length);
                passphrase = goo;
                identity.setPassphrase(passphrase);
            }
            finally {
                Util.bzero(passphrase);
            }
        }
        if (this.identityRepository instanceof LocalIdentityRepository) {
            ((LocalIdentityRepository)this.identityRepository).add(identity);
        } else if (identity instanceof IdentityFile && !identity.isEncrypted()) {
            this.identityRepository.add(((IdentityFile)identity).getKeyPair().forSSHAgent());
        } else {
            JSch jSch = this;
            synchronized (jSch) {
                if (!(this.identityRepository instanceof IdentityRepository.Wrapper)) {
                    this.setIdentityRepository(new IdentityRepository.Wrapper(this.identityRepository));
                }
            }
            ((IdentityRepository.Wrapper)this.identityRepository).add(identity);
        }
    }

    @Deprecated
    public void removeIdentity(String name) throws JSchException {
        Vector<Identity> identities = this.identityRepository.getIdentities();
        for (int i = 0; i < identities.size(); ++i) {
            Identity identity = identities.elementAt(i);
            if (!identity.getName().equals(name)) continue;
            if (this.identityRepository instanceof LocalIdentityRepository) {
                ((LocalIdentityRepository)this.identityRepository).remove(identity);
                continue;
            }
            this.identityRepository.remove(identity.getPublicKeyBlob());
        }
    }

    public void removeIdentity(Identity identity) throws JSchException {
        this.identityRepository.remove(identity.getPublicKeyBlob());
    }

    public Vector<String> getIdentityNames() throws JSchException {
        Vector<String> foo = new Vector<String>();
        Vector<Identity> identities = this.identityRepository.getIdentities();
        for (int i = 0; i < identities.size(); ++i) {
            Identity identity = identities.elementAt(i);
            foo.addElement(identity.getName());
        }
        return foo;
    }

    public void removeAllIdentity() throws JSchException {
        this.identityRepository.removeAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getConfig(String key) {
        Hashtable<String, String> hashtable = config;
        synchronized (hashtable) {
            if (key.equals("PubkeyAcceptedKeyTypes")) {
                key = "PubkeyAcceptedAlgorithms";
            }
            return config.get(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setConfig(Hashtable<String, String> newconf) {
        Hashtable<String, String> hashtable = config;
        synchronized (hashtable) {
            Enumeration<String> e = newconf.keys();
            while (e.hasMoreElements()) {
                String newkey = e.nextElement();
                String key = newkey.equals("PubkeyAcceptedKeyTypes") ? "PubkeyAcceptedAlgorithms" : newkey;
                config.put(key, newconf.get(newkey));
            }
        }
    }

    public static void setConfig(String key, String value) {
        if (key.equals("PubkeyAcceptedKeyTypes")) {
            config.put("PubkeyAcceptedAlgorithms", value);
        } else {
            config.put(key, value);
        }
    }

    public static void setLogger(Logger logger) {
        if (logger == null) {
            logger = DEVNULL;
        }
        JSch.logger = logger;
    }

    static Logger getLogger() {
        return logger;
    }

    static {
        config.put("kex", Util.getSystemProperty("jsch.kex", "curve25519-sha256,curve25519-sha256@libssh.org,ecdh-sha2-nistp256,ecdh-sha2-nistp384,ecdh-sha2-nistp521,diffie-hellman-group-exchange-sha256,diffie-hellman-group16-sha512,diffie-hellman-group18-sha512,diffie-hellman-group14-sha256"));
        config.put("server_host_key", Util.getSystemProperty("jsch.server_host_key", "ssh-ed25519,ecdsa-sha2-nistp256,ecdsa-sha2-nistp384,ecdsa-sha2-nistp521,rsa-sha2-512,rsa-sha2-256,ssh-rsa"));
        config.put("prefer_known_host_key_types", Util.getSystemProperty("jsch.prefer_known_host_key_types", "yes"));
        config.put("enable_server_sig_algs", Util.getSystemProperty("jsch.enable_server_sig_algs", "yes"));
        config.put("cipher.s2c", Util.getSystemProperty("jsch.cipher", "aes128-ctr,aes192-ctr,aes256-ctr,aes128-gcm@openssh.com,aes256-gcm@openssh.com,chacha20-poly1305@openssh.com"));
        config.put("cipher.c2s", Util.getSystemProperty("jsch.cipher", "aes128-ctr,aes192-ctr,aes256-ctr,aes128-gcm@openssh.com,aes256-gcm@openssh.com,chacha20-poly1305@openssh.com"));
        config.put("mac.s2c", Util.getSystemProperty("jsch.mac", "hmac-sha2-256-etm@openssh.com,hmac-sha2-512-etm@openssh.com,hmac-sha1-etm@openssh.com,hmac-sha2-256,hmac-sha2-512,hmac-sha1"));
        config.put("mac.c2s", Util.getSystemProperty("jsch.mac", "hmac-sha2-256-etm@openssh.com,hmac-sha2-512-etm@openssh.com,hmac-sha1-etm@openssh.com,hmac-sha2-256,hmac-sha2-512,hmac-sha1"));
        config.put("compression.s2c", Util.getSystemProperty("jsch.compression", "none"));
        config.put("compression.c2s", Util.getSystemProperty("jsch.compression", "none"));
        config.put("lang.s2c", Util.getSystemProperty("jsch.lang", ""));
        config.put("lang.c2s", Util.getSystemProperty("jsch.lang", ""));
        config.put("dhgex_min", Util.getSystemProperty("jsch.dhgex_min", "2048"));
        config.put("dhgex_max", Util.getSystemProperty("jsch.dhgex_max", "8192"));
        config.put("dhgex_preferred", Util.getSystemProperty("jsch.dhgex_preferred", "3072"));
        config.put("compression_level", Util.getSystemProperty("jsch.compression_level", "6"));
        config.put("diffie-hellman-group-exchange-sha1", "com.jcraft.jsch.DHGEX");
        config.put("diffie-hellman-group1-sha1", "com.jcraft.jsch.DHG1");
        config.put("diffie-hellman-group14-sha1", "com.jcraft.jsch.DHG14");
        config.put("diffie-hellman-group-exchange-sha256", "com.jcraft.jsch.DHGEX256");
        config.put("diffie-hellman-group-exchange-sha224@ssh.com", "com.jcraft.jsch.DHGEX224");
        config.put("diffie-hellman-group-exchange-sha384@ssh.com", "com.jcraft.jsch.DHGEX384");
        config.put("diffie-hellman-group-exchange-sha512@ssh.com", "com.jcraft.jsch.DHGEX512");
        config.put("diffie-hellman-group14-sha256", "com.jcraft.jsch.DHG14256");
        config.put("diffie-hellman-group15-sha512", "com.jcraft.jsch.DHG15");
        config.put("diffie-hellman-group16-sha512", "com.jcraft.jsch.DHG16");
        config.put("diffie-hellman-group17-sha512", "com.jcraft.jsch.DHG17");
        config.put("diffie-hellman-group18-sha512", "com.jcraft.jsch.DHG18");
        config.put("diffie-hellman-group14-sha256@ssh.com", "com.jcraft.jsch.DHG14256");
        config.put("diffie-hellman-group14-sha224@ssh.com", "com.jcraft.jsch.DHG14224");
        config.put("diffie-hellman-group15-sha256@ssh.com", "com.jcraft.jsch.DHG15256");
        config.put("diffie-hellman-group15-sha384@ssh.com", "com.jcraft.jsch.DHG15384");
        config.put("diffie-hellman-group16-sha512@ssh.com", "com.jcraft.jsch.DHG16");
        config.put("diffie-hellman-group16-sha384@ssh.com", "com.jcraft.jsch.DHG16384");
        config.put("diffie-hellman-group18-sha512@ssh.com", "com.jcraft.jsch.DHG18");
        config.put("ecdsa-sha2-nistp256", "com.jcraft.jsch.jce.SignatureECDSA256");
        config.put("ecdsa-sha2-nistp384", "com.jcraft.jsch.jce.SignatureECDSA384");
        config.put("ecdsa-sha2-nistp521", "com.jcraft.jsch.jce.SignatureECDSA521");
        config.put("ecdh-sha2-nistp256", "com.jcraft.jsch.DHEC256");
        config.put("ecdh-sha2-nistp384", "com.jcraft.jsch.DHEC384");
        config.put("ecdh-sha2-nistp521", "com.jcraft.jsch.DHEC521");
        config.put("ecdh-sha2-nistp", "com.jcraft.jsch.jce.ECDHN");
        config.put("curve25519-sha256", "com.jcraft.jsch.DH25519");
        config.put("curve25519-sha256@libssh.org", "com.jcraft.jsch.DH25519");
        config.put("curve448-sha512", "com.jcraft.jsch.DH448");
        config.put("dh", "com.jcraft.jsch.jce.DH");
        config.put("3des-cbc", "com.jcraft.jsch.jce.TripleDESCBC");
        config.put("blowfish-cbc", "com.jcraft.jsch.jce.BlowfishCBC");
        config.put("hmac-sha1", "com.jcraft.jsch.jce.HMACSHA1");
        config.put("hmac-sha1-96", "com.jcraft.jsch.jce.HMACSHA196");
        config.put("hmac-sha2-256", "com.jcraft.jsch.jce.HMACSHA256");
        config.put("hmac-sha2-512", "com.jcraft.jsch.jce.HMACSHA512");
        config.put("hmac-md5", "com.jcraft.jsch.jce.HMACMD5");
        config.put("hmac-md5-96", "com.jcraft.jsch.jce.HMACMD596");
        config.put("hmac-sha1-etm@openssh.com", "com.jcraft.jsch.jce.HMACSHA1ETM");
        config.put("hmac-sha1-96-etm@openssh.com", "com.jcraft.jsch.jce.HMACSHA196ETM");
        config.put("hmac-sha2-256-etm@openssh.com", "com.jcraft.jsch.jce.HMACSHA256ETM");
        config.put("hmac-sha2-512-etm@openssh.com", "com.jcraft.jsch.jce.HMACSHA512ETM");
        config.put("hmac-md5-etm@openssh.com", "com.jcraft.jsch.jce.HMACMD5ETM");
        config.put("hmac-md5-96-etm@openssh.com", "com.jcraft.jsch.jce.HMACMD596ETM");
        config.put("hmac-sha256-2@ssh.com", "com.jcraft.jsch.jce.HMACSHA2562SSHCOM");
        config.put("hmac-sha224@ssh.com", "com.jcraft.jsch.jce.HMACSHA224SSHCOM");
        config.put("hmac-sha256@ssh.com", "com.jcraft.jsch.jce.HMACSHA256SSHCOM");
        config.put("hmac-sha384@ssh.com", "com.jcraft.jsch.jce.HMACSHA384SSHCOM");
        config.put("hmac-sha512@ssh.com", "com.jcraft.jsch.jce.HMACSHA512SSHCOM");
        config.put("sha-1", "com.jcraft.jsch.jce.SHA1");
        config.put("sha-224", "com.jcraft.jsch.jce.SHA224");
        config.put("sha-256", "com.jcraft.jsch.jce.SHA256");
        config.put("sha-384", "com.jcraft.jsch.jce.SHA384");
        config.put("sha-512", "com.jcraft.jsch.jce.SHA512");
        config.put("md5", "com.jcraft.jsch.jce.MD5");
        config.put("sha1", "com.jcraft.jsch.jce.SHA1");
        config.put("sha224", "com.jcraft.jsch.jce.SHA224");
        config.put("sha256", "com.jcraft.jsch.jce.SHA256");
        config.put("sha384", "com.jcraft.jsch.jce.SHA384");
        config.put("sha512", "com.jcraft.jsch.jce.SHA512");
        config.put("signature.dss", "com.jcraft.jsch.jce.SignatureDSA");
        config.put("ssh-rsa", "com.jcraft.jsch.jce.SignatureRSA");
        config.put("rsa-sha2-256", "com.jcraft.jsch.jce.SignatureRSASHA256");
        config.put("rsa-sha2-512", "com.jcraft.jsch.jce.SignatureRSASHA512");
        config.put("ssh-rsa-sha224@ssh.com", "com.jcraft.jsch.jce.SignatureRSASHA224SSHCOM");
        config.put("ssh-rsa-sha256@ssh.com", "com.jcraft.jsch.jce.SignatureRSASHA256SSHCOM");
        config.put("ssh-rsa-sha384@ssh.com", "com.jcraft.jsch.jce.SignatureRSASHA384SSHCOM");
        config.put("ssh-rsa-sha512@ssh.com", "com.jcraft.jsch.jce.SignatureRSASHA512SSHCOM");
        config.put("keypairgen.dsa", "com.jcraft.jsch.jce.KeyPairGenDSA");
        config.put("keypairgen.rsa", "com.jcraft.jsch.jce.KeyPairGenRSA");
        config.put("keypairgen.ecdsa", "com.jcraft.jsch.jce.KeyPairGenECDSA");
        config.put("random", "com.jcraft.jsch.jce.Random");
        config.put("none", "com.jcraft.jsch.CipherNone");
        config.put("aes128-gcm@openssh.com", "com.jcraft.jsch.jce.AES128GCM");
        config.put("aes256-gcm@openssh.com", "com.jcraft.jsch.jce.AES256GCM");
        config.put("aes128-cbc", "com.jcraft.jsch.jce.AES128CBC");
        config.put("aes192-cbc", "com.jcraft.jsch.jce.AES192CBC");
        config.put("aes256-cbc", "com.jcraft.jsch.jce.AES256CBC");
        config.put("aes128-ctr", "com.jcraft.jsch.jce.AES128CTR");
        config.put("aes192-ctr", "com.jcraft.jsch.jce.AES192CTR");
        config.put("aes256-ctr", "com.jcraft.jsch.jce.AES256CTR");
        config.put("3des-ctr", "com.jcraft.jsch.jce.TripleDESCTR");
        config.put("arcfour", "com.jcraft.jsch.jce.ARCFOUR");
        config.put("arcfour128", "com.jcraft.jsch.jce.ARCFOUR128");
        config.put("arcfour256", "com.jcraft.jsch.jce.ARCFOUR256");
        config.put("userauth.none", "com.jcraft.jsch.UserAuthNone");
        config.put("userauth.password", "com.jcraft.jsch.UserAuthPassword");
        config.put("userauth.keyboard-interactive", "com.jcraft.jsch.UserAuthKeyboardInteractive");
        config.put("userauth.publickey", "com.jcraft.jsch.UserAuthPublicKey");
        config.put("userauth.gssapi-with-mic", "com.jcraft.jsch.UserAuthGSSAPIWithMIC");
        config.put("gssapi-with-mic.krb5", "com.jcraft.jsch.jgss.GSSContextKrb5");
        config.put("zlib", "com.jcraft.jsch.jzlib.Compression");
        config.put("zlib@openssh.com", "com.jcraft.jsch.jzlib.Compression");
        config.put("pbkdf", "com.jcraft.jsch.jce.PBKDF");
        if (JavaVersion.getVersion() >= 11) {
            config.put("chacha20-poly1305@openssh.com", "com.jcraft.jsch.jce.ChaCha20Poly1305");
            config.put("xdh", "com.jcraft.jsch.jce.XDH");
        } else {
            config.put("chacha20-poly1305@openssh.com", "com.jcraft.jsch.bc.ChaCha20Poly1305");
            config.put("xdh", "com.jcraft.jsch.bc.XDH");
        }
        if (JavaVersion.getVersion() >= 15) {
            config.put("keypairgen.eddsa", "com.jcraft.jsch.jce.KeyPairGenEdDSA");
            config.put("ssh-ed25519", "com.jcraft.jsch.jce.SignatureEd25519");
            config.put("ssh-ed448", "com.jcraft.jsch.jce.SignatureEd448");
        } else {
            config.put("keypairgen.eddsa", "com.jcraft.jsch.bc.KeyPairGenEdDSA");
            config.put("ssh-ed25519", "com.jcraft.jsch.bc.SignatureEd25519");
            config.put("ssh-ed448", "com.jcraft.jsch.bc.SignatureEd448");
        }
        config.put("StrictHostKeyChecking", "ask");
        config.put("HashKnownHosts", "no");
        config.put("PreferredAuthentications", Util.getSystemProperty("jsch.preferred_authentications", "gssapi-with-mic,publickey,keyboard-interactive,password"));
        config.put("PubkeyAcceptedAlgorithms", Util.getSystemProperty("jsch.client_pubkey", "ssh-ed25519,ecdsa-sha2-nistp256,ecdsa-sha2-nistp384,ecdsa-sha2-nistp521,rsa-sha2-512,rsa-sha2-256,ssh-rsa"));
        config.put("CheckCiphers", Util.getSystemProperty("jsch.check_ciphers", "chacha20-poly1305@openssh.com"));
        config.put("CheckMacs", Util.getSystemProperty("jsch.check_macs", ""));
        config.put("CheckKexes", Util.getSystemProperty("jsch.check_kexes", "curve25519-sha256,curve25519-sha256@libssh.org,curve448-sha512"));
        config.put("CheckSignatures", Util.getSystemProperty("jsch.check_signatures", "ssh-ed25519,ssh-ed448"));
        config.put("FingerprintHash", Util.getSystemProperty("jsch.fingerprint_hash", "sha256"));
        config.put("MaxAuthTries", Util.getSystemProperty("jsch.max_auth_tries", "6"));
        config.put("ClearAllForwardings", "no");
        logger = DEVNULL = new Logger(){

            @Override
            public boolean isEnabled(int level) {
                return false;
            }

            @Override
            public void log(int level, String message) {
            }
        };
    }
}

