/*
 * Decompiled with CFR 0.152.
 */
package org.openjax.security.nacl;

public class Poly1305 {
    private final byte[] buffer = new byte[16];
    private final int[] r = new int[10];
    private final int[] h = new int[10];
    private final int[] pad = new int[8];
    private int leftover = 0;
    private int fin = 0;

    public Poly1305(byte[] key) {
        int t0 = key[0] & 0xFF | (key[1] & 0xFF) << 8;
        this.r[0] = t0 & 0x1FFF;
        int t1 = key[2] & 0xFF | (key[3] & 0xFF) << 8;
        this.r[1] = (t0 >>> 13 | t1 << 3) & 0x1FFF;
        int t2 = key[4] & 0xFF | (key[5] & 0xFF) << 8;
        this.r[2] = (t1 >>> 10 | t2 << 6) & 0x1F03;
        int t3 = key[6] & 0xFF | (key[7] & 0xFF) << 8;
        this.r[3] = (t2 >>> 7 | t3 << 9) & 0x1FFF;
        int t4 = key[8] & 0xFF | (key[9] & 0xFF) << 8;
        this.r[4] = (t3 >>> 4 | t4 << 12) & 0xFF;
        this.r[5] = t4 >>> 1 & 0x1FFE;
        int t5 = key[10] & 0xFF | (key[11] & 0xFF) << 8;
        this.r[6] = (t4 >>> 14 | t5 << 2) & 0x1FFF;
        int t6 = key[12] & 0xFF | (key[13] & 0xFF) << 8;
        this.r[7] = (t5 >>> 11 | t6 << 5) & 0x1F81;
        int t7 = key[14] & 0xFF | (key[15] & 0xFF) << 8;
        this.r[8] = (t6 >>> 8 | t7 << 8) & 0x1FFF;
        this.r[9] = t7 >>> 5 & 0x7F;
        this.pad[0] = key[16] & 0xFF | (key[17] & 0xFF) << 8;
        this.pad[1] = key[18] & 0xFF | (key[19] & 0xFF) << 8;
        this.pad[2] = key[20] & 0xFF | (key[21] & 0xFF) << 8;
        this.pad[3] = key[22] & 0xFF | (key[23] & 0xFF) << 8;
        this.pad[4] = key[24] & 0xFF | (key[25] & 0xFF) << 8;
        this.pad[5] = key[26] & 0xFF | (key[27] & 0xFF) << 8;
        this.pad[6] = key[28] & 0xFF | (key[29] & 0xFF) << 8;
        this.pad[7] = key[30] & 0xFF | (key[31] & 0xFF) << 8;
    }

    Poly1305 blocks(byte[] m, int mpos, int bytes) {
        int hibit = this.fin != 0 ? 0 : 2048;
        int h0 = this.h[0];
        int h1 = this.h[1];
        int h2 = this.h[2];
        int h3 = this.h[3];
        int h4 = this.h[4];
        int h5 = this.h[5];
        int h6 = this.h[6];
        int h7 = this.h[7];
        int h8 = this.h[8];
        int h9 = this.h[9];
        int r0 = this.r[0];
        int r1 = this.r[1];
        int r2 = this.r[2];
        int r3 = this.r[3];
        int r4 = this.r[4];
        int r5 = this.r[5];
        int r6 = this.r[6];
        int r7 = this.r[7];
        int r8 = this.r[8];
        int r9 = this.r[9];
        while (bytes >= 16) {
            int c;
            int t0 = m[mpos + 0] & 0xFF | (m[mpos + 1] & 0xFF) << 8;
            h0 += t0 & 0x1FFF;
            int t1 = m[mpos + 2] & 0xFF | (m[mpos + 3] & 0xFF) << 8;
            h1 += (t0 >>> 13 | t1 << 3) & 0x1FFF;
            int t2 = m[mpos + 4] & 0xFF | (m[mpos + 5] & 0xFF) << 8;
            h2 += (t1 >>> 10 | t2 << 6) & 0x1FFF;
            int t3 = m[mpos + 6] & 0xFF | (m[mpos + 7] & 0xFF) << 8;
            h3 += (t2 >>> 7 | t3 << 9) & 0x1FFF;
            int t4 = m[mpos + 8] & 0xFF | (m[mpos + 9] & 0xFF) << 8;
            h4 += (t3 >>> 4 | t4 << 12) & 0x1FFF;
            h5 += t4 >>> 1 & 0x1FFF;
            int t5 = m[mpos + 10] & 0xFF | (m[mpos + 11] & 0xFF) << 8;
            h6 += (t4 >>> 14 | t5 << 2) & 0x1FFF;
            int t6 = m[mpos + 12] & 0xFF | (m[mpos + 13] & 0xFF) << 8;
            h7 += (t5 >>> 11 | t6 << 5) & 0x1FFF;
            int t7 = m[mpos + 14] & 0xFF | (m[mpos + 15] & 0xFF) << 8;
            h8 += (t6 >>> 8 | t7 << 8) & 0x1FFF;
            h9 += t7 >>> 5 | hibit;
            int d0 = c = 0;
            d0 += h0 * r0;
            d0 += h1 * (5 * r9);
            d0 += h2 * (5 * r8);
            d0 += h3 * (5 * r7);
            c = (d0 += h4 * (5 * r6)) >>> 13;
            d0 &= 0x1FFF;
            d0 += h5 * (5 * r5);
            d0 += h6 * (5 * r4);
            d0 += h7 * (5 * r3);
            d0 += h8 * (5 * r2);
            d0 &= 0x1FFF;
            int d1 = c += (d0 += h9 * (5 * r1)) >>> 13;
            d1 += h0 * r1;
            d1 += h1 * r0;
            d1 += h2 * (5 * r9);
            d1 += h3 * (5 * r8);
            c = (d1 += h4 * (5 * r7)) >>> 13;
            d1 &= 0x1FFF;
            d1 += h5 * (5 * r6);
            d1 += h6 * (5 * r5);
            d1 += h7 * (5 * r4);
            d1 += h8 * (5 * r3);
            d1 &= 0x1FFF;
            int d2 = c += (d1 += h9 * (5 * r2)) >>> 13;
            d2 += h0 * r2;
            d2 += h1 * r1;
            d2 += h2 * r0;
            d2 += h3 * (5 * r9);
            c = (d2 += h4 * (5 * r8)) >>> 13;
            d2 &= 0x1FFF;
            d2 += h5 * (5 * r7);
            d2 += h6 * (5 * r6);
            d2 += h7 * (5 * r5);
            d2 += h8 * (5 * r4);
            d2 &= 0x1FFF;
            int d3 = c += (d2 += h9 * (5 * r3)) >>> 13;
            d3 += h0 * r3;
            d3 += h1 * r2;
            d3 += h2 * r1;
            d3 += h3 * r0;
            c = (d3 += h4 * (5 * r9)) >>> 13;
            d3 &= 0x1FFF;
            d3 += h5 * (5 * r8);
            d3 += h6 * (5 * r7);
            d3 += h7 * (5 * r6);
            d3 += h8 * (5 * r5);
            d3 &= 0x1FFF;
            int d4 = c += (d3 += h9 * (5 * r4)) >>> 13;
            d4 += h0 * r4;
            d4 += h1 * r3;
            d4 += h2 * r2;
            d4 += h3 * r1;
            c = (d4 += h4 * r0) >>> 13;
            d4 &= 0x1FFF;
            d4 += h5 * (5 * r9);
            d4 += h6 * (5 * r8);
            d4 += h7 * (5 * r7);
            d4 += h8 * (5 * r6);
            d4 &= 0x1FFF;
            int d5 = c += (d4 += h9 * (5 * r5)) >>> 13;
            d5 += h0 * r5;
            d5 += h1 * r4;
            d5 += h2 * r3;
            d5 += h3 * r2;
            c = (d5 += h4 * r1) >>> 13;
            d5 &= 0x1FFF;
            d5 += h5 * r0;
            d5 += h6 * (5 * r9);
            d5 += h7 * (5 * r8);
            d5 += h8 * (5 * r7);
            d5 &= 0x1FFF;
            int d6 = c += (d5 += h9 * (5 * r6)) >>> 13;
            d6 += h0 * r6;
            d6 += h1 * r5;
            d6 += h2 * r4;
            d6 += h3 * r3;
            c = (d6 += h4 * r2) >>> 13;
            d6 &= 0x1FFF;
            d6 += h5 * r1;
            d6 += h6 * r0;
            d6 += h7 * (5 * r9);
            d6 += h8 * (5 * r8);
            d6 &= 0x1FFF;
            int d7 = c += (d6 += h9 * (5 * r7)) >>> 13;
            d7 += h0 * r7;
            d7 += h1 * r6;
            d7 += h2 * r5;
            d7 += h3 * r4;
            c = (d7 += h4 * r3) >>> 13;
            d7 &= 0x1FFF;
            d7 += h5 * r2;
            d7 += h6 * r1;
            d7 += h7 * r0;
            d7 += h8 * (5 * r9);
            d7 &= 0x1FFF;
            int d8 = c += (d7 += h9 * (5 * r8)) >>> 13;
            d8 += h0 * r8;
            d8 += h1 * r7;
            d8 += h2 * r6;
            d8 += h3 * r5;
            c = (d8 += h4 * r4) >>> 13;
            d8 &= 0x1FFF;
            d8 += h5 * r3;
            d8 += h6 * r2;
            d8 += h7 * r1;
            d8 += h8 * r0;
            d8 &= 0x1FFF;
            int d9 = c += (d8 += h9 * (5 * r9)) >>> 13;
            d9 += h0 * r9;
            d9 += h1 * r8;
            d9 += h2 * r7;
            d9 += h3 * r6;
            c = (d9 += h4 * r5) >>> 13;
            d9 &= 0x1FFF;
            d9 += h5 * r4;
            d9 += h6 * r3;
            d9 += h7 * r2;
            d9 += h8 * r1;
            c += (d9 += h9 * r0) >>> 13;
            d9 &= 0x1FFF;
            c += c << 2;
            c += d0;
            d0 = c & 0x1FFF;
            h0 = d0;
            h1 = d1 += (c >>>= 13);
            h2 = d2;
            h3 = d3;
            h4 = d4;
            h5 = d5;
            h6 = d6;
            h7 = d7;
            h8 = d8;
            h9 = d9;
            mpos += 16;
            bytes -= 16;
        }
        this.h[0] = h0;
        this.h[1] = h1;
        this.h[2] = h2;
        this.h[3] = h3;
        this.h[4] = h4;
        this.h[5] = h5;
        this.h[6] = h6;
        this.h[7] = h7;
        this.h[8] = h8;
        this.h[9] = h9;
        return this;
    }

    public Poly1305 finish(byte[] mac, int macpos) {
        int i;
        int[] g = new int[10];
        if (this.leftover != 0) {
            i = this.leftover;
            this.buffer[i++] = 1;
            while (i < 16) {
                this.buffer[i] = 0;
                ++i;
            }
            this.fin = 1;
            this.blocks(this.buffer, 0, 16);
        }
        int c = this.h[1] >>> 13;
        this.h[1] = this.h[1] & 0x1FFF;
        i = 2;
        while (i < 10) {
            int n = i;
            this.h[n] = this.h[n] + c;
            c = this.h[i] >>> 13;
            int n2 = i++;
            this.h[n2] = this.h[n2] & 0x1FFF;
        }
        this.h[0] = this.h[0] + c * 5;
        c = this.h[0] >>> 13;
        this.h[0] = this.h[0] & 0x1FFF;
        this.h[1] = this.h[1] + c;
        c = this.h[1] >>> 13;
        this.h[1] = this.h[1] & 0x1FFF;
        this.h[2] = this.h[2] + c;
        g[0] = this.h[0] + 5;
        c = g[0] >>> 13;
        g[0] = g[0] & 0x1FFF;
        i = 1;
        while (i < 10) {
            g[i] = this.h[i] + c;
            c = g[i] >>> 13;
            int n = i++;
            g[n] = g[n] & 0x1FFF;
        }
        g[9] = g[9] - 8192;
        g[9] = g[9] & 0xFFFF;
        int mask = (c ^ 1) - 1;
        mask &= 0xFFFF;
        i = 0;
        while (i < 10) {
            int n = i++;
            g[n] = g[n] & mask;
        }
        mask ^= 0xFFFFFFFF;
        for (i = 0; i < 10; ++i) {
            this.h[i] = this.h[i] & mask | g[i];
        }
        this.h[0] = (this.h[0] | this.h[1] << 13) & 0xFFFF;
        this.h[1] = (this.h[1] >>> 3 | this.h[2] << 10) & 0xFFFF;
        this.h[2] = (this.h[2] >>> 6 | this.h[3] << 7) & 0xFFFF;
        this.h[3] = (this.h[3] >>> 9 | this.h[4] << 4) & 0xFFFF;
        this.h[4] = (this.h[4] >>> 12 | this.h[5] << 1 | this.h[6] << 14) & 0xFFFF;
        this.h[5] = (this.h[6] >>> 2 | this.h[7] << 11) & 0xFFFF;
        this.h[6] = (this.h[7] >>> 5 | this.h[8] << 8) & 0xFFFF;
        this.h[7] = (this.h[8] >>> 8 | this.h[9] << 5) & 0xFFFF;
        int f = this.h[0] + this.pad[0];
        this.h[0] = f & 0xFFFF;
        for (i = 1; i < 8; ++i) {
            f = this.h[i] + this.pad[i] + (f >>> 16);
            this.h[i] = f & 0xFFFF;
        }
        mac[macpos + 0] = (byte)(this.h[0] & 0xFF);
        mac[macpos + 1] = (byte)(this.h[0] >>> 8 & 0xFF);
        mac[macpos + 2] = (byte)(this.h[1] & 0xFF);
        mac[macpos + 3] = (byte)(this.h[1] >>> 8 & 0xFF);
        mac[macpos + 4] = (byte)(this.h[2] & 0xFF);
        mac[macpos + 5] = (byte)(this.h[2] >>> 8 & 0xFF);
        mac[macpos + 6] = (byte)(this.h[3] & 0xFF);
        mac[macpos + 7] = (byte)(this.h[3] >>> 8 & 0xFF);
        mac[macpos + 8] = (byte)(this.h[4] & 0xFF);
        mac[macpos + 9] = (byte)(this.h[4] >>> 8 & 0xFF);
        mac[macpos + 10] = (byte)(this.h[5] & 0xFF);
        mac[macpos + 11] = (byte)(this.h[5] >>> 8 & 0xFF);
        mac[macpos + 12] = (byte)(this.h[6] & 0xFF);
        mac[macpos + 13] = (byte)(this.h[6] >>> 8 & 0xFF);
        mac[macpos + 14] = (byte)(this.h[7] & 0xFF);
        mac[macpos + 15] = (byte)(this.h[7] >>> 8 & 0xFF);
        return this;
    }

    public Poly1305 update(byte[] m, int mpos, int bytes) {
        int i;
        int want;
        if (this.leftover != 0) {
            want = 16 - this.leftover;
            if (want > bytes) {
                want = bytes;
            }
            for (i = 0; i < want; ++i) {
                this.buffer[this.leftover + i] = m[mpos + i];
            }
            bytes -= want;
            mpos += want;
            this.leftover += want;
            if (this.leftover < 16) {
                return this;
            }
            this.blocks(this.buffer, 0, 16);
            this.leftover = 0;
        }
        if (bytes >= 16) {
            want = bytes - bytes % 16;
            this.blocks(m, mpos, want);
            mpos += want;
            bytes -= want;
        }
        if (bytes != 0) {
            for (i = 0; i < bytes; ++i) {
                this.buffer[this.leftover + i] = m[mpos + i];
            }
            this.leftover += bytes;
        }
        return this;
    }
}

