/*
 * Decompiled with CFR 0.152.
 */
package com.jcraft.jsch.jce;

import com.jcraft.jsch.jce.KeyPairGenXEC;
import java.math.BigInteger;
import java.security.KeyFactory;
import java.security.PublicKey;
import java.security.interfaces.XECPublicKey;
import java.security.spec.XECPublicKeySpec;
import javax.crypto.KeyAgreement;

public class XDH
implements com.jcraft.jsch.XDH {
    String name;
    byte[] Q_array;
    XECPublicKey publicKey;
    private KeyAgreement myKeyAgree;

    @Override
    public void init(String name) throws Exception {
        this.name = name;
        this.myKeyAgree = KeyAgreement.getInstance("XDH");
        KeyPairGenXEC kpair = new KeyPairGenXEC();
        kpair.init(name);
        this.publicKey = kpair.getPublicKey();
        this.Q_array = XDH.rotate(this.publicKey.getU().toByteArray(), false);
        this.myKeyAgree.init(kpair.getPrivateKey());
    }

    @Override
    public byte[] getQ() throws Exception {
        return this.Q_array;
    }

    @Override
    public byte[] getSecret(byte[] Q) throws Exception {
        KeyFactory kf = KeyFactory.getInstance("XDH");
        BigInteger u = new BigInteger(XDH.rotate(Q, this.name.equals("X25519")));
        XECPublicKeySpec spec = new XECPublicKeySpec(this.publicKey.getParams(), u);
        PublicKey theirPublicKey = kf.generatePublic(spec);
        this.myKeyAgree.doPhase(theirPublicKey, true);
        return this.myKeyAgree.generateSecret();
    }

    @Override
    public boolean validate(byte[] u) throws Exception {
        return true;
    }

    private static byte[] rotate(byte[] in, boolean clearHigh) {
        int len = in.length;
        byte[] out = new byte[len];
        for (int i = 0; i < len; ++i) {
            out[i] = in[len - i - 1];
        }
        if (clearHigh) {
            out[0] = (byte)(out[0] & 0x7F);
        }
        return out;
    }
}

