/*
 * Decompiled with CFR 0.152.
 */
package com.github.mvp4g.mvp4g2.processor.scanner.validation;

import com.github.mvp4g.mvp4g2.processor.ProcessorException;
import com.github.mvp4g.mvp4g2.processor.ProcessorUtils;
import com.github.mvp4g.mvp4g2.processor.model.EventBusMetaModel;
import com.github.mvp4g.mvp4g2.processor.model.EventMetaModel;
import com.github.mvp4g.mvp4g2.processor.model.HandlerMetaModel;
import com.github.mvp4g.mvp4g2.processor.model.PresenterMetaModel;
import com.github.mvp4g.mvp4g2.processor.model.intern.ClassNameModel;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.stream.IntStream;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;

public class ModelValidator {
    private ProcessorUtils processorUtils;
    private EventBusMetaModel eventBusMetaModel;
    private HandlerMetaModel handlerMetaModel;
    private PresenterMetaModel presenterMetaModel;

    private ModelValidator() {
    }

    private ModelValidator(Builder builder) {
        this.processorUtils = builder.processorUtils;
        this.eventBusMetaModel = builder.eventBusMetaModel;
        this.handlerMetaModel = builder.handlerMetaModel;
        this.presenterMetaModel = builder.presenterMetaModel;
    }

    public static Builder builder() {
        return new Builder();
    }

    public void validate() throws ProcessorException {
        this.checkHandlerUsedAsBindAndHandler();
        this.checkNumbersOfPrensentersWhichImplementsIsShell();
        this.checkIfAllEventHandlerMethodsAreUsed();
        this.checkIfAllEventMethodsAreHandled();
        this.checkIfAllEventMethodsOfHandlerAreHandled();
    }

    private void checkHandlerUsedAsBindAndHandler() throws ProcessorException {
        if (!Objects.isNull(this.eventBusMetaModel)) {
            for (EventMetaModel eventMetaModel : this.eventBusMetaModel.getEventMetaModels()) {
                for (ClassNameModel bindingClass : eventMetaModel.getBindings()) {
                    for (ClassNameModel handlerClass : eventMetaModel.getHandlers()) {
                        if (!bindingClass.equals(handlerClass)) continue;
                        throw new ProcessorException("Mvp4g2Processor: Event: >>" + eventMetaModel.getEventName() + "<< - handler: >>" + handlerClass.getClassName() + "<< can not be set in bind- and handlers-attribute");
                    }
                    if (this.handlerMetaModel.getHandlerData(bindingClass.getClassName()) != null) {
                        for (String eventName : this.handlerMetaModel.getHandlerData(bindingClass.getClassName()).getHandledEvents()) {
                            if (!eventMetaModel.getEventName().equals(eventName)) continue;
                            throw new ProcessorException("Mvp4g2Processor: Event: >>" + eventMetaModel.getEventName() + "<< - handler: >>" + bindingClass.getClassName() + "<< can not be set in bind- and handlers-attribute");
                        }
                    }
                    if (this.presenterMetaModel.getPresenterData(bindingClass.getClassName()) == null) continue;
                    for (String eventName : this.presenterMetaModel.getPresenterData(bindingClass.getClassName()).getHandledEvents()) {
                        if (!eventMetaModel.getEventName().equals(eventName)) continue;
                        throw new ProcessorException("Mvp4g2Processor: Event: >>" + eventMetaModel.getEventName() + "<< - handler: >>" + bindingClass.getClassName() + "<< can not be set in bind- and handlers-attribute");
                    }
                }
            }
        } else {
            throw new ProcessorException("Mvp4g2Processor: no EventBusMetaModel found! Did you forget to create an EventBus for mvp4g2 or forget to annotate the EventBus with @EventBus?");
        }
    }

    private void checkNumbersOfPrensentersWhichImplementsIsShell() throws ProcessorException {
        if (!Objects.isNull(this.presenterMetaModel)) {
            boolean isShell = false;
            for (PresenterMetaModel.PresenterData presenterData : this.presenterMetaModel.getPresenterDatas()) {
                if (!presenterData.isShell()) continue;
                if (isShell) {
                    throw new ProcessorException("Mvp4g2Processor: there can be only one presenter implementing IsShell");
                }
                isShell = true;
            }
        }
    }

    private void checkIfAllEventHandlerMethodsAreUsed() {
        if (!Objects.isNull(this.presenterMetaModel) && !Objects.isNull(this.eventBusMetaModel)) {
            this.presenterMetaModel.getPresenterDatas().forEach(presenterData -> presenterData.getHandledEvents().stream().map(handledEvents -> Arrays.asList(handledEvents.split(","))).flatMap(Collection::stream).filter(event -> event != null && event.trim().length() > 0).map(event -> this.processorUtils.createEventNameFromHandlingMethod((String)event)).filter(event -> this.eventBusMetaModel.getEventMetaModel((String)event) == null).forEach(event -> this.processorUtils.createWarningMessage("Mvp4g2Processor: presenter >>" + presenterData.getPresenter().getClassName() + "<< -> event >>" + this.createMethodName((String)event) + "<< is never called by the eventbus")));
        }
    }

    private void checkIfAllEventMethodsAreHandled() {
        if (!Objects.isNull(this.eventBusMetaModel)) {
            for (EventMetaModel eventModel : this.eventBusMetaModel.getEventMetaModels()) {
                if (eventModel.getHandlers().size() != 0) continue;
                boolean eventIsHandled = false;
                if (!Objects.isNull(this.presenterMetaModel)) {
                    eventIsHandled = this.presenterMetaModel.getPresenterDatas().stream().anyMatch(presenterData -> presenterData.handlesEvents(this.processorUtils.createEventHandlingMethodName(eventModel.getEventInternalName())));
                }
                if (!eventIsHandled && !Objects.isNull(this.handlerMetaModel)) {
                    eventIsHandled = this.handlerMetaModel.getHandlerDatas().stream().anyMatch(handlerData -> handlerData.handlesEvents(this.processorUtils.createEventHandlingMethodName(eventModel.getEventInternalName())));
                }
                if (eventIsHandled) continue;
                if (eventModel.getBindings().size() > 0) {
                    this.processorUtils.createNoteMessage("Mvp4g2Processor: event >>" + this.createMethodName(eventModel.getEventInternalName()) + "<< is only used for binding");
                    continue;
                }
                this.processorUtils.createErrorMessage("Mvp4g2Processor: event >>" + this.createMethodName(eventModel.getEventInternalName()) + "<< is never handled by a presenter or handler");
            }
        }
    }

    private void checkIfAllEventMethodsOfHandlerAreHandled() throws ProcessorException {
        if (!Objects.isNull(this.eventBusMetaModel)) {
            for (EventMetaModel eventMetaModel : this.eventBusMetaModel.getEventMetaModels()) {
                for (ClassNameModel classNameModel : eventMetaModel.getHandlers()) {
                    this.hasEventHandlingMethodImplemented(eventMetaModel, eventMetaModel.getEventInternalName(), classNameModel);
                }
            }
        }
    }

    private String createMethodName(String eventInternalName) {
        List<String> tokens = Arrays.asList(eventInternalName.split("_pPp_"));
        StringBuilder sb = new StringBuilder();
        sb.append(tokens.get(0)).append("(");
        int bound = tokens.size();
        IntStream.range(1, bound).forEachOrdered(i -> {
            sb.append(((String)tokens.get(i)).replace("_", "."));
            if (i < tokens.size() - 1) {
                sb.append(", ");
            }
        });
        sb.append(")");
        return sb.toString();
    }

    private void hasEventHandlingMethodImplemented(EventMetaModel eventMetaModel, String eventInternalName, ClassNameModel classNameModel) throws ProcessorException {
        TypeElement typeElement = this.processorUtils.getElements().getTypeElement(classNameModel.getClassName());
        if (typeElement != null) {
            HashMap nameOfExecutableElements = new HashMap();
            this.processorUtils.getElements().getAllMembers(typeElement).stream().filter(element -> element instanceof ExecutableElement).map(element -> (ExecutableElement)element).forEach(executableElement -> nameOfExecutableElements.put(executableElement.toString(), executableElement));
            String methodNameToLookFor = this.createEventHandlungMethodName(eventInternalName);
            ExecutableElement handlingElement = (ExecutableElement)nameOfExecutableElements.get(methodNameToLookFor);
            if (handlingElement != null) {
                if (!"void".equals(handlingElement.getReturnType().toString())) {
                    throw new ProcessorException("Mvp4g2Processor: EventElement: >>" + eventInternalName.split(",")[0] + "<< must return 'void'");
                }
                return;
            }
            if (eventMetaModel.getBindings().size() > 0) {
                this.processorUtils.createNoteMessage("Mvp4g2Processor: event >>" + eventInternalName.split(",")[0] + "<< is only used for binding");
            } else {
                this.processorUtils.createErrorMessage("Mvp4g2Processor: presenter >>" + classNameModel.getClassName() + "<< -> event >>" + this.createEventHandlungMethodName(eventInternalName) + "<< is not handled by presenter/handler and has no bindings");
            }
        }
    }

    private String createEventHandlungMethodName(String eventInternalName) {
        List<String> tokens = Arrays.asList(eventInternalName.split("_pPp_"));
        StringBuilder sb = new StringBuilder();
        sb.append("on").append(tokens.get(0).substring(0, 1).toUpperCase()).append(tokens.get(0).substring(1)).append("(");
        int bound = tokens.size();
        IntStream.range(1, bound).forEachOrdered(i -> {
            sb.append(((String)tokens.get(i)).replace("_", "."));
            if (i < tokens.size() - 1) {
                sb.append(",");
            }
        });
        sb.append(")");
        return sb.toString();
    }

    public static final class Builder {
        ProcessorUtils processorUtils;
        EventBusMetaModel eventBusMetaModel;
        HandlerMetaModel handlerMetaModel;
        PresenterMetaModel presenterMetaModel;

        public Builder processorUtils(ProcessorUtils processorUtils) {
            this.processorUtils = processorUtils;
            return this;
        }

        public Builder eventBusMetaModel(EventBusMetaModel eventBusMetaModel) {
            this.eventBusMetaModel = eventBusMetaModel;
            return this;
        }

        public Builder handlerMetaModel(HandlerMetaModel handlerMetaModel) {
            this.handlerMetaModel = handlerMetaModel;
            return this;
        }

        public Builder presenterMetaModel(PresenterMetaModel presenterMetaModel) {
            this.presenterMetaModel = presenterMetaModel;
            return this;
        }

        public ModelValidator build() {
            return new ModelValidator(this);
        }
    }
}

