/*
 * Decompiled with CFR 0.152.
 */
package com.github.mvp4g.mvp4g2.processor.scanner;

import com.github.mvp4g.mvp4g2.core.eventbus.annotation.Debug;
import com.github.mvp4g.mvp4g2.core.eventbus.annotation.EventBus;
import com.github.mvp4g.mvp4g2.core.eventbus.annotation.Filters;
import com.github.mvp4g.mvp4g2.processor.ProcessorException;
import com.github.mvp4g.mvp4g2.processor.ProcessorUtils;
import com.github.mvp4g.mvp4g2.processor.model.EventBusMetaModel;
import com.github.mvp4g.mvp4g2.processor.model.EventMetaModel;
import com.github.mvp4g.mvp4g2.processor.scanner.DebugAnnotationScanner;
import com.github.mvp4g.mvp4g2.processor.scanner.EventAnnotationScanner;
import com.github.mvp4g.mvp4g2.processor.scanner.FiltersAnnotationScanner;
import com.github.mvp4g.mvp4g2.processor.scanner.validation.EventBusAnnotationValidator;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.MirroredTypeException;
import javax.tools.FileObject;
import javax.tools.StandardLocation;

public class EventBusAnnotationScanner {
    private static final String EVENTBUS_PROPERTIES = "eventBus.properties";
    private ProcessorUtils processorUtils;
    private ProcessingEnvironment processingEnvironment;
    private RoundEnvironment roundEnvironment;

    private EventBusAnnotationScanner(Builder builder) {
        this.processingEnvironment = builder.processingEnvironment;
        this.roundEnvironment = builder.roundEnvironment;
        this.setUp();
    }

    private void setUp() {
        this.processorUtils = ProcessorUtils.builder().processingEnvironment(this.processingEnvironment).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public EventBusMetaModel scan(RoundEnvironment roundEnvironment) throws ProcessorException {
        EventBusMetaModel model = this.restore();
        if (!roundEnvironment.getElementsAnnotatedWith(EventBus.class).isEmpty()) {
            EventBusAnnotationValidator eventBusValidaitor = EventBusAnnotationValidator.builder().roundEnvironment(roundEnvironment).processingEnvironment(this.processingEnvironment).build();
            eventBusValidaitor.validate();
            Optional optionalElement = this.roundEnvironment.getElementsAnnotatedWith(EventBus.class).stream().findFirst();
            if (optionalElement.isPresent()) {
                Element eventBusAnnotationElement = (Element)optionalElement.get();
                eventBusValidaitor.validate(eventBusAnnotationElement);
                EventBus eventBusAnnotation = eventBusAnnotationElement.getAnnotation(EventBus.class);
                if (!Objects.isNull(eventBusAnnotation)) {
                    TypeElement shellTypeElement = this.getShellTypeElement(eventBusAnnotation);
                    model = new EventBusMetaModel(eventBusAnnotationElement.toString(), Objects.isNull(shellTypeElement) ? "" : shellTypeElement.toString());
                    model = DebugAnnotationScanner.builder().processingEnvironment(this.processingEnvironment).eventBusTypeElement((TypeElement)eventBusAnnotationElement).eventBusMetaModel(model).build().scan(roundEnvironment);
                    model = FiltersAnnotationScanner.builder().processingEnvironment(this.processingEnvironment).eventBusTypeElement((TypeElement)eventBusAnnotationElement).eventBusMetaModel(model).build().scan(roundEnvironment);
                    model = EventAnnotationScanner.builder().processingEnvironment(this.processingEnvironment).eventBusTypeElement((TypeElement)eventBusAnnotationElement).eventBusMetaModel(model).build().scan(roundEnvironment);
                    this.processorUtils.store(model, this.createRelativeFileName());
                }
            }
        } else {
            EventBus eventBusAnnotation;
            EventBus eventBusAnnotation2;
            Optional optionalDebugElement = this.roundEnvironment.getElementsAnnotatedWith(Debug.class).stream().findFirst();
            if (optionalDebugElement.isPresent() && (eventBusAnnotation2 = ((Element)optionalDebugElement.get()).getAnnotation(EventBus.class)) == null) {
                throw new ProcessorException(((TypeElement)optionalDebugElement.get()).getQualifiedName().toString() + " -> @Debug can only be used with an interfaces annotated with @EventBus");
            }
            Optional optionalFiltersElement = this.roundEnvironment.getElementsAnnotatedWith(Filters.class).stream().findFirst();
            if (optionalFiltersElement.isPresent() && (eventBusAnnotation = ((Element)optionalFiltersElement.get()).getAnnotation(EventBus.class)) == null) {
                throw new ProcessorException(((TypeElement)optionalFiltersElement.get()).getQualifiedName().toString() + " -> @Filters can only be used with an interfaces annotated with @EventBus");
            }
        }
        return model;
    }

    private EventBusMetaModel restore() {
        Properties props = new Properties();
        try {
            FileObject resource = this.processingEnvironment.getFiler().getResource(StandardLocation.CLASS_OUTPUT, "", this.createRelativeFileName());
            props.load(resource.openInputStream());
            EventBusMetaModel model = new EventBusMetaModel(props);
            ArrayList<EventMetaModel> eventModels = new ArrayList<EventMetaModel>();
            for (String eventInternalName : model.getEvents()) {
                FileObject resourceEvent = this.processingEnvironment.getFiler().getResource(StandardLocation.CLASS_OUTPUT, "", this.createRelativeEventModelFileName(eventInternalName));
                props.load(resourceEvent.openInputStream());
                eventModels.add(new EventMetaModel(props));
            }
            eventModels.forEach(model::add);
            return model;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    private TypeElement getShellTypeElement(EventBus eventBusAnnotation) {
        try {
            eventBusAnnotation.shell();
        }
        catch (MirroredTypeException exception) {
            return (TypeElement)this.processingEnvironment.getTypeUtils().asElement(exception.getTypeMirror());
        }
        return null;
    }

    private String createRelativeFileName() {
        return "META-INF/mvp4g2/eventBus.properties";
    }

    private String createRelativeEventModelFileName(String eventInternalName) {
        return "META-INF/mvp4g2/" + eventInternalName + ".properties";
    }

    public static class Builder {
        ProcessingEnvironment processingEnvironment;
        RoundEnvironment roundEnvironment;

        public Builder processingEnvironment(ProcessingEnvironment processingEnvironment) {
            this.processingEnvironment = processingEnvironment;
            return this;
        }

        public Builder roundEnvironment(RoundEnvironment roundEnvironment) {
            this.roundEnvironment = roundEnvironment;
            return this;
        }

        public EventBusAnnotationScanner build() {
            return new EventBusAnnotationScanner(this);
        }
    }
}

