/*
 * Decompiled with CFR 0.152.
 */
package com.github.mvp4g.mvp4g2.processor.scanner;

import com.github.mvp4g.mvp4g2.core.eventbus.annotation.Debug;
import com.github.mvp4g.mvp4g2.processor.ProcessorException;
import com.github.mvp4g.mvp4g2.processor.ProcessorUtils;
import com.github.mvp4g.mvp4g2.processor.model.EventBusMetaModel;
import com.github.mvp4g.mvp4g2.processor.scanner.validation.DebugAnnotationValidator;
import java.util.Objects;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.MirroredTypeException;

public class DebugAnnotationScanner {
    private ProcessorUtils processorUtils;
    private ProcessingEnvironment processingEnvironment;
    private TypeElement eventBusTypeElement;
    private EventBusMetaModel eventBusMetaModel;

    private DebugAnnotationScanner(Builder builder) {
        this.processingEnvironment = builder.processingEnvironment;
        this.eventBusTypeElement = builder.eventBusTypeElement;
        this.eventBusMetaModel = builder.eventBusMetaModel;
        this.setUp();
    }

    private void setUp() {
        this.processorUtils = ProcessorUtils.builder().processingEnvironment(this.processingEnvironment).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public EventBusMetaModel scan(RoundEnvironment roundEnvironment) throws ProcessorException {
        DebugAnnotationValidator.builder().roundEnvironment(roundEnvironment).processingEnvironment(this.processingEnvironment).build().validate();
        Debug debugAnnotation = this.eventBusTypeElement.getAnnotation(Debug.class);
        if (!Objects.isNull(debugAnnotation)) {
            this.eventBusMetaModel.setHasDebugAnnotation("true");
            this.eventBusMetaModel.setDebugLogLevel(debugAnnotation.logLevel().toString());
            if (!Objects.isNull(this.getLogger(debugAnnotation))) {
                this.eventBusMetaModel.setDebugLogger(this.getLogger(debugAnnotation).getQualifiedName().toString());
            }
        } else {
            this.eventBusMetaModel.setHasDebugAnnotation("false");
            this.eventBusMetaModel.setDebugLogLevel("");
            this.eventBusMetaModel.setDebugLogger("");
        }
        return this.eventBusMetaModel;
    }

    private TypeElement getLogger(Debug debugAnnotation) {
        try {
            debugAnnotation.logger();
        }
        catch (MirroredTypeException exception) {
            return (TypeElement)this.processingEnvironment.getTypeUtils().asElement(exception.getTypeMirror());
        }
        return null;
    }

    public static class Builder {
        ProcessingEnvironment processingEnvironment;
        TypeElement eventBusTypeElement;
        EventBusMetaModel eventBusMetaModel;

        public Builder processingEnvironment(ProcessingEnvironment processingEnvironment) {
            this.processingEnvironment = processingEnvironment;
            return this;
        }

        public Builder eventBusTypeElement(TypeElement eventBusTypeElement) {
            this.eventBusTypeElement = eventBusTypeElement;
            return this;
        }

        public Builder eventBusMetaModel(EventBusMetaModel eventBusMetaModel) {
            this.eventBusMetaModel = eventBusMetaModel;
            return this;
        }

        public DebugAnnotationScanner build() {
            return new DebugAnnotationScanner(this);
        }
    }
}

