/*
 * Decompiled with CFR 0.152.
 */
package com.github.mvp4g.mvp4g2.processor.model;

import com.github.mvp4g.mvp4g2.processor.model.intern.ClassNameModel;
import com.github.mvp4g.mvp4g2.processor.model.intern.IsMetaModel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public class PresenterMetaModel
implements IsMetaModel {
    private static final String KEY_PRESENTERS = "presenters";
    private static final String KEY_PRESENTER = ".presenter";
    private static final String KEY_IS_MULTIPLE = ".isMultiple";
    private static final String KEY_IS_SHELL = ".isShell";
    private static final String KEY_HANDLED_EVENTS = ".handledEvents";
    private static final String KEY_VIEW_CLASS = ".viewClass";
    private static final String KEY_VIEW_INTERFACE = ".viewInterface";
    private static final String KEY_VIEW_CREATION_METHOD = ".viewCreationMethod";
    private Map<String, PresenterData> presenterDatas = new HashMap<String, PresenterData>();

    public PresenterMetaModel() {
    }

    public PresenterMetaModel(Properties properties) {
        Arrays.stream(properties.getProperty(KEY_PRESENTERS).split("\\s*,\\s*")).forEach(s -> {
            String handlerClassName = properties.getProperty(s + KEY_PRESENTER);
            this.presenterDatas.put(handlerClassName, new PresenterData(handlerClassName, properties.getProperty(s + KEY_IS_MULTIPLE), properties.getProperty(s + KEY_IS_SHELL), properties.getProperty(s + KEY_VIEW_CLASS), properties.getProperty(s + KEY_VIEW_INTERFACE), properties.getProperty(s + KEY_VIEW_CREATION_METHOD), properties.getProperty(s + KEY_HANDLED_EVENTS).split("\\s*,\\s*")));
        });
    }

    public void add(String presenter, String isMultiple, String isShell, String viewClass, String viewInterface, String viewCreationMethod, String eventHandlers) {
        this.presenterDatas.put(presenter, new PresenterData(presenter, isMultiple, isShell, viewClass, viewInterface, viewCreationMethod, eventHandlers));
    }

    public void add(String presenter, String isMultiple, String isShell, String viewClass, String viewInterface, String viewCreationMethod, String ... eventHandlers) {
        this.presenterDatas.put(presenter, new PresenterData(presenter, isMultiple, isShell, viewClass, viewInterface, viewCreationMethod, eventHandlers));
    }

    public Set<String> getPresenterKeys() {
        return this.presenterDatas.keySet();
    }

    public PresenterData getPresenterData(String key) {
        return this.presenterDatas.get(key);
    }

    public Collection<PresenterData> getPresenterDatas() {
        return this.presenterDatas.values();
    }

    @Override
    public Properties createPropertes() {
        Properties props = new Properties();
        props.setProperty(KEY_PRESENTERS, String.join((CharSequence)",", this.presenterDatas.keySet()));
        this.presenterDatas.values().stream().forEach(data -> {
            props.setProperty(data.getPresenter().getClassName() + KEY_PRESENTER, data.getPresenter().getClassName());
            props.setProperty(data.getPresenter().getClassName() + KEY_IS_MULTIPLE, data.getIsMultiple());
            props.setProperty(data.getPresenter().getClassName() + KEY_IS_SHELL, data.getIsShell());
            props.setProperty(data.getPresenter().getClassName() + KEY_VIEW_CLASS, data.getViewClass().getClassName());
            props.setProperty(data.getPresenter().getClassName() + KEY_VIEW_INTERFACE, data.getViewInterface().getClassName());
            props.setProperty(data.getPresenter().getClassName() + KEY_VIEW_CREATION_METHOD, data.getViewCreationMethod());
            props.setProperty(data.getPresenter().getClassName() + KEY_HANDLED_EVENTS, String.join((CharSequence)",", ((PresenterData)data).handledEvents));
        });
        return props;
    }

    public boolean isPresenter(String handlerClassName) {
        return this.presenterDatas.get(handlerClassName) != null;
    }

    public class PresenterData {
        private ClassNameModel presenter;
        private String isMultiple;
        private ClassNameModel viewClass;
        private ClassNameModel viewInterface;
        private String viewCreationMethod;
        private String isShell;
        private List<String> handledEvents = new ArrayList<String>();

        public PresenterData(String presenter, String isMultiple, String isShell, String viewClass, String viewInterface, String viewCreationMethod, String eventHandlers) {
            this(presenter, isMultiple, isShell, viewClass, viewInterface, viewCreationMethod, eventHandlers.split("\\s*,\\s*"));
        }

        public PresenterData(String presenter, String isMultiple, String isShell, String viewClass, String viewInterface, String viewCreationMethod, String ... eventHandlers) {
            this.presenter = new ClassNameModel(presenter);
            this.isMultiple = isMultiple;
            this.isShell = isShell;
            this.viewClass = new ClassNameModel(viewClass);
            this.viewInterface = new ClassNameModel(viewInterface);
            this.viewCreationMethod = viewCreationMethod;
            this.handledEvents.addAll(Arrays.asList(eventHandlers));
        }

        public ClassNameModel getPresenter() {
            return this.presenter;
        }

        public List<String> getHandledEvents() {
            return this.handledEvents;
        }

        public boolean handlesEvents(String eventName) {
            return this.handledEvents.contains(eventName);
        }

        public boolean isMultiple() {
            return "true".equals(this.isMultiple);
        }

        public String getIsMultiple() {
            return this.isMultiple;
        }

        public ClassNameModel getViewClass() {
            return this.viewClass;
        }

        public ClassNameModel getViewInterface() {
            return this.viewInterface;
        }

        public String getViewCreationMethod() {
            return this.viewCreationMethod;
        }

        public boolean isShell() {
            return "true".equals(this.isShell);
        }

        public String getIsShell() {
            return this.isShell;
        }
    }
}

