/*
 * Decompiled with CFR 0.152.
 */
package com.github.mvp4g.mvp4g2.processor.model;

import com.github.mvp4g.mvp4g2.processor.model.intern.ClassNameModel;
import com.github.mvp4g.mvp4g2.processor.model.intern.IsMetaModel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Properties;
import java.util.stream.Collectors;

public class EventMetaModel
implements IsMetaModel {
    private static final String KEY_EVENT_EVENT_INTERNAL_NAME = "eventInternalName";
    private static final String KEY_EVENT_NAME = "eventName";
    private static final String KEY_HISTORY_EVENT_NAME = "historyEventName";
    private static final String KEY_HISTORY_CONVERTER = "historyConverter";
    private static final String KEY_BINDINGS = "bindings";
    private static final String KEY_HANDLERS = "handlers";
    private static final String KEY_NAVIGATION_EVENT = "navigationEvent";
    private static final String KEY_PASSIVE = "passive";
    private static final String KEY_ACTIVATE_HANDELRS = "activateHandlers";
    private static final String KEY_DEACTIVATE_HANDELRS = "deactivateHandlers";
    private static final String KEY_PARAMETERS = "parameters";
    private static final String KEY_START_EVENT = "startEvent";
    private static final String KEY_INIT_HISTORY = "initHistory";
    private static final String KEY_NOT_FOUND_HISTORY = "notFoundHistory";
    private String eventInternalName;
    private String eventName;
    private String startEvent;
    private String initHistory;
    private String notFoundHistory;
    private String historyEventName;
    private ClassNameModel historyConverter;
    private List<ClassNameModel> bindings;
    private List<ClassNameModel> handlers;
    private String navigationEvent;
    private String passive;
    private List<ClassNameModel> activateHandlers;
    private List<ClassNameModel> deactivateHandlers;
    private String parameters;
    private List<ParameterMetaData> parameterMetaDataList = new ArrayList<ParameterMetaData>();

    public EventMetaModel() {
    }

    public EventMetaModel(Properties properties) {
        this.eventInternalName = properties.getProperty(KEY_EVENT_EVENT_INTERNAL_NAME);
        this.eventName = properties.getProperty(KEY_EVENT_NAME);
        this.startEvent = properties.getProperty(KEY_START_EVENT);
        this.initHistory = properties.getProperty(KEY_INIT_HISTORY);
        this.notFoundHistory = properties.getProperty(KEY_NOT_FOUND_HISTORY);
        this.historyEventName = properties.getProperty(KEY_HISTORY_EVENT_NAME);
        this.historyConverter = new ClassNameModel(properties.getProperty(KEY_HISTORY_CONVERTER));
        String value = properties.getProperty(KEY_BINDINGS);
        this.bindings = this.isEmptyOrNull(value) ? new ArrayList<ClassNameModel>() : Arrays.stream(properties.getProperty(KEY_BINDINGS).split("\\s*,\\s*")).map(s -> new ClassNameModel((String)s)).collect(Collectors.toList());
        this.handlers = this.isEmptyOrNull(properties.getProperty(KEY_HANDLERS)) ? new ArrayList<ClassNameModel>() : Arrays.stream(properties.getProperty(KEY_HANDLERS).split("\\s*,\\s*")).map(s -> new ClassNameModel((String)s)).collect(Collectors.toList());
        this.navigationEvent = properties.getProperty(KEY_NAVIGATION_EVENT);
        this.passive = properties.getProperty(KEY_PASSIVE);
        this.activateHandlers = this.isEmptyOrNull(properties.getProperty(KEY_ACTIVATE_HANDELRS)) ? new ArrayList<ClassNameModel>() : Arrays.stream(properties.getProperty(KEY_ACTIVATE_HANDELRS).split("\\s*,\\s*")).map(s -> new ClassNameModel((String)s)).collect(Collectors.toList());
        this.deactivateHandlers = this.isEmptyOrNull(properties.getProperty(KEY_DEACTIVATE_HANDELRS)) ? new ArrayList<ClassNameModel>() : Arrays.stream(properties.getProperty(KEY_DEACTIVATE_HANDELRS).split("\\s*,\\s*")).map(s -> new ClassNameModel((String)s)).collect(Collectors.toList());
        if (this.isEmptyOrNull(properties.getProperty(KEY_PARAMETERS))) {
            this.parameters = "";
            this.parameterMetaDataList = new ArrayList<ParameterMetaData>();
        } else {
            this.parameters = properties.getProperty(KEY_PARAMETERS);
            if (properties.getProperty(KEY_PARAMETERS).trim().length() > 0) {
                this.parameterMetaDataList = Arrays.stream(properties.getProperty(KEY_PARAMETERS).split("\\s*,\\s*")).map(s -> {
                    String[] values = s.split("_tTt_");
                    return new ParameterMetaData(values[0], values[1]);
                }).collect(Collectors.toList());
            }
        }
    }

    private boolean isEmptyOrNull(String value) {
        return value == null || value.isEmpty();
    }

    public void addParameter(String name, String type) {
        this.parameterMetaDataList.add(new ParameterMetaData(name, type));
    }

    public String getEventInternalName() {
        return this.eventInternalName;
    }

    public void setEventInternalName(String eventInternalName) {
        this.eventInternalName = eventInternalName;
    }

    public String getEventName() {
        return this.eventName;
    }

    public void setEventName(String eventName) {
        this.eventName = eventName;
    }

    public String getHistoryEventName() {
        return this.historyEventName;
    }

    public void setHistoryEventName(String historyEventName) {
        this.historyEventName = historyEventName;
    }

    public ClassNameModel getHistoryConverter() {
        return this.historyConverter;
    }

    public void setHistoryConverter(String historyConverter) {
        this.historyConverter = new ClassNameModel(historyConverter);
    }

    public List<ClassNameModel> getBindings() {
        return this.bindings;
    }

    public void setBindings(List<String> bindings) {
        this.bindings = Objects.isNull(bindings) ? new ArrayList<ClassNameModel>() : bindings.stream().map(s -> new ClassNameModel((String)s)).collect(Collectors.toList());
    }

    public List<ClassNameModel> getHandlers() {
        return this.handlers;
    }

    public void setHandlers(List<String> handlers) {
        this.handlers = Objects.isNull(handlers) ? new ArrayList<ClassNameModel>() : handlers.stream().map(s -> new ClassNameModel((String)s)).collect(Collectors.toList());
    }

    public List<ClassNameModel> getActivateHandlers() {
        return this.activateHandlers;
    }

    public void setActivateHandlers(List<String> activateHandlers) {
        this.activateHandlers = Objects.isNull(activateHandlers) ? new ArrayList<ClassNameModel>() : activateHandlers.stream().map(s -> new ClassNameModel((String)s)).collect(Collectors.toList());
    }

    public List<ClassNameModel> getDeactivateHandlers() {
        return this.deactivateHandlers;
    }

    public void setDeactivateHandlers(List<String> deactivateHandlers) {
        this.deactivateHandlers = Objects.isNull(deactivateHandlers) ? new ArrayList<ClassNameModel>() : deactivateHandlers.stream().map(s -> new ClassNameModel((String)s)).collect(Collectors.toList());
    }

    public String getNavigationEvent() {
        return this.navigationEvent;
    }

    public boolean isNavigationEvent() {
        return "true".equals(this.navigationEvent);
    }

    public void setNavigationEvent(String navigationEvent) {
        this.navigationEvent = navigationEvent;
    }

    public String getPassive() {
        return this.passive;
    }

    public boolean isPassive() {
        return "true".equals(this.passive);
    }

    public void setPassive(String passive) {
        this.passive = passive;
    }

    public List<ParameterMetaData> getParameterMetaDataList() {
        return this.parameterMetaDataList;
    }

    public String getStartEvent() {
        return this.startEvent;
    }

    public boolean isStartEvent() {
        return "true".equals(this.startEvent);
    }

    public void setStartEvent(String startEvent) {
        this.startEvent = startEvent;
    }

    public String getInitHistory() {
        return this.initHistory;
    }

    public boolean isInitHistory() {
        return "true".equals(this.initHistory);
    }

    public void setInitHistory(String initHistory) {
        this.initHistory = initHistory;
    }

    public String getNotFoundHistory() {
        return this.notFoundHistory;
    }

    public boolean isNotFoundHistory() {
        return "true".equals(this.notFoundHistory);
    }

    public void setNotFoundHistory(String notFoundHistory) {
        this.notFoundHistory = notFoundHistory;
    }

    @Override
    public Properties createPropertes() {
        Properties properties = new Properties();
        properties.setProperty(KEY_EVENT_EVENT_INTERNAL_NAME, this.eventInternalName);
        properties.setProperty(KEY_EVENT_NAME, this.eventName);
        properties.setProperty(KEY_HISTORY_EVENT_NAME, this.historyEventName);
        properties.setProperty(KEY_HISTORY_CONVERTER, this.historyConverter.getClassName());
        properties.setProperty(KEY_START_EVENT, this.startEvent);
        properties.setProperty(KEY_INIT_HISTORY, this.initHistory);
        properties.setProperty(KEY_NOT_FOUND_HISTORY, this.notFoundHistory);
        properties.setProperty(KEY_BINDINGS, this.bindings.stream().map(c -> c.getClassName()).collect(Collectors.joining(",")));
        properties.setProperty(KEY_HANDLERS, this.handlers.stream().map(c -> c.getClassName()).collect(Collectors.joining(",")));
        properties.setProperty(KEY_NAVIGATION_EVENT, this.navigationEvent);
        properties.setProperty(KEY_PASSIVE, this.passive);
        properties.setProperty(KEY_ACTIVATE_HANDELRS, this.activateHandlers.stream().map(c -> c.getClassName()).collect(Collectors.joining(",")));
        properties.setProperty(KEY_DEACTIVATE_HANDELRS, this.deactivateHandlers.stream().map(c -> c.getClassName()).collect(Collectors.joining(",")));
        if (this.parameterMetaDataList != null && this.parameterMetaDataList.size() > 0) {
            properties.setProperty(KEY_PARAMETERS, this.parameterMetaDataList.stream().map(p -> p.getName() + "_tTt_" + p.getType().getClassName()).collect(Collectors.joining(",")));
        } else {
            properties.setProperty(KEY_PARAMETERS, "");
        }
        return properties;
    }

    public class ParameterMetaData {
        private String name;
        private ClassNameModel type;

        public ParameterMetaData(String name, String type) {
            this.name = name;
            this.type = new ClassNameModel(type);
        }

        public String getName() {
            return this.name;
        }

        public ClassNameModel getType() {
            return this.type;
        }
    }
}

