/*
 * Decompiled with CFR 0.152.
 */
package com.github.mvp4g.mvp4g2.processor.model;

import com.github.mvp4g.mvp4g2.processor.model.intern.ClassNameModel;
import com.github.mvp4g.mvp4g2.processor.model.intern.IsMetaModel;
import java.util.Properties;

public class ApplicationMetaModel
implements IsMetaModel {
    private static final String KEY_APPLICATION = "application";
    private static final String KEY_EVENTBUS = "eventBus";
    private static final String KEY_LOADER = "loader";
    private static final String KEY_HISTORY_ON_START = "historyOnStart";
    private static final String KEY_ENCODE_TOKEN = "encodeToken";
    private ClassNameModel application;
    private ClassNameModel eventBus;
    private ClassNameModel loader;
    private String historyOnStart;
    private String encodeToken;

    public ApplicationMetaModel(Properties properties) {
        this.application = new ClassNameModel(properties.getProperty(KEY_APPLICATION));
        this.historyOnStart = properties.getProperty(KEY_HISTORY_ON_START);
        this.encodeToken = properties.getProperty(KEY_ENCODE_TOKEN);
        this.eventBus = new ClassNameModel(properties.getProperty(KEY_EVENTBUS));
        this.loader = new ClassNameModel(properties.getProperty(KEY_LOADER));
    }

    public ApplicationMetaModel(String application, String eventBus, String loader, String historyOnStart, String encodeToken) {
        this.application = new ClassNameModel(application);
        this.eventBus = new ClassNameModel(eventBus);
        this.loader = new ClassNameModel(loader);
        this.historyOnStart = historyOnStart;
        this.encodeToken = encodeToken;
    }

    public ClassNameModel getApplication() {
        return this.application;
    }

    public ClassNameModel getEventBus() {
        return this.eventBus;
    }

    public ClassNameModel getLoader() {
        return this.loader;
    }

    public String getHistoryOnStart() {
        return this.historyOnStart;
    }

    public boolean isHistoryOnStart() {
        return "true".equals(this.historyOnStart);
    }

    public String getEncodeToken() {
        return this.encodeToken;
    }

    public boolean isEncodeToken() {
        return "true".equals(this.encodeToken);
    }

    @Override
    public Properties createPropertes() {
        Properties properties = new Properties();
        properties.setProperty(KEY_APPLICATION, this.application.getClassName());
        properties.setProperty(KEY_EVENTBUS, this.eventBus.getClassName());
        properties.setProperty(KEY_LOADER, this.loader.getClassName());
        properties.setProperty(KEY_HISTORY_ON_START, this.historyOnStart);
        properties.setProperty(KEY_ENCODE_TOKEN, this.encodeToken);
        return properties;
    }
}

