/*
 * Decompiled with CFR 0.152.
 */
package com.github.mvp4g.mvp4g2.processor.generator;

import com.github.mvp4g.mvp4g2.core.internal.ui.AbstractHandlerMetaData;
import com.github.mvp4g.mvp4g2.core.internal.ui.PresenterMetaData;
import com.github.mvp4g.mvp4g2.core.ui.annotation.Presenter;
import com.github.mvp4g.mvp4g2.processor.ProcessorException;
import com.github.mvp4g.mvp4g2.processor.ProcessorUtils;
import com.github.mvp4g.mvp4g2.processor.model.PresenterMetaModel;
import com.github.mvp4g.mvp4g2.processor.model.intern.ClassNameModel;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.io.IOException;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Modifier;

public class PresenterGenerator {
    private ProcessorUtils processorUtils;
    private ProcessingEnvironment processingEnvironment;

    private PresenterGenerator(Builder builder) {
        this.processingEnvironment = builder.processingEnvironment;
        this.setUp();
    }

    private void setUp() {
        this.processorUtils = ProcessorUtils.builder().processingEnvironment(this.processingEnvironment).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public void generate(PresenterMetaModel metaModel) throws ProcessorException {
        ClassName presenterrMetaDataClassName = ClassName.get(PresenterMetaData.class);
        ClassName presenterMetaDataKindClassName = ClassName.get(AbstractHandlerMetaData.Kind.class);
        ClassName presenterViewCreationMethodClassName = ClassName.get(Presenter.VIEW_CREATION_METHOD.class);
        for (String presenter : metaModel.getPresenterKeys()) {
            if (!this.processorUtils.doesExist(new ClassNameModel(presenter))) continue;
            PresenterMetaModel.PresenterData data = metaModel.getPresenterData(presenter);
            String className = this.processorUtils.createFullClassName(data.getPresenter().getPackage(), data.getPresenter().getSimpleName() + "MetaData");
            TypeSpec.Builder typeSpec = TypeSpec.classBuilder((String)this.processorUtils.setFirstCharacterToUpperCase(className)).superclass((TypeName)ParameterizedTypeName.get((ClassName)presenterrMetaDataClassName, (TypeName[])new TypeName[]{data.getPresenter().getTypeName(), data.getViewInterface().getTypeName()})).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL});
            MethodSpec.Builder constructor = MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC}).addStatement("super($S, $T.PRESENTER, $N, $T.$L)", new Object[]{data.getPresenter().getClassName(), presenterMetaDataKindClassName, data.getIsMultiple(), presenterViewCreationMethodClassName, data.getViewCreationMethod()});
            if (!metaModel.getPresenterData(presenter).isMultiple()) {
                constructor.addStatement("super.presenter = new $T()", new Object[]{data.getPresenter().getTypeName()});
                if (Presenter.VIEW_CREATION_METHOD.FRAMEWORK.toString().equals(data.getViewCreationMethod())) {
                    constructor.addStatement("super.view = ($T) new $T()", new Object[]{data.getViewInterface().getTypeName(), data.getViewClass().getTypeName()});
                } else {
                    constructor.addStatement("super.view = presenter.createView()", new Object[0]);
                }
            }
            typeSpec.addMethod(constructor.build());
            JavaFile javaFile = JavaFile.builder((String)data.getPresenter().getPackage(), (TypeSpec)typeSpec.build()).build();
            try {
                javaFile.writeTo(this.processingEnvironment.getFiler());
            }
            catch (IOException e) {
                throw new ProcessorException("Unable to write generated file: >>" + data.getPresenter().getSimpleName() + "MetaData" + "<< -> exception: " + e.getMessage());
            }
        }
    }

    public static class Builder {
        ProcessingEnvironment processingEnvironment;

        public Builder processingEnvironment(ProcessingEnvironment processingEnvironment) {
            this.processingEnvironment = processingEnvironment;
            return this;
        }

        public PresenterGenerator build() {
            return new PresenterGenerator(this);
        }
    }
}

