/*
 * Decompiled with CFR 0.152.
 */
package com.github.mvp4g.mvp4g2.processor.generator;

import com.github.mvp4g.mvp4g2.core.eventbus.annotation.Event;
import com.github.mvp4g.mvp4g2.core.internal.eventbus.EventMetaData;
import com.github.mvp4g.mvp4g2.processor.ProcessorException;
import com.github.mvp4g.mvp4g2.processor.ProcessorUtils;
import com.github.mvp4g.mvp4g2.processor.model.EventBusMetaModel;
import com.github.mvp4g.mvp4g2.processor.model.EventMetaModel;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.io.IOException;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Modifier;

public class EventMetaDataGenerator {
    private ProcessorUtils processorUtils;
    private ProcessingEnvironment processingEnvironment;
    private EventBusMetaModel eventBusMetaModel;

    private EventMetaDataGenerator() {
    }

    private EventMetaDataGenerator(Builder builder) {
        this.processingEnvironment = builder.processingEnvironment;
        this.eventBusMetaModel = builder.eventBusMetaModel;
        this.processorUtils = ProcessorUtils.builder().processingEnvironment(this.processingEnvironment).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public void generate() throws ProcessorException {
        for (EventMetaModel eventMetaModel : this.eventBusMetaModel.getEventMetaModels()) {
            TypeSpec.Builder typeSpec = TypeSpec.classBuilder((String)this.createEventMetaDataClassName(this.eventBusMetaModel.getEventBus().getClassName(), eventMetaModel.getEventName())).superclass((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(EventMetaData.class), (TypeName[])new TypeName[]{this.eventBusMetaModel.getEventBus().getTypeName()})).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL});
            MethodSpec.Builder constructor = MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC}).addCode("super($S, $S, ", new Object[]{eventMetaModel.getEventInternalName(), eventMetaModel.getEventName()});
            if ("#%!|&*+!##%$".equals(eventMetaModel.getHistoryEventName())) {
                constructor.addCode("null, ", new Object[0]);
            } else {
                constructor.addCode("$S, ", new Object[]{eventMetaModel.getHistoryEventName()});
            }
            if (Event.NoHistoryConverter.class.getCanonicalName().equals(eventMetaModel.getHistoryConverter().getClassName())) {
                constructor.addCode("null, null, ", new Object[0]);
            } else {
                constructor.addCode("new $L(), new $T(), ", new Object[]{eventMetaModel.getHistoryConverter().getPackage() + "." + this.processorUtils.createHistoryMetaDataClassName(eventMetaModel.getHistoryConverter().getClassName()), eventMetaModel.getHistoryConverter().getTypeName()});
            }
            constructor.addCode("$L, $L);\n", new Object[]{eventMetaModel.getPassive(), eventMetaModel.getNavigationEvent()});
            eventMetaModel.getBindings().forEach(s -> constructor.addStatement("super.addBindHandler($S)", new Object[]{s.getClassName()}));
            eventMetaModel.getHandlers().forEach(s -> constructor.addStatement("super.addHandler($S)", new Object[]{s.getClassName()}));
            eventMetaModel.getActivateHandlers().forEach(s -> constructor.addStatement("super.addActivateHandler($S)", new Object[]{s.getClassName()}));
            eventMetaModel.getDeactivateHandlers().forEach(s -> constructor.addStatement("super.addDeactivateHandler($S)", new Object[]{s.getClassName()}));
            typeSpec.addMethod(constructor.build());
            JavaFile javaFile = JavaFile.builder((String)this.eventBusMetaModel.getEventBus().getPackage(), (TypeSpec)typeSpec.build()).build();
            try {
                javaFile.writeTo(this.processingEnvironment.getFiler());
            }
            catch (IOException e) {
                throw new ProcessorException("Unable to write generated file: >>" + this.eventBusMetaModel.getEventBus().getPackage() + "." + this.createEventMetaDataClassName(this.eventBusMetaModel.getEventBus().getClassName(), eventMetaModel.getEventName()) + "<< -> exception: " + e.getMessage());
            }
        }
    }

    private String createEventMetaDataClassName(String eventBusClassName, String eventName) {
        return this.processorUtils.setFirstCharacterToUpperCase(this.createEventMetaDataVariableName(eventBusClassName, eventName));
    }

    private String createEventMetaDataVariableName(String eventBusClassName, String eventName) {
        return this.processorUtils.createFullClassName(eventBusClassName + "_" + eventName);
    }

    public static final class Builder {
        ProcessingEnvironment processingEnvironment;
        EventBusMetaModel eventBusMetaModel;

        public Builder processingEnvironment(ProcessingEnvironment processingEnvirement) {
            this.processingEnvironment = processingEnvirement;
            return this;
        }

        public Builder eventBusMetaModel(EventBusMetaModel eventBusMetaModel) {
            this.eventBusMetaModel = eventBusMetaModel;
            return this;
        }

        public EventMetaDataGenerator build() {
            return new EventMetaDataGenerator(this);
        }
    }
}

