/*
 * Decompiled with CFR 0.152.
 */
package br.com.fluentvalidator.rule;

import br.com.fluentvalidator.context.ProcessorContext;
import br.com.fluentvalidator.rule.Rule;
import br.com.fluentvalidator.rule.RuleProcessorDefault;
import br.com.fluentvalidator.rule.RuleProcessorFailFast;
import java.util.Collection;
import java.util.stream.Collectors;

public interface RuleProcessorStrategy {
    default public <E> boolean process(Object obj, E value, Rule<E> rule) {
        return Boolean.FALSE.equals(rule.support(value)) || rule.apply(obj, value);
    }

    default public <E> boolean process(E value, Rule<E> rule) {
        return Boolean.FALSE.equals(rule.support(value)) || rule.apply(value);
    }

    default public <E> boolean process(Object obj, Collection<E> values, Rule<E> rule) {
        ProcessorContext.get().create();
        boolean allMatch = values.stream().map(value -> {
            ProcessorContext.get().inc();
            return this.process(obj, value, rule);
        }).collect(Collectors.toList()).stream().allMatch(result -> result);
        ProcessorContext.get().remove();
        return allMatch;
    }

    default public <E> boolean process(Collection<E> values, Rule<E> rule) {
        ProcessorContext.get().create();
        boolean allMatch = values.stream().map(value -> {
            ProcessorContext.get().inc();
            return this.process(value, rule);
        }).collect(Collectors.toList()).stream().allMatch(result -> result);
        ProcessorContext.get().remove();
        return allMatch;
    }

    default public <E> boolean process(Object obj, E value, Collection<Rule<E>> rules) {
        return rules.stream().map(rule -> this.process(obj, value, (Rule)rule)).collect(Collectors.toList()).stream().allMatch(result -> result);
    }

    default public <E> boolean process(E value, Collection<Rule<E>> rules) {
        return rules.stream().map(rule -> this.process(value, (Rule)rule)).collect(Collectors.toList()).stream().allMatch(result -> result);
    }

    public static RuleProcessorStrategy getFailFast() {
        return new RuleProcessorFailFast();
    }

    public static RuleProcessorStrategy getDefault() {
        return new RuleProcessorDefault();
    }
}

