/*
 * Decompiled with CFR 0.152.
 */
package br.com.fluentvalidator.predicate;

import br.com.fluentvalidator.predicate.LogicalPredicate;
import br.com.fluentvalidator.predicate.PredicateBuilder;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;

public final class ObjectPredicate {
    public static <T> Predicate<T> equalObject(Function<T, Object> source, Function<T, Object> target) {
        return PredicateBuilder.from(LogicalPredicate.not(ObjectPredicate.nullValue())).and(LogicalPredicate.not(ObjectPredicate.nullValue(source))).and(LogicalPredicate.not(ObjectPredicate.nullValue(target))).and(obj -> Objects.equals(source.apply(obj), target.apply(obj)));
    }

    public static <T> Predicate<T> equalObject(Function<T, Object> source, Object target) {
        return PredicateBuilder.from(LogicalPredicate.not(ObjectPredicate.nullValue())).and(LogicalPredicate.not(ObjectPredicate.nullValue(source))).and(LogicalPredicate.not(ObjectPredicate.nullValue(obj -> target))).and(obj -> Objects.equals(source.apply(obj), target));
    }

    public static <T> Predicate<T> equalObject(Object target) {
        return PredicateBuilder.from(LogicalPredicate.not(ObjectPredicate.nullValue())).and(obj -> Objects.equals(obj, target));
    }

    public static <T> Predicate<T> instanceOf(Class<?> clazz) {
        return PredicateBuilder.from(LogicalPredicate.not(ObjectPredicate.nullValue())).and(LogicalPredicate.not(ObjectPredicate.nullValue(fn -> clazz))).and(obj -> clazz.isInstance(obj));
    }

    public static <T> Predicate<T> instanceOf(Function<T, ?> source, Class<?> clazz) {
        return PredicateBuilder.from(LogicalPredicate.not(ObjectPredicate.nullValue())).and(LogicalPredicate.not(ObjectPredicate.nullValue(source))).and(obj -> ObjectPredicate.instanceOf(clazz).test(source.apply(obj)));
    }

    public static <T> Predicate<T> nullValue() {
        return PredicateBuilder.from(Objects::isNull);
    }

    public static <T> Predicate<T> nullValue(Function<T, ?> source) {
        return PredicateBuilder.from(ObjectPredicate.nullValue()).or(obj -> Objects.isNull(source)).or(obj -> Objects.isNull(source.apply(obj)));
    }

    private ObjectPredicate() {
    }
}

