/*
 * Decompiled with CFR 0.152.
 */
package br.com.fluentvalidator.function;

import java.util.Objects;
import java.util.function.Function;

public final class FunctionBuilder<I, O>
implements Function<I, O> {
    private final Function<I, O> function;

    private FunctionBuilder(Function<I, O> function) {
        this.function = function;
    }

    public static <I, O> Function<I, O> of(Function<I, O> function) {
        return new FunctionBuilder<I, O>(function);
    }

    @Override
    public O apply(I value) {
        return Objects.nonNull(value) ? (O)this.function.apply(value) : null;
    }

    @Override
    public <V> Function<I, V> andThen(Function<? super O, ? extends V> after) {
        return FunctionBuilder.of(i -> FunctionBuilder.of(after).apply(this.apply((I)i)));
    }

    @Override
    public <V> Function<V, O> compose(Function<? super V, ? extends I> before) {
        return FunctionBuilder.of(v -> this.apply((I)FunctionBuilder.of(before).apply(v)));
    }
}

