/*
 * Decompiled with CFR 0.152.
 */
package br.com.fluentvalidator.exception;

import br.com.fluentvalidator.context.ValidationContext;
import br.com.fluentvalidator.context.ValidationResult;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;

public abstract class ValidationException
extends RuntimeException {
    private static final long serialVersionUID = 2274879814700248645L;
    private final transient ValidationResult validationResult;

    protected ValidationException(ValidationResult validationResult) {
        super(validationResult.toString());
        this.validationResult = validationResult;
    }

    public ValidationResult getValidationResult() {
        return this.validationResult;
    }

    public static <T extends ValidationException> RuntimeException create(Class<T> exceptionClass) {
        return ValidationException.create(exceptionClass, ValidationContext.get().getValidationResult());
    }

    public static <T extends ValidationException> RuntimeException create(Class<T> exceptionClass, ValidationResult validationResult) {
        try {
            Constructor<T> ctor = exceptionClass.getConstructor(ValidationResult.class);
            return (RuntimeException)ctor.newInstance(validationResult);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            return new RuntimeException("Constructor in class not found (ValidationResult validationResult)", e);
        }
    }
}

