/*
 * Decompiled with CFR 0.152.
 */
package br.com.fluentvalidator.context;

import java.util.Deque;
import java.util.Objects;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.atomic.AtomicInteger;

public final class ProcessorContext {
    private static final ThreadLocal<Context> threadLocal = new ThreadLocal();

    private ProcessorContext() {
    }

    public static Context get() {
        if (Objects.isNull(threadLocal.get())) {
            threadLocal.set(new Context());
        }
        return threadLocal.get();
    }

    public static void remove() {
        threadLocal.remove();
    }

    public static final class Context {
        private final Deque<AtomicInteger> stackCounter = new ConcurrentLinkedDeque<AtomicInteger>();

        public void create() {
            this.stackCounter.push(new AtomicInteger(0));
        }

        public void remove() {
            if (!this.stackCounter.isEmpty()) {
                this.stackCounter.pop();
            }
        }

        public void inc() {
            if (!this.stackCounter.isEmpty()) {
                this.stackCounter.peek().incrementAndGet();
            }
        }

        public Integer get() {
            return this.stackCounter.isEmpty() ? 0 : this.stackCounter.peek().get();
        }
    }
}

