/*
 * Decompiled with CFR 0.152.
 */
package com.murgupluoglu.flagkit;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.drawable.Drawable;
import androidx.core.content.ContextCompat;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u0018\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u0010\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\tH\u0002J\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\t0\u000f\u00a8\u0006\u0010"}, d2={"Lcom/murgupluoglu/flagkit/FlagKit;", "", "<init>", "()V", "getResId", "", "context", "Landroid/content/Context;", "flagName", "", "getDrawable", "Landroid/graphics/drawable/Drawable;", "fixResId", "resId", "getAllAvailableCodes", "", "flagkit_release"})
public final class FlagKit {
    @NotNull
    public static final FlagKit INSTANCE = new FlagKit();

    private FlagKit() {
    }

    public final int getResId(@NotNull Context context, @NotNull String flagName) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)flagName, (String)"flagName");
        return context.getResources().getIdentifier(this.fixResId(flagName), "drawable", context.getPackageName());
    }

    @Nullable
    public final Drawable getDrawable(@NotNull Context context, @NotNull String flagName) {
        Drawable drawable;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)flagName, (String)"flagName");
        int resourceId = context.getResources().getIdentifier(this.fixResId(flagName), "drawable", context.getPackageName());
        try {
            Drawable drawable2 = ContextCompat.getDrawable((Context)context, (int)resourceId);
            Intrinsics.checkNotNull((Object)drawable2);
            drawable = drawable2;
        }
        catch (Resources.NotFoundException e) {
            drawable = null;
        }
        return drawable;
    }

    private final String fixResId(String resId) {
        String string = resId;
        Locale locale = Locale.ENGLISH;
        Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"ENGLISH");
        String string2 = string.toLowerCase(locale);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
        String resourceId = string2;
        if (Intrinsics.areEqual((Object)resourceId, (Object)"do")) {
            resourceId = "do_";
        }
        return resourceId;
    }

    @NotNull
    public final List<String> getAllAvailableCodes() {
        Object[] objectArray = new String[]{"ad", "ae", "af", "ag", "ai", "al", "am", "ao", "ar", "as", "at", "au", "aw", "ax", "az", "ba", "bb", "bd", "be", "bf", "bg", "bh", "bi", "bj", "bl", "bm", "bn", "bo", "br", "bs", "bt", "bv", "bw", "by", "bz", "ca", "cc", "cd", "cf", "cg", "ch", "ci", "ck", "cl", "cm", "cn", "co", "cr", "cu", "cv", "cw", "cx", "cy", "cz", "de", "dj", "dk", "dm", "do", "dz", "ec", "ee", "eg", "er", "es", "et", "eu", "fi", "fj", "fk", "fm", "fo", "fr", "ga", "gb", "gb_eng", "gb_nir", "gb_sct", "gb_wls", "gb_zet", "gd", "ge", "gf", "gg", "gh", "gi", "gl", "gm", "gn", "gp", "gq", "gr", "gs", "gt", "gu", "gw", "gy", "hk", "hm", "hn", "hr", "ht", "hu", "id", "ie", "il", "im", "in", "io", "iq", "ir", "is", "it", "je", "jm", "jo", "jp", "ke", "kg", "kh", "ki", "km", "kn", "kp", "kr", "kw", "ky", "kz", "la", "lb", "lc", "li", "lk", "lr", "ls", "lt", "lu", "lv", "ly", "ma", "mc", "md", "me", "mf", "mg", "mh", "mk", "ml", "mm", "mn", "mo", "mp", "mq", "mr", "ms", "mt", "mu", "mv", "mw", "mx", "my", "mz", "na", "nc", "ne", "nf", "ng", "ni", "nl", "no", "np", "nr", "nu", "nz", "om", "pa", "pe", "pf", "pg", "ph", "pk", "pl", "pm", "pn", "pr", "ps", "pt", "pw", "py", "qa", "re", "ro", "rs", "ru", "rw", "sa", "sb", "sc", "sd", "se", "sg", "sh", "si", "sj", "sk", "sl", "sm", "sn", "so", "sr", "ss", "st", "sv", "sx", "sy", "sz", "tc", "td", "tf", "tg", "th", "tj", "tk", "tl", "tm", "tn", "to", "tr", "tt", "tv", "tw", "tz", "ua", "ug", "um", "us", "us_ca", "uy", "uz", "va", "vc", "ve", "vg", "vi", "vn", "vu", "wf", "ws", "xk", "ye", "yt", "za", "zm", "zw"};
        return CollectionsKt.listOf((Object[])objectArray);
    }
}

