/*
 * Decompiled with CFR 0.152.
 */
package io.ipfs.multihash;

import io.ipfs.multibase.Base16;
import io.ipfs.multibase.Base58;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public class Multihash {
    public static final int MAX_IDENTITY_HASH_LENGTH = 0x100000;
    private final Type type;
    private final byte[] hash;

    public Multihash(Type type, byte[] hash) {
        if (hash.length > 127 && type != Type.id) {
            throw new IllegalStateException("Unsupported hash size: " + hash.length);
        }
        if (hash.length > 0x100000) {
            throw new IllegalStateException("Unsupported hash size: " + hash.length);
        }
        if (hash.length != type.length && type != Type.id) {
            throw new IllegalStateException("Incorrect hash length: " + hash.length + " != " + type.length);
        }
        this.type = type;
        this.hash = hash;
    }

    public Multihash(Multihash toClone) {
        this(toClone.type, toClone.hash);
    }

    public byte[] toBytes() {
        try {
            ByteArrayOutputStream res = new ByteArrayOutputStream();
            Multihash.putUvarint(res, this.type.index);
            Multihash.putUvarint(res, this.hash.length);
            res.write(this.hash);
            return res.toByteArray();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public Type getType() {
        return this.type;
    }

    public byte[] getHash() {
        return Arrays.copyOf(this.hash, this.hash.length);
    }

    public void serialize(OutputStream out) {
        try {
            Multihash.putUvarint(out, this.type.index);
            Multihash.putUvarint(out, this.hash.length);
            out.write(this.hash);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static Multihash deserialize(InputStream din) throws IOException {
        int read;
        int type = (int)Multihash.readVarint(din);
        int len = (int)Multihash.readVarint(din);
        Type t = Type.lookup(type);
        byte[] hash = new byte[len];
        for (int total = 0; total < len; total += read) {
            read = din.read(hash);
            if (read >= 0) continue;
            throw new EOFException();
        }
        return new Multihash(t, hash);
    }

    public static Multihash deserialize(byte[] raw) throws IOException {
        return Multihash.deserialize(new ByteArrayInputStream(raw));
    }

    public String toString() {
        return this.toBase58();
    }

    public boolean equals(Object o) {
        if (!(o instanceof Multihash)) {
            return false;
        }
        return this.type == ((Multihash)o).type && Arrays.equals(this.hash, ((Multihash)o).hash);
    }

    public int hashCode() {
        return Arrays.hashCode(this.hash) ^ this.type.hashCode();
    }

    public String toHex() {
        return Base16.encode((byte[])this.toBytes());
    }

    public String toBase58() {
        return Base58.encode((byte[])this.toBytes());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Multihash fromHex(String hex) {
        if (hex.length() % 2 != 0) {
            throw new IllegalStateException("Odd number of hex digits!");
        }
        try (ByteArrayOutputStream bout = new ByteArrayOutputStream();){
            for (int i = 0; i < hex.length() - 1; i += 2) {
                bout.write(Integer.valueOf(hex.substring(i, i + 2), 16));
            }
            Multihash multihash = Multihash.deserialize(bout.toByteArray());
            return multihash;
        }
        catch (IOException e) {
            throw new IllegalStateException("Unable to handle Multihash conversion to Hex properly");
        }
    }

    public static Multihash fromBase58(String base58) {
        try {
            return Multihash.deserialize(Base58.decode((String)base58));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static long readVarint(InputStream in) throws IOException {
        long x = 0L;
        int s = 0;
        for (int i = 0; i < 10; ++i) {
            int b = in.read();
            if (b < 128) {
                if (i == 9 && b > 1) {
                    throw new IllegalStateException("Overflow reading varint!");
                }
                return x | (long)b << s;
            }
            x |= ((long)b & 0x7FL) << s;
            s += 7;
        }
        throw new IllegalStateException("Varint too long!");
    }

    public static void putUvarint(OutputStream out, long x) throws IOException {
        while (x >= 128L) {
            out.write((byte)(x | 0x80L));
            x >>= 7;
        }
        out.write((byte)x);
    }

    public static enum Type {
        id(0, -1),
        md5(213, 16),
        sha1(17, 20),
        sha2_256(18, 32),
        sha2_512(19, 64),
        dbl_sha2_256(86, 32),
        sha3_224(23, 24),
        sha3_256(22, 32),
        sha3_512(20, 64),
        shake_128(24, 32),
        shake_256(25, 64),
        keccak_224(26, 24),
        keccak_256(27, 32),
        keccak_384(28, 48),
        keccak_512(29, 64),
        murmur3(34, 4),
        blake2b_8(45569, 1),
        blake2b_16(45570, 2),
        blake2b_24(45571, 3),
        blake2b_32(45572, 4),
        blake2b_40(45573, 5),
        blake2b_48(45574, 6),
        blake2b_56(45575, 7),
        blake2b_64(45576, 8),
        blake2b_72(45577, 9),
        blake2b_80(45578, 10),
        blake2b_88(45579, 11),
        blake2b_96(45580, 12),
        blake2b_104(45581, 13),
        blake2b_112(45582, 14),
        blake2b_120(45583, 15),
        blake2b_128(45584, 16),
        blake2b_136(45585, 17),
        blake2b_144(45586, 18),
        blake2b_152(45587, 19),
        blake2b_160(45588, 20),
        blake2b_168(45589, 21),
        blake2b_176(45590, 22),
        blake2b_184(45591, 23),
        blake2b_192(45592, 24),
        blake2b_200(45593, 25),
        blake2b_208(45594, 26),
        blake2b_216(45595, 27),
        blake2b_224(45596, 28),
        blake2b_232(45597, 29),
        blake2b_240(45598, 30),
        blake2b_248(45599, 31),
        blake2b_256(45600, 32),
        blake2b_264(45601, 33),
        blake2b_272(45602, 34),
        blake2b_280(45603, 35),
        blake2b_288(45604, 36),
        blake2b_296(45605, 37),
        blake2b_304(45606, 38),
        blake2b_312(45607, 39),
        blake2b_320(45608, 40),
        blake2b_328(45609, 41),
        blake2b_336(45610, 42),
        blake2b_344(45611, 43),
        blake2b_352(45612, 44),
        blake2b_360(45613, 45),
        blake2b_368(45614, 46),
        blake2b_376(45615, 47),
        blake2b_384(45616, 48),
        blake2b_392(45617, 49),
        blake2b_400(45618, 50),
        blake2b_408(45619, 51),
        blake2b_416(45620, 52),
        blake2b_424(45621, 53),
        blake2b_432(45622, 54),
        blake2b_440(45623, 55),
        blake2b_448(45624, 56),
        blake2b_456(45625, 57),
        blake2b_464(45626, 58),
        blake2b_472(45627, 59),
        blake2b_480(45628, 60),
        blake2b_488(45629, 61),
        blake2b_496(45630, 62),
        blake2b_504(45631, 63),
        blake2b_512(45632, 64),
        blake2s_8(45633, 1),
        blake2s_16(45634, 2),
        blake2s_24(45635, 3),
        blake2s_32(45636, 4),
        blake2s_40(45637, 5),
        blake2s_48(45638, 6),
        blake2s_56(45639, 7),
        blake2s_64(45640, 8),
        blake2s_72(45641, 9),
        blake2s_80(45642, 10),
        blake2s_88(45643, 11),
        blake2s_96(45644, 12),
        blake2s_104(45645, 13),
        blake2s_112(45646, 14),
        blake2s_120(45647, 15),
        blake2s_128(45648, 16),
        blake2s_136(45649, 17),
        blake2s_144(45650, 18),
        blake2s_152(45651, 19),
        blake2s_160(45652, 20),
        blake2s_168(45653, 21),
        blake2s_176(45654, 22),
        blake2s_184(45655, 23),
        blake2s_192(45656, 24),
        blake2s_200(45657, 25),
        blake2s_208(45658, 26),
        blake2s_216(45659, 27),
        blake2s_224(45660, 28),
        blake2s_232(45661, 29),
        blake2s_240(45662, 30),
        blake2s_248(45663, 31),
        blake2s_256(45664, 32);

        public final int index;
        public final int length;
        private static Map<Integer, Type> lookup;

        private Type(int index, int length) {
            this.index = index;
            this.length = length;
        }

        public static Type lookup(int t) {
            Type type = lookup.get(t);
            if (type == null) {
                throw new IllegalStateException("Unknown Multihash type: " + t);
            }
            return type;
        }

        static {
            lookup = new HashMap<Integer, Type>();
            for (Type t : Type.values()) {
                lookup.put(t.index, t);
            }
        }
    }
}

