/*
 * Decompiled with CFR 0.152.
 */
package io.ipfs.multibase;

import java.math.BigInteger;

public class BaseN {
    static String encode(String alphabet, BigInteger base, byte[] input) {
        BigInteger bi = new BigInteger(1, input);
        boolean isZero = bi.equals(BigInteger.ZERO);
        StringBuffer s = new StringBuffer();
        while (bi.compareTo(base) >= 0) {
            BigInteger mod = bi.mod(base);
            s.insert(0, alphabet.charAt(mod.intValue()));
            bi = bi.subtract(mod).divide(base);
        }
        if (!isZero) {
            s.insert(0, alphabet.charAt(bi.intValue()));
        }
        for (byte anInput : input) {
            if (anInput != 0) break;
            s.insert(0, alphabet.charAt(0));
        }
        return s.toString();
    }

    static byte[] decode(String alphabet, BigInteger base, String input) {
        byte[] bytes = BaseN.decodeToBigInteger(alphabet, base, input).toByteArray();
        boolean stripSignByte = bytes.length > 1 && bytes[0] == 0 && bytes[1] < 0;
        int leadingZeros = 0;
        for (int i = 0; i < input.length() && input.charAt(i) == alphabet.charAt(0); ++i) {
            ++leadingZeros;
        }
        if (leadingZeros == input.length()) {
            return new byte[leadingZeros];
        }
        byte[] tmp = new byte[bytes.length - (stripSignByte ? 1 : 0) + leadingZeros];
        System.arraycopy(bytes, stripSignByte ? 1 : 0, tmp, leadingZeros, tmp.length - leadingZeros);
        return tmp;
    }

    private static BigInteger decodeToBigInteger(String alphabet, BigInteger base, String input) {
        BigInteger bi = BigInteger.valueOf(0L);
        for (int i = input.length() - 1; i >= 0; --i) {
            int alphaIndex = alphabet.indexOf(input.charAt(i));
            if (alphaIndex == -1) {
                throw new IllegalStateException("Illegal character " + input.charAt(i) + " at " + i);
            }
            bi = bi.add(BigInteger.valueOf(alphaIndex).multiply(base.pow(input.length() - 1 - i)));
        }
        return bi;
    }
}

