/*
 * Decompiled with CFR 0.152.
 */
package com.mukesh.countrypicker;

import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.design.widget.BottomSheetDialogFragment;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import com.mukesh.countrypicker.R;
import com.mukesh.countrypicker.listeners.BottomSheetInteractionListener;

public class BottomSheetDialogView
extends BottomSheetDialogFragment {
    private static final String BUNDLE_KEY_THEME = "theme";
    private BottomSheetInteractionListener listener;

    public static BottomSheetDialogView newInstance(int theme) {
        BottomSheetDialogView bottomSheetDialogView = new BottomSheetDialogView();
        Bundle args = new Bundle();
        args.putInt(BUNDLE_KEY_THEME, theme);
        bottomSheetDialogView.setArguments(args);
        return bottomSheetDialogView;
    }

    public void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        Bundle args = this.getArguments();
        if (args != null) {
            int theme = args.getInt(BUNDLE_KEY_THEME, 0);
            if (theme == 2) {
                this.setStyle(0, R.style.MaterialDialogStyle);
            } else {
                this.setStyle(0, R.style.DialogStyle);
            }
        } else {
            this.setStyle(0, R.style.DialogStyle);
        }
    }

    @Nullable
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        return inflater.inflate(R.layout.country_picker, container, false);
    }

    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        this.listener.initiateUi(view);
        this.listener.setCustomStyle(view);
        this.listener.setSearchEditText();
        this.listener.setupRecyclerView(view);
    }

    public void setListener(BottomSheetInteractionListener listener) {
        this.listener = listener;
    }
}

