/*
 * Decompiled with CFR 0.152.
 */
package com.mukesh.countrypicker;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.mukesh.countrypicker.Country;
import com.mukesh.countrypicker.OnItemClickListener;
import com.mukesh.countrypicker.R;
import java.util.List;

public class CountriesAdapter
extends RecyclerView.Adapter<ViewHolder> {
    private OnItemClickListener listener;
    private List<Country> countries;
    private Context context;
    private int textColor;

    public CountriesAdapter(Context context, List<Country> countries, OnItemClickListener listener, int textColor) {
        this.context = context;
        this.countries = countries;
        this.listener = listener;
        this.textColor = textColor;
    }

    @NonNull
    public ViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        View v = LayoutInflater.from((Context)parent.getContext()).inflate(R.layout.item_country, parent, false);
        return new ViewHolder(v);
    }

    public void onBindViewHolder(@NonNull ViewHolder holder, int position) {
        final Country country = this.countries.get(position);
        holder.countryNameText.setText((CharSequence)country.getName());
        holder.countryNameText.setTextColor(this.textColor == 0 ? -16777216 : this.textColor);
        country.loadFlagByCode(this.context);
        if (country.getFlag() != -1) {
            holder.countryFlagImageView.setImageResource(country.getFlag());
        }
        holder.rootView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                CountriesAdapter.this.listener.onItemClicked(country);
            }
        });
    }

    public int getItemCount() {
        return this.countries.size();
    }

    class ViewHolder
    extends RecyclerView.ViewHolder {
        private ImageView countryFlagImageView;
        private TextView countryNameText;
        private LinearLayout rootView;

        ViewHolder(View itemView) {
            super(itemView);
            this.countryFlagImageView = (ImageView)itemView.findViewById(R.id.country_flag);
            this.countryNameText = (TextView)itemView.findViewById(R.id.country_title);
            this.rootView = (LinearLayout)itemView.findViewById(R.id.rootView);
        }
    }
}

