/*
 * Decompiled with CFR 0.152.
 */
package com.mukesh.countrypicker.fragments;

import android.annotation.SuppressLint;
import android.content.Context;
import android.os.Bundle;
import android.support.v4.app.DialogFragment;
import android.telephony.TelephonyManager;
import android.text.Editable;
import android.text.TextWatcher;
import android.util.Base64;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.EditText;
import android.widget.ListAdapter;
import android.widget.ListView;
import com.mukesh.countrypicker.R;
import com.mukesh.countrypicker.adapters.CountryListAdapter;
import com.mukesh.countrypicker.interfaces.CountryPickerListener;
import com.mukesh.countrypicker.models.Country;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Currency;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import org.json.JSONArray;
import org.json.JSONObject;

public class CountryPicker
extends DialogFragment
implements Comparator<Country> {
    private EditText searchEditText;
    private ListView countryListView;
    private CountryListAdapter adapter;
    private List<Country> allCountriesList;
    private List<Country> selectedCountriesList;
    private CountryPickerListener listener;
    private Context context;

    public void setListener(CountryPickerListener listener) {
        this.listener = listener;
    }

    public EditText getSearchEditText() {
        return this.searchEditText;
    }

    public ListView getCountryListView() {
        return this.countryListView;
    }

    public static Currency getCurrencyCode(String countryCode) {
        try {
            return Currency.getInstance(new Locale("en", countryCode));
        }
        catch (Exception exception) {
            return null;
        }
    }

    private List<Country> getAllCountries() {
        if (this.allCountriesList == null) {
            try {
                this.allCountriesList = new ArrayList<Country>();
                String allCountriesCode = CountryPicker.readEncodedJsonString();
                JSONArray countryArray = new JSONArray(allCountriesCode);
                for (int i = 0; i < countryArray.length(); ++i) {
                    JSONObject jsonObject = countryArray.getJSONObject(i);
                    String countryDialCode = jsonObject.getString("dial_code");
                    String countryCode = jsonObject.getString("code");
                    Country country = new Country();
                    country.setCode(countryCode);
                    country.setDialCode(countryDialCode);
                    this.allCountriesList.add(country);
                }
                Collections.sort(this.allCountriesList, this);
                this.selectedCountriesList = new ArrayList<Country>();
                this.selectedCountriesList.addAll(this.allCountriesList);
                return this.allCountriesList;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    private static String readEncodedJsonString() throws IOException {
        byte[] data = Base64.decode((String)"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", (int)0);
        return new String(data, "UTF-8");
    }

    public static CountryPicker newInstance(String dialogTitle) {
        CountryPicker picker = new CountryPicker();
        Bundle bundle = new Bundle();
        bundle.putString("dialogTitle", dialogTitle);
        picker.setArguments(bundle);
        return picker;
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        View view = inflater.inflate(R.layout.country_picker, null);
        Bundle args = this.getArguments();
        if (args != null) {
            String dialogTitle = args.getString("dialogTitle");
            this.getDialog().setTitle((CharSequence)dialogTitle);
            int width = this.getResources().getDimensionPixelSize(R.dimen.cp_dialog_width);
            int height = this.getResources().getDimensionPixelSize(R.dimen.cp_dialog_height);
            this.getDialog().getWindow().setLayout(width, height);
        }
        this.getAllCountries();
        this.searchEditText = (EditText)view.findViewById(R.id.country_code_picker_search);
        this.countryListView = (ListView)view.findViewById(R.id.country_code_picker_listview);
        this.adapter = new CountryListAdapter((Context)this.getActivity(), this.selectedCountriesList);
        this.countryListView.setAdapter((ListAdapter)this.adapter);
        this.countryListView.setOnItemClickListener(new AdapterView.OnItemClickListener(){

            public void onItemClick(AdapterView<?> parent, View view, int position, long id2) {
                if (CountryPicker.this.listener != null) {
                    Country country = (Country)CountryPicker.this.selectedCountriesList.get(position);
                    CountryPicker.this.listener.onSelectCountry(country.getName(), country.getCode(), country.getDialCode(), country.getFlag());
                }
            }
        });
        this.searchEditText.addTextChangedListener(new TextWatcher(){

            public void onTextChanged(CharSequence s, int start, int before, int count) {
            }

            public void beforeTextChanged(CharSequence s, int start, int count, int after) {
            }

            public void afterTextChanged(Editable s) {
                CountryPicker.this.search(s.toString());
            }
        });
        return view;
    }

    @SuppressLint(value={"DefaultLocale"})
    private void search(String text) {
        this.selectedCountriesList.clear();
        for (Country country : this.allCountriesList) {
            if (!country.getName().toLowerCase(Locale.ENGLISH).contains(text.toLowerCase())) continue;
            this.selectedCountriesList.add(country);
        }
        this.adapter.notifyDataSetChanged();
    }

    @Override
    public int compare(Country lhs, Country rhs) {
        return lhs.getName().compareTo(rhs.getName());
    }

    public Country getUserCountryInfo(Context context) {
        this.context = context;
        this.getAllCountries();
        TelephonyManager telephonyManager = (TelephonyManager)context.getSystemService("phone");
        if (telephonyManager.getSimState() != 1) {
            return this.getCountry(telephonyManager.getSimCountryIso());
        }
        return this.afghanistan();
    }

    public Country getCountryByLocale(Context context, Locale locale) {
        this.context = context;
        String countryIsoCode = locale.getISO3Country().substring(0, 2).toLowerCase();
        return this.getCountry(countryIsoCode);
    }

    public Country getCountryByName(Context context, String countryName) {
        this.context = context;
        HashMap<String, String> countries = new HashMap<String, String>();
        for (String iso : Locale.getISOCountries()) {
            Locale l = new Locale("", iso);
            countries.put(l.getDisplayCountry(), iso);
        }
        String countryIsoCode = (String)countries.get(countryName);
        if (countryIsoCode != null) {
            return this.getCountry(countryIsoCode);
        }
        return this.afghanistan();
    }

    private Country getCountry(String countryIsoCode) {
        this.getAllCountries();
        for (int i = 0; i < this.allCountriesList.size(); ++i) {
            Country country = this.allCountriesList.get(i);
            if (!country.getCode().equalsIgnoreCase(countryIsoCode)) continue;
            country.setFlag(this.getFlagResId(country.getCode()));
            return country;
        }
        return this.afghanistan();
    }

    private Country afghanistan() {
        Country country = new Country();
        country.setCode("AF");
        country.setDialCode("+93");
        country.setFlag(R.drawable.flag_af);
        return country;
    }

    private int getFlagResId(String drawable2) {
        try {
            return this.context.getResources().getIdentifier("flag_" + drawable2.toLowerCase(Locale.ENGLISH), "drawable", this.context.getPackageName());
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0;
        }
    }
}

