/*
 * Decompiled with CFR 0.152.
 */
package smartdevelop.ir.eram.showcaseviewlib;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.RectF;
import android.graphics.Typeface;
import android.text.Spannable;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.TextView;

class GuideMessageView
extends LinearLayout {
    private static final int RADIUS_SIZE = 5;
    private static final int PADDING_SIZE = 10;
    private static final int BOTTOM_PADDING_SIZE = 5;
    private static final int DEFAULT_TITLE_TEXT_SIZE = 18;
    private static final int DEFAULT_CONTENT_TEXT_SIZE = 14;
    private final Paint mPaint;
    private final RectF mRect;
    private final TextView mTitleTextView;
    private final TextView mContentTextView;
    int[] location = new int[2];

    GuideMessageView(Context context) {
        super(context);
        float density = context.getResources().getDisplayMetrics().density;
        this.setWillNotDraw(false);
        this.setOrientation(1);
        this.setGravity(17);
        this.mRect = new RectF();
        this.mPaint = new Paint(1);
        this.mPaint.setStrokeCap(Paint.Cap.ROUND);
        int padding = (int)(10.0f * density);
        int paddingBottom = (int)(5.0f * density);
        this.mTitleTextView = new TextView(context);
        this.mTitleTextView.setPadding(padding, padding, padding, paddingBottom);
        this.mTitleTextView.setGravity(17);
        this.mTitleTextView.setTextSize(1, 18.0f);
        this.mTitleTextView.setTextColor(-16777216);
        this.addView((View)this.mTitleTextView, (ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-2, -2));
        this.mContentTextView = new TextView(context);
        this.mContentTextView.setTextColor(-16777216);
        this.mContentTextView.setTextSize(1, 14.0f);
        this.mContentTextView.setPadding(padding, paddingBottom, padding, padding);
        this.mContentTextView.setGravity(17);
        this.addView((View)this.mContentTextView, (ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-2, -2));
    }

    public void setTitle(String title) {
        if (title == null) {
            this.removeView((View)this.mTitleTextView);
            return;
        }
        this.mTitleTextView.setText((CharSequence)title);
    }

    public void setContentText(String content) {
        this.mContentTextView.setText((CharSequence)content);
    }

    public void setContentSpan(Spannable content) {
        this.mContentTextView.setText((CharSequence)content);
    }

    public void setContentTypeFace(Typeface typeFace) {
        this.mContentTextView.setTypeface(typeFace);
    }

    public void setTitleTypeFace(Typeface typeFace) {
        this.mTitleTextView.setTypeface(typeFace);
    }

    public void setTitleTextSize(int size) {
        this.mTitleTextView.setTextSize(2, (float)size);
    }

    public void setContentTextSize(int size) {
        this.mContentTextView.setTextSize(2, (float)size);
    }

    public void setColor(int color) {
        this.mPaint.setColor(color);
        this.invalidate();
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        this.getLocationOnScreen(this.location);
        this.mRect.set((float)this.getPaddingLeft(), (float)this.getPaddingTop(), (float)(this.getWidth() - this.getPaddingRight()), (float)(this.getHeight() - this.getPaddingBottom()));
        int density = (int)this.getResources().getDisplayMetrics().density;
        int radiusSize = 5 * density;
        canvas.drawRoundRect(this.mRect, (float)radiusSize, (float)radiusSize, this.mPaint);
    }
}

