/*
 * Decompiled with CFR 0.152.
 */
package smartdevelop.ir.eram.showcaseviewlib;

import android.animation.Animator;
import android.animation.ValueAnimator;
import android.app.Activity;
import android.content.Context;
import android.content.res.Resources;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Point;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Typeface;
import android.graphics.Xfermode;
import android.os.Build;
import android.text.Spannable;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.view.animation.AlphaAnimation;
import android.view.animation.Animation;
import android.widget.FrameLayout;
import smartdevelop.ir.eram.showcaseviewlib.GuideMessageView;
import smartdevelop.ir.eram.showcaseviewlib.Targetable;
import smartdevelop.ir.eram.showcaseviewlib.config.DismissType;
import smartdevelop.ir.eram.showcaseviewlib.config.Gravity;
import smartdevelop.ir.eram.showcaseviewlib.listener.GuideListener;

public class GuideView
extends FrameLayout {
    static final String TAG = "GuideView";
    private static final int INDICATOR_HEIGHT = 40;
    private static final int MESSAGE_VIEW_PADDING = 5;
    private static final int SIZE_ANIMATION_DURATION = 700;
    private static final int APPEARING_ANIMATION_DURATION = 400;
    private static final int CIRCLE_INDICATOR_SIZE = 6;
    private static final int LINE_INDICATOR_WIDTH_SIZE = 3;
    private static final int STROKE_CIRCLE_INDICATOR_SIZE = 3;
    private static final int RADIUS_SIZE_TARGET_RECT = 15;
    private static final int MARGIN_INDICATOR = 15;
    private static final int BACKGROUND_COLOR = -1728053248;
    private static final int CIRCLE_INNER_INDICATOR_COLOR = -3355444;
    private static final int CIRCLE_INDICATOR_COLOR = -1;
    private static final int LINE_INDICATOR_COLOR = -1;
    private final Paint selfPaint = new Paint();
    private final Paint paintLine = new Paint();
    private final Paint paintCircle = new Paint();
    private final Paint paintCircleInner = new Paint();
    private final Paint targetPaint = new Paint(1);
    private final Xfermode X_FER_MODE_CLEAR = new PorterDuffXfermode(PorterDuff.Mode.CLEAR);
    private View target;
    private RectF targetRect;
    private final Rect selfRect = new Rect();
    private float density;
    private float stopY;
    private boolean isTop;
    private boolean mIsShowing;
    private int yMessageView = 0;
    private float startYLineAndCircle;
    private float circleIndicatorSize = 0.0f;
    private float circleIndicatorSizeFinal;
    private float circleInnerIndicatorSize = 0.0f;
    private float lineIndicatorWidthSize;
    private int messageViewPadding;
    private float marginGuide;
    private float strokeCircleWidth;
    private float indicatorHeight;
    private boolean isPerformedAnimationSize = false;
    private GuideListener mGuideListener;
    private Gravity mGravity;
    private DismissType dismissType;
    private GuideMessageView mMessageView;

    private GuideView(Context context, View view) {
        super(context);
        this.setWillNotDraw(false);
        this.setLayerType(2, null);
        this.target = view;
        this.density = context.getResources().getDisplayMetrics().density;
        this.init();
        if (view instanceof Targetable) {
            this.targetRect = ((Targetable)view).boundingRect();
        } else {
            int[] locationTarget = new int[2];
            this.target.getLocationOnScreen(locationTarget);
            this.targetRect = new RectF((float)locationTarget[0], (float)locationTarget[1], (float)(locationTarget[0] + this.target.getWidth()), (float)(locationTarget[1] + this.target.getHeight()));
        }
        this.mMessageView = new GuideMessageView(this.getContext());
        this.mMessageView.setPadding(this.messageViewPadding, this.messageViewPadding, this.messageViewPadding, this.messageViewPadding);
        this.mMessageView.setColor(-1);
        this.addView((View)this.mMessageView, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-2, -2));
        this.setMessageLocation(this.resolveMessageViewLocation());
        ViewTreeObserver.OnGlobalLayoutListener layoutListener = new ViewTreeObserver.OnGlobalLayoutListener(){

            public void onGlobalLayout() {
                if (Build.VERSION.SDK_INT > 16) {
                    GuideView.this.getViewTreeObserver().removeOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
                } else {
                    GuideView.this.getViewTreeObserver().removeGlobalOnLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
                }
                GuideView.this.setMessageLocation(GuideView.this.resolveMessageViewLocation());
                if (GuideView.this.target instanceof Targetable) {
                    GuideView.this.targetRect = ((Targetable)GuideView.this.target).boundingRect();
                } else {
                    int[] locationTarget = new int[2];
                    GuideView.this.target.getLocationOnScreen(locationTarget);
                    GuideView.this.targetRect = new RectF((float)locationTarget[0], (float)locationTarget[1], (float)(locationTarget[0] + GuideView.this.target.getWidth()), (float)(locationTarget[1] + GuideView.this.target.getHeight()));
                }
                GuideView.this.selfRect.set(GuideView.this.getPaddingLeft(), GuideView.this.getPaddingTop(), GuideView.this.getWidth() - GuideView.this.getPaddingRight(), GuideView.this.getHeight() - GuideView.this.getPaddingBottom());
                GuideView.this.marginGuide = (int)(GuideView.this.isTop ? GuideView.this.marginGuide : -GuideView.this.marginGuide);
                GuideView.this.startYLineAndCircle = (GuideView.this.isTop ? ((GuideView)GuideView.this).targetRect.bottom : ((GuideView)GuideView.this).targetRect.top) + GuideView.this.marginGuide;
                GuideView.this.stopY = (float)GuideView.this.yMessageView + GuideView.this.indicatorHeight;
                GuideView.this.startAnimationSize();
                GuideView.this.getViewTreeObserver().addOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
            }
        };
        this.getViewTreeObserver().addOnGlobalLayoutListener(layoutListener);
    }

    private void startAnimationSize() {
        if (!this.isPerformedAnimationSize) {
            final ValueAnimator circleSizeAnimator = ValueAnimator.ofFloat((float[])new float[]{0.0f, this.circleIndicatorSizeFinal});
            circleSizeAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

                public void onAnimationUpdate(ValueAnimator valueAnimator) {
                    GuideView.this.circleIndicatorSize = ((Float)circleSizeAnimator.getAnimatedValue()).floatValue();
                    GuideView.this.circleInnerIndicatorSize = ((Float)circleSizeAnimator.getAnimatedValue()).floatValue() - GuideView.this.density;
                    GuideView.this.postInvalidate();
                }
            });
            final ValueAnimator linePositionAnimator = ValueAnimator.ofFloat((float[])new float[]{this.stopY, this.startYLineAndCircle});
            linePositionAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

                public void onAnimationUpdate(ValueAnimator valueAnimator) {
                    GuideView.this.startYLineAndCircle = ((Float)linePositionAnimator.getAnimatedValue()).floatValue();
                    GuideView.this.postInvalidate();
                }
            });
            linePositionAnimator.setDuration(700L);
            linePositionAnimator.start();
            linePositionAnimator.addListener(new Animator.AnimatorListener(){

                public void onAnimationStart(Animator animator) {
                }

                public void onAnimationEnd(Animator animator) {
                    circleSizeAnimator.setDuration(700L);
                    circleSizeAnimator.start();
                    GuideView.this.isPerformedAnimationSize = true;
                }

                public void onAnimationCancel(Animator animator) {
                }

                public void onAnimationRepeat(Animator animator) {
                }
            });
        }
    }

    private void init() {
        this.lineIndicatorWidthSize = 3.0f * this.density;
        this.marginGuide = 15.0f * this.density;
        this.indicatorHeight = 40.0f * this.density;
        this.messageViewPadding = (int)(5.0f * this.density);
        this.strokeCircleWidth = 3.0f * this.density;
        this.circleIndicatorSizeFinal = 6.0f * this.density;
    }

    private int getNavigationBarSize() {
        Resources resources = this.getContext().getResources();
        int resourceId = resources.getIdentifier("navigation_bar_height", "dimen", "android");
        if (resourceId > 0) {
            return resources.getDimensionPixelSize(resourceId);
        }
        return 0;
    }

    private boolean isLandscape() {
        int display_mode = this.getResources().getConfiguration().orientation;
        return display_mode != 1;
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        if (this.target != null) {
            this.selfPaint.setColor(-1728053248);
            this.selfPaint.setStyle(Paint.Style.FILL);
            this.selfPaint.setAntiAlias(true);
            canvas.drawRect(this.selfRect, this.selfPaint);
            this.paintLine.setStyle(Paint.Style.FILL);
            this.paintLine.setColor(-1);
            this.paintLine.setStrokeWidth(this.lineIndicatorWidthSize);
            this.paintLine.setAntiAlias(true);
            this.paintCircle.setStyle(Paint.Style.STROKE);
            this.paintCircle.setColor(-1);
            this.paintCircle.setStrokeCap(Paint.Cap.ROUND);
            this.paintCircle.setStrokeWidth(this.strokeCircleWidth);
            this.paintCircle.setAntiAlias(true);
            this.paintCircleInner.setStyle(Paint.Style.FILL);
            this.paintCircleInner.setColor(-3355444);
            this.paintCircleInner.setAntiAlias(true);
            float x = this.targetRect.left / 2.0f + this.targetRect.right / 2.0f;
            canvas.drawLine(x, this.startYLineAndCircle, x, this.stopY, this.paintLine);
            canvas.drawCircle(x, this.startYLineAndCircle, this.circleIndicatorSize, this.paintCircle);
            canvas.drawCircle(x, this.startYLineAndCircle, this.circleInnerIndicatorSize, this.paintCircleInner);
            this.targetPaint.setXfermode(this.X_FER_MODE_CLEAR);
            this.targetPaint.setAntiAlias(true);
            if (this.target instanceof Targetable) {
                canvas.drawPath(((Targetable)this.target).guidePath(), this.targetPaint);
            } else {
                canvas.drawRoundRect(this.targetRect, 15.0f, 15.0f, this.targetPaint);
            }
        }
    }

    public boolean isShowing() {
        return this.mIsShowing;
    }

    public void dismiss() {
        ((ViewGroup)((Activity)this.getContext()).getWindow().getDecorView()).removeView((View)this);
        this.mIsShowing = false;
        if (this.mGuideListener != null) {
            this.mGuideListener.onDismiss(this.target);
        }
    }

    public boolean onTouchEvent(MotionEvent event) {
        float x = event.getX();
        float y = event.getY();
        if (event.getAction() == 0) {
            switch (this.dismissType) {
                case outside: {
                    if (this.isViewContains((View)this.mMessageView, x, y)) break;
                    this.dismiss();
                    break;
                }
                case anywhere: {
                    this.dismiss();
                    break;
                }
                case targetView: {
                    if (!this.targetRect.contains(x, y)) break;
                    this.target.performClick();
                    this.dismiss();
                    break;
                }
                case selfView: {
                    if (!this.isViewContains((View)this.mMessageView, x, y)) break;
                    this.dismiss();
                }
            }
            return true;
        }
        return false;
    }

    private boolean isViewContains(View view, float rx, float ry) {
        int[] location = new int[2];
        view.getLocationOnScreen(location);
        int x = location[0];
        int y = location[1];
        int w = view.getWidth();
        int h = view.getHeight();
        return !(rx < (float)x || rx > (float)(x + w) || ry < (float)y || ry > (float)(y + h));
    }

    private void setMessageLocation(Point p) {
        this.mMessageView.setX(p.x);
        this.mMessageView.setY(p.y);
        this.postInvalidate();
    }

    public void updateGuideViewLocation() {
        this.requestLayout();
    }

    private Point resolveMessageViewLocation() {
        int xMessageView = 0;
        xMessageView = this.mGravity == Gravity.center ? (int)(this.targetRect.left - (float)(this.mMessageView.getWidth() / 2) + (float)(this.target.getWidth() / 2)) : (int)this.targetRect.right - this.mMessageView.getWidth();
        if (this.isLandscape()) {
            xMessageView -= this.getNavigationBarSize();
        }
        if (xMessageView + this.mMessageView.getWidth() > this.getWidth()) {
            xMessageView = this.getWidth() - this.mMessageView.getWidth();
        }
        if (xMessageView < 0) {
            xMessageView = 0;
        }
        if (this.targetRect.top + this.indicatorHeight > (float)(this.getHeight() / 2)) {
            this.isTop = false;
            this.yMessageView = (int)(this.targetRect.top - (float)this.mMessageView.getHeight() - this.indicatorHeight);
        } else {
            this.isTop = true;
            this.yMessageView = (int)(this.targetRect.top + (float)this.target.getHeight() + this.indicatorHeight);
        }
        if (this.yMessageView < 0) {
            this.yMessageView = 0;
        }
        return new Point(xMessageView, this.yMessageView);
    }

    public void show() {
        this.setLayoutParams(new ViewGroup.LayoutParams(-1, -1));
        this.setClickable(false);
        ((ViewGroup)((Activity)this.getContext()).getWindow().getDecorView()).addView((View)this);
        AlphaAnimation startAnimation = new AlphaAnimation(0.0f, 1.0f);
        startAnimation.setDuration(400L);
        startAnimation.setFillAfter(true);
        this.startAnimation((Animation)startAnimation);
        this.mIsShowing = true;
    }

    public void setTitle(String str) {
        this.mMessageView.setTitle(str);
    }

    public void setContentText(String str) {
        this.mMessageView.setContentText(str);
    }

    public void setContentSpan(Spannable span) {
        this.mMessageView.setContentSpan(span);
    }

    public void setTitleTypeFace(Typeface typeFace) {
        this.mMessageView.setTitleTypeFace(typeFace);
    }

    public void setContentTypeFace(Typeface typeFace) {
        this.mMessageView.setContentTypeFace(typeFace);
    }

    public void setTitleTextSize(int size) {
        this.mMessageView.setTitleTextSize(size);
    }

    public void setContentTextSize(int size) {
        this.mMessageView.setContentTextSize(size);
    }

    public static class Builder {
        private View targetView;
        private String title;
        private String contentText;
        private Gravity gravity;
        private DismissType dismissType;
        private Context context;
        private Spannable contentSpan;
        private Typeface titleTypeFace;
        private Typeface contentTypeFace;
        private GuideListener guideListener;
        private int titleTextSize;
        private int contentTextSize;
        private float lineIndicatorHeight;
        private float lineIndicatorWidthSize;
        private float circleIndicatorSize;
        private float circleInnerIndicatorSize;
        private float strokeCircleWidth;

        public Builder(Context context) {
            this.context = context;
        }

        public Builder setTargetView(View view) {
            this.targetView = view;
            return this;
        }

        public Builder setGravity(Gravity gravity) {
            this.gravity = gravity;
            return this;
        }

        public Builder setTitle(String title) {
            this.title = title;
            return this;
        }

        public Builder setContentText(String contentText) {
            this.contentText = contentText;
            return this;
        }

        public Builder setContentSpan(Spannable span) {
            this.contentSpan = span;
            return this;
        }

        public Builder setContentTypeFace(Typeface typeFace) {
            this.contentTypeFace = typeFace;
            return this;
        }

        public Builder setGuideListener(GuideListener guideListener) {
            this.guideListener = guideListener;
            return this;
        }

        public Builder setTitleTypeFace(Typeface typeFace) {
            this.titleTypeFace = typeFace;
            return this;
        }

        public Builder setContentTextSize(int size) {
            this.contentTextSize = size;
            return this;
        }

        public Builder setTitleTextSize(int size) {
            this.titleTextSize = size;
            return this;
        }

        public Builder setDismissType(DismissType dismissType) {
            this.dismissType = dismissType;
            return this;
        }

        public Builder setIndicatorHeight(float height) {
            this.lineIndicatorHeight = height;
            return this;
        }

        public Builder setIndicatorWidthSize(float width) {
            this.lineIndicatorWidthSize = width;
            return this;
        }

        public Builder setCircleIndicatorSize(float size) {
            this.circleIndicatorSize = size;
            return this;
        }

        public Builder setCircleInnerIndicatorSize(float size) {
            this.circleInnerIndicatorSize = size;
            return this;
        }

        public Builder setCircleStrokeIndicatorSize(float size) {
            this.strokeCircleWidth = size;
            return this;
        }

        public GuideView build() {
            GuideView guideView = new GuideView(this.context, this.targetView);
            guideView.mGravity = this.gravity != null ? this.gravity : Gravity.auto;
            guideView.dismissType = this.dismissType != null ? this.dismissType : DismissType.targetView;
            float density = this.context.getResources().getDisplayMetrics().density;
            guideView.setTitle(this.title);
            if (this.contentText != null) {
                guideView.setContentText(this.contentText);
            }
            if (this.titleTextSize != 0) {
                guideView.setTitleTextSize(this.titleTextSize);
            }
            if (this.contentTextSize != 0) {
                guideView.setContentTextSize(this.contentTextSize);
            }
            if (this.contentSpan != null) {
                guideView.setContentSpan(this.contentSpan);
            }
            if (this.titleTypeFace != null) {
                guideView.setTitleTypeFace(this.titleTypeFace);
            }
            if (this.contentTypeFace != null) {
                guideView.setContentTypeFace(this.contentTypeFace);
            }
            if (this.guideListener != null) {
                guideView.mGuideListener = this.guideListener;
            }
            if (this.lineIndicatorHeight != 0.0f) {
                guideView.indicatorHeight = this.lineIndicatorHeight * density;
            }
            if (this.lineIndicatorWidthSize != 0.0f) {
                guideView.lineIndicatorWidthSize = this.lineIndicatorWidthSize * density;
            }
            if (this.circleIndicatorSize != 0.0f) {
                guideView.circleIndicatorSize = this.circleIndicatorSize * density;
            }
            if (this.circleInnerIndicatorSize != 0.0f) {
                guideView.circleInnerIndicatorSize = this.circleInnerIndicatorSize * density;
            }
            if (this.strokeCircleWidth != 0.0f) {
                guideView.strokeCircleWidth = this.strokeCircleWidth * density;
            }
            return guideView;
        }
    }
}

