/*
 * Decompiled with CFR 0.152.
 */
package smartdevelop.ir.eram.showcaseviewlib;

import android.app.Activity;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Point;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.RectF;
import android.graphics.Typeface;
import android.graphics.Xfermode;
import android.text.Spannable;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.widget.FrameLayout;
import smartdevelop.ir.eram.showcaseviewlib.GuideMessageView;

public class GuideView
extends FrameLayout {
    private static final float INDICATOR_HEIGHT = 50.0f;
    private float density;
    private View target;
    private RectF rect;
    private GuideMessageView mMessageView;
    private boolean isTop;
    private Gravity mGravity;
    int marginGuide;
    final Paint emptyPaint = new Paint();
    final Paint paintLine = new Paint();
    final Paint paintCircle = new Paint();
    final Paint paintCircleInner = new Paint();
    final Paint mPaint = new Paint();
    final Paint targetPaint = new Paint(1);
    final Xfermode XFERMODE_CLEAR = new PorterDuffXfermode(PorterDuff.Mode.CLEAR);
    int x = 0;
    int y = 0;

    private GuideView(Context context, View view) {
        super(context);
        this.setWillNotDraw(false);
        this.target = view;
        this.density = context.getResources().getDisplayMetrics().density;
        int[] locationTarget = new int[2];
        this.target.getLocationOnScreen(locationTarget);
        this.rect = new RectF((float)locationTarget[0], (float)locationTarget[1], (float)(locationTarget[0] + this.target.getWidth()), (float)(locationTarget[1] + this.target.getHeight()));
        this.mMessageView = new GuideMessageView(this.getContext());
        int padding = (int)(5.0f * this.density);
        this.mMessageView.setPadding(padding, padding, padding, padding);
        this.mMessageView.setColor(-1);
        this.addView((View)this.mMessageView, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-2, -2));
        this.setMessageLocation(this.resolveMessageViewLocation());
        this.getViewTreeObserver().addOnGlobalLayoutListener(new ViewTreeObserver.OnGlobalLayoutListener(){

            public void onGlobalLayout() {
                GuideView.this.setMessageLocation(GuideView.this.resolveMessageViewLocation());
                int[] locationTarget = new int[2];
                GuideView.this.target.getLocationOnScreen(locationTarget);
                GuideView.this.rect = new RectF((float)locationTarget[0], (float)locationTarget[1], (float)(locationTarget[0] + GuideView.this.target.getWidth()), (float)(locationTarget[1] + GuideView.this.target.getHeight()));
            }
        });
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        if (this.target != null) {
            Bitmap bitmap = Bitmap.createBitmap((int)canvas.getWidth(), (int)canvas.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
            Canvas tempCanvas = new Canvas(bitmap);
            float lineWidth = 3.0f * this.density;
            float strokeCircleWidth = 3.0f * this.density;
            float circleSize = 6.0f * this.density;
            float circleInnerSize = 4.5f * this.density;
            this.mPaint.setColor(-1728053248);
            this.mPaint.setStyle(Paint.Style.FILL);
            this.mPaint.setAntiAlias(true);
            tempCanvas.drawRect(canvas.getClipBounds(), this.mPaint);
            this.paintLine.setStyle(Paint.Style.FILL);
            this.paintLine.setColor(-1);
            this.paintLine.setStrokeWidth(lineWidth);
            this.paintLine.setAntiAlias(true);
            this.paintCircle.setStyle(Paint.Style.STROKE);
            this.paintCircle.setColor(-1);
            this.paintCircle.setStrokeCap(Paint.Cap.ROUND);
            this.paintCircle.setStrokeWidth(strokeCircleWidth);
            this.paintCircle.setAntiAlias(true);
            this.paintCircleInner.setStyle(Paint.Style.FILL);
            this.paintCircleInner.setColor(-3355444);
            this.paintCircleInner.setAntiAlias(true);
            this.marginGuide = (int)(this.isTop ? 15.0f * this.density : -15.0f * this.density);
            float yLineAndCircle = (this.isTop ? this.rect.bottom : this.rect.top) + (float)this.marginGuide;
            float xLine = this.rect.left / 2.0f + this.rect.right / 2.0f;
            float cx = this.target.getLeft() / 2 + this.target.getRight() / 2;
            tempCanvas.drawLine(xLine, yLineAndCircle, xLine, (float)this.y + 50.0f * this.density, this.paintLine);
            tempCanvas.drawCircle(cx, yLineAndCircle, circleSize, this.paintCircle);
            tempCanvas.drawCircle(cx, yLineAndCircle, circleInnerSize, this.paintCircleInner);
            this.targetPaint.setXfermode(this.XFERMODE_CLEAR);
            this.targetPaint.setAntiAlias(true);
            tempCanvas.drawRoundRect(this.rect, 15.0f, 15.0f, this.targetPaint);
            canvas.drawBitmap(bitmap, 0.0f, 0.0f, this.emptyPaint);
        }
    }

    public int getStatusBarHeight() {
        int result = 0;
        int resourceId = this.getResources().getIdentifier("status_bar_height", "dimen", "android");
        if (resourceId > 0) {
            result = this.getResources().getDimensionPixelSize(resourceId);
        }
        return result;
    }

    public void dismiss() {
        ((ViewGroup)((Activity)this.getContext()).getWindow().getDecorView()).removeView((View)this);
    }

    public boolean onTouchEvent(MotionEvent event) {
        float x = event.getX();
        float y = event.getY();
        switch (event.getAction()) {
            case 0: {
                if (this.rect.contains(x, y)) {
                    this.target.performClick();
                    this.dismiss();
                }
                return true;
            }
        }
        return false;
    }

    void setMessageLocation(Point p) {
        this.mMessageView.setX(p.x);
        this.mMessageView.setY(p.y);
        this.requestLayout();
    }

    private Point resolveMessageViewLocation() {
        this.x = this.mGravity == Gravity.CENTER ? this.getWidth() / 2 - this.mMessageView.getWidth() / 2 : (int)this.rect.right - this.mMessageView.getWidth();
        if (this.x + this.mMessageView.getWidth() > this.getWidth()) {
            this.x -= this.getWidth() - this.mMessageView.getWidth();
        }
        if (this.x < 0) {
            this.x = 0;
        }
        if (this.rect.top + 50.0f * this.density > (float)(this.getHeight() / 2)) {
            this.isTop = false;
            this.y = (int)(this.rect.top - (float)this.mMessageView.getHeight() - 50.0f * this.density);
        } else {
            this.isTop = true;
            this.y = (int)(this.rect.bottom + (float)this.mMessageView.getHeight() - 50.0f * this.density);
        }
        if (this.y < 0) {
            this.y = 0;
        }
        return new Point(this.x, this.y);
    }

    public void show() {
        this.setLayoutParams(new ViewGroup.LayoutParams(-1, -1));
        this.setClickable(false);
        ((ViewGroup)((Activity)this.getContext()).getWindow().getDecorView()).addView((View)this);
    }

    public void setTitle(String str) {
        this.mMessageView.setTitle(str);
    }

    public void setContentText(String str) {
        this.mMessageView.setContentText(str);
    }

    public void setContentSpan(Spannable span) {
        this.mMessageView.setContentSpan(span);
    }

    public void setTitleTypeFace(Typeface typeFace) {
        this.mMessageView.setTitleTypeFace(typeFace);
    }

    public void setContentTypeFace(Typeface typeFace) {
        this.mMessageView.setContentTypeFace(typeFace);
    }

    public void setTitleTextSize(int size) {
        this.mMessageView.setTitleTextSize(size);
    }

    public void setContentTextSize(int size) {
        this.mMessageView.setContentTextSize(size);
    }

    public static class Builder {
        private View targetView;
        private String title;
        private String contentText;
        private Gravity gravity;
        private Context context;
        private int titleTextSize;
        private int contentTextSize;
        private Spannable contentSpan;
        private Typeface titleTypeFace;
        private Typeface contentTypeFace;

        public Builder(Context context) {
            this.context = context;
        }

        public Builder setTargetView(View view) {
            this.targetView = view;
            return this;
        }

        public Builder setGravity(Gravity gravity) {
            this.gravity = gravity;
            return this;
        }

        public Builder setTitle(String title) {
            this.title = title;
            return this;
        }

        public Builder setContentText(String contentText) {
            this.contentText = contentText;
            return this;
        }

        public Builder setContentSpan(Spannable span) {
            this.contentSpan = span;
            return this;
        }

        public Builder setContentTypeFace(Typeface typeFace) {
            this.contentTypeFace = typeFace;
            return this;
        }

        public Builder setTitleTypeFace(Typeface typeFace) {
            this.titleTypeFace = typeFace;
            return this;
        }

        public Builder setContentTextSize(int size) {
            this.contentTextSize = size;
            return this;
        }

        public Builder setTitleTextSize(int size) {
            this.titleTextSize = size;
            return this;
        }

        public GuideView build() {
            GuideView guideView = new GuideView(this.context, this.targetView);
            guideView.mGravity = this.gravity != null ? this.gravity : Gravity.AUTO;
            guideView.setTitle(this.title);
            if (this.contentText != null) {
                guideView.setContentText(this.contentText);
            }
            if (this.titleTextSize != 0) {
                guideView.setTitleTextSize(this.titleTextSize);
            }
            if (this.contentTextSize != 0) {
                guideView.setContentTextSize(this.contentTextSize);
            }
            if (this.contentSpan != null) {
                guideView.setContentSpan(this.contentSpan);
            }
            if (this.titleTypeFace != null) {
                guideView.setTitleTypeFace(this.titleTypeFace);
            }
            if (this.contentTypeFace != null) {
                guideView.setContentTypeFace(this.contentTypeFace);
            }
            return guideView;
        }
    }

    public static enum Gravity {
        AUTO,
        CENTER;

    }
}

