/*
 * Decompiled with CFR 0.152.
 */
package moxy.viewstate;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import moxy.MvpView;
import moxy.locators.StrategyLocator;
import moxy.viewstate.ViewCommand;
import moxy.viewstate.strategy.StateStrategy;

public class ViewCommands<View extends MvpView> {
    private List<ViewCommand<View>> state = new ArrayList<ViewCommand<View>>();
    private Map<Class<? extends StateStrategy>, StateStrategy> strategies = new HashMap<Class<? extends StateStrategy>, StateStrategy>();

    public void beforeApply(ViewCommand<View> viewCommand) {
        StateStrategy stateStrategy = this.getStateStrategy(viewCommand);
        stateStrategy.beforeApply(this.state, viewCommand);
    }

    public void afterApply(ViewCommand<View> viewCommand) {
        StateStrategy stateStrategy = this.getStateStrategy(viewCommand);
        stateStrategy.afterApply(this.state, viewCommand);
    }

    private StateStrategy getStateStrategy(ViewCommand<View> viewCommand) {
        StateStrategy stateStrategy = StrategyLocator.getStrategy(viewCommand.getStrategyType());
        if (stateStrategy == null) {
            try {
                stateStrategy = viewCommand.getStrategyType().newInstance();
            }
            catch (InstantiationException e) {
                throw new IllegalArgumentException("Unable to create state strategy: " + viewCommand.toString());
            }
            catch (IllegalAccessException e) {
                throw new IllegalArgumentException("Unable to create state strategy: " + viewCommand.toString());
            }
            this.strategies.put(viewCommand.getStrategyType(), stateStrategy);
        }
        return stateStrategy;
    }

    public boolean isEmpty() {
        return this.state.isEmpty();
    }

    public void reapply(View view, Set<ViewCommand<View>> currentState) {
        ArrayList<ViewCommand<View>> commands = new ArrayList<ViewCommand<View>>(this.state);
        for (ViewCommand<View> command : commands) {
            if (currentState.contains(command)) continue;
            command.apply(view);
            this.afterApply(command);
        }
    }

    public List<ViewCommand<View>> getCurrentState() {
        return this.state;
    }
}

