/*
 * Decompiled with CFR 0.152.
 */
package moxy.compiler.viewstate;

import com.squareup.javapoet.JavaFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.annotation.processing.Messager;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.tools.Diagnostic;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import moxy.compiler.ElementProcessor;
import moxy.compiler.ExtensionsKt;
import moxy.compiler.MvpCompiler;
import moxy.compiler.viewstate.EmptyStrategyHelperGenerator;
import moxy.compiler.viewstate.ViewInterfaceProcessor;
import moxy.compiler.viewstate.ViewInterfaceProcessor$getInterfaceStateStrategyType$value$1;
import moxy.compiler.viewstate.ViewInterfaceProcessor$getStateStrategy$strategyClassFromAnnotation$1;
import moxy.compiler.viewstate.ViewInterfaceProcessor$getStateStrategy$tag$1;
import moxy.compiler.viewstate.entity.MigrationMethod;
import moxy.compiler.viewstate.entity.StrategyWithTag;
import moxy.compiler.viewstate.entity.ViewInterfaceInfo;
import moxy.compiler.viewstate.entity.ViewInterfaceMethod;
import moxy.compiler.viewstate.entity.ViewStateMethod;
import moxy.viewstate.strategy.AddToEndSingleStrategy;
import moxy.viewstate.strategy.StateStrategyType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\f\u0018\u0000 82\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001:\u00018B\u001f\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0002\u0010\tJ\u0016\u0010\u000f\u001a\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012H\u0002J0\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u00152\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00160\u00152\u0012\u0010\u0017\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00160\u00150\u0012H\u0002J\"\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00160\u00152\u0012\u0010\u0019\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00160\u00150\u0012H\u0002J\u0016\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00160\u00152\u0006\u0010\u001b\u001a\u00020\u0002H\u0002J\u0012\u0010\u001c\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u001b\u001a\u00020\u0002H\u0002J\u0016\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00160\u00152\u0006\u0010\u001e\u001a\u00020\u0002H\u0002J\u0012\u0010\u001f\u001a\u0004\u0018\u00010 2\u0006\u0010!\u001a\u00020\"H\u0002J\u0012\u0010#\u001a\u0004\u0018\u00010$2\u0006\u0010\u001e\u001a\u00020%H\u0002J\u0010\u0010&\u001a\u00020\u00022\u0006\u0010'\u001a\u00020(H\u0002J\"\u0010)\u001a\u00020\u00162\u0006\u0010!\u001a\u00020\"2\u0006\u0010\u001b\u001a\u00020\u00022\b\u0010*\u001a\u0004\u0018\u00010\u0002H\u0002J\u001c\u0010+\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00160\u00150\u00122\u0006\u0010\u001b\u001a\u00020\u0002H\u0002J\b\u0010,\u001a\u0004\u0018\u00010-J\u0010\u0010.\u001a\u00020\u00032\u0006\u0010\u001e\u001a\u00020\u0002H\u0016J\u0010\u0010/\u001a\u00020\u00102\u0006\u0010!\u001a\u00020\"H\u0002J\u0018\u00100\u001a\u00020\u00102\u0006\u00101\u001a\u00020\u00162\u0006\u00102\u001a\u00020\u0016H\u0002J\u001c\u00103\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015H\u0002J\u0016\u00104\u001a\u00020\u00102\f\u00105\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015H\u0002J\f\u00106\u001a\u00020\b*\u00020\"H\u0002J\f\u00107\u001a\u00020\u0005*\u00020%H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0002X\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u00069"}, d2={"Lmoxy/compiler/viewstate/ViewInterfaceProcessor;", "Lmoxy/compiler/ElementProcessor;", "Ljavax/lang/model/element/TypeElement;", "Lmoxy/compiler/viewstate/entity/ViewInterfaceInfo;", "disableEmptyStrategyCheck", "", "enableEmptyStrategyHelper", "defaultStrategy", "", "(ZZLjava/lang/String;)V", "frameworkDefaultStrategy", "migrationMethods", "", "Lmoxy/compiler/viewstate/entity/MigrationMethod;", "viewInterfaceElement", "addUniqueSuffixToMethodsWithTheSameName", "", "methods", "", "Lmoxy/compiler/viewstate/entity/ViewStateMethod;", "combineMethods", "", "Lmoxy/compiler/viewstate/entity/ViewInterfaceMethod;", "superInterfaces", "combineMethodsFromSuperinterfaces", "superInterfaceMethods", "getEnclosedMethods", "viewInterface", "getInterfaceStateStrategyType", "getMethods", "element", "getStateStrategy", "Lmoxy/compiler/viewstate/entity/StrategyWithTag;", "methodElement", "Ljavax/lang/model/element/ExecutableElement;", "getStateStrategyAnnotation", "Ljavax/lang/model/element/AnnotationMirror;", "Ljavax/lang/model/element/Element;", "getTypeAndValidateGenerics", "interfaceMirror", "Ljavax/lang/model/type/TypeMirror;", "getViewMethod", "viewInterfaceStrategyType", "iterateInterfaces", "makeMigrationHelper", "Lcom/squareup/javapoet/JavaFile;", "process", "reportEmptyStrategy", "reportSuperinterfaceMethodsClash", "methodA", "methodB", "validateForEmptyStrategies", "validateSuperInterfaceMethodClashes", "viewInterfaceMethods", "defaultTag", "isStatic", "Companion", "moxy-compiler"})
public final class ViewInterfaceProcessor
implements ElementProcessor<TypeElement, ViewInterfaceInfo> {
    private final TypeElement frameworkDefaultStrategy;
    private TypeElement viewInterfaceElement;
    private final List<MigrationMethod> migrationMethods;
    private final boolean disableEmptyStrategyCheck;
    private final boolean enableEmptyStrategyHelper;
    private static final String OPTION_DEFAULT_STRATEGY = "defaultMoxyStrategy";
    private static final TypeElement DEFAULT_STATE_STRATEGY;
    @NotNull
    public static final Companion Companion;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public final JavaFile makeMigrationHelper() {
        if (!this.enableEmptyStrategyHelper) return null;
        Collection collection = this.migrationMethods;
        boolean bl = false;
        if (collection.isEmpty()) return null;
        boolean bl2 = true;
        if (!bl2) return null;
        JavaFile javaFile = EmptyStrategyHelperGenerator.generate(this.migrationMethods);
        return javaFile;
    }

    @Override
    @NotNull
    public ViewInterfaceInfo process(@NotNull TypeElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        this.viewInterfaceElement = element;
        Set<ViewInterfaceMethod> viewInterfaceMethods = this.getMethods(element);
        this.validateSuperInterfaceMethodClashes(viewInterfaceMethods);
        List<ViewStateMethod> methods = this.validateForEmptyStrategies(viewInterfaceMethods);
        this.addUniqueSuffixToMethodsWithTheSameName(methods);
        return new ViewInterfaceInfo(element, CollectionsKt.toList((Iterable)methods));
    }

    private final Set<ViewInterfaceMethod> getMethods(TypeElement element) {
        Set<ViewInterfaceMethod> enclosedMethods = this.getEnclosedMethods(element);
        List<Set<ViewInterfaceMethod>> methodsFromSuperinterfaces = this.iterateInterfaces(element);
        return this.combineMethods(enclosedMethods, methodsFromSuperinterfaces);
    }

    /*
     * WARNING - void declaration
     */
    private final Set<ViewInterfaceMethod> getEnclosedMethods(TypeElement viewInterface) {
        void $this$mapTo$iv$iv;
        Element it;
        Iterable $this$filterTo$iv$iv;
        TypeElement viewInterfaceStrategy = this.getInterfaceStateStrategyType(viewInterface);
        List<? extends Element> list = viewInterface.getEnclosedElements();
        Intrinsics.checkNotNullExpressionValue(list, (String)"viewInterface.enclosedElements");
        Iterable $this$filter$iv = list;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (Element)element$iv$iv;
            boolean bl = false;
            Element element = it;
            Intrinsics.checkNotNullExpressionValue((Object)element, (String)"it");
            if (!(element.getKind() == ElementKind.METHOD && !this.isStatic(it))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (Element)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Element element = it;
            if (element == null) {
                throw new NullPointerException("null cannot be cast to non-null type javax.lang.model.element.ExecutableElement");
            }
            ViewInterfaceMethod viewInterfaceMethod = this.getViewMethod((ExecutableElement)element, viewInterface, viewInterfaceStrategy);
            collection.add(viewInterfaceMethod);
        }
        return CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
    }

    private final ViewInterfaceMethod getViewMethod(ExecutableElement methodElement, TypeElement viewInterface, TypeElement viewInterfaceStrategyType) {
        StrategyWithTag strategyWithTag;
        TypeMirror typeMirror = methodElement.getReturnType();
        Intrinsics.checkNotNullExpressionValue((Object)typeMirror, (String)"methodElement.returnType");
        if (typeMirror.getKind() != TypeKind.VOID) {
            String message = "You are trying to generate ViewState for " + viewInterface.getSimpleName() + ". " + "But " + viewInterface.getSimpleName() + " contains non-void method \"" + methodElement.getSimpleName() + "\" " + "with the return type of " + methodElement.getReturnType() + '.';
            MvpCompiler.Companion.getMessager().printMessage(Diagnostic.Kind.ERROR, message, methodElement);
        }
        if ((strategyWithTag = this.getStateStrategy(methodElement)) == null) {
            TypeElement typeElement = viewInterfaceStrategyType;
            if (typeElement != null) {
                TypeElement typeElement2 = typeElement;
                boolean bl = false;
                boolean bl2 = false;
                TypeElement type = typeElement2;
                boolean bl3 = false;
                strategyWithTag = new StrategyWithTag(type, this.defaultTag(methodElement));
            } else {
                strategyWithTag = null;
            }
        }
        StrategyWithTag strategy = strategyWithTag;
        TypeElement typeElement = this.viewInterfaceElement;
        if (typeElement == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"viewInterfaceElement");
        }
        return new ViewInterfaceMethod(ExtensionsKt.asDeclaredType(typeElement), ExtensionsKt.asDeclaredType(viewInterface), methodElement, strategy);
    }

    private final StrategyWithTag getStateStrategy(ExecutableElement methodElement) {
        AnnotationMirror annotationMirror = this.getStateStrategyAnnotation(methodElement);
        if (annotationMirror == null) {
            return null;
        }
        AnnotationMirror annotation = annotationMirror;
        TypeMirror typeMirror = ExtensionsKt.getValueAsTypeMirror(annotation, ViewInterfaceProcessor$getStateStrategy$strategyClassFromAnnotation$1.INSTANCE);
        if (typeMirror == null) {
            return null;
        }
        TypeMirror strategyClassFromAnnotation2 = typeMirror;
        TypeElement strategyType = ExtensionsKt.asTypeElement(strategyClassFromAnnotation2);
        String string = ExtensionsKt.getValueAsString(annotation, ViewInterfaceProcessor$getStateStrategy$tag$1.INSTANCE);
        if (string == null) {
            string = this.defaultTag(methodElement);
        }
        String tag2 = string;
        return new StrategyWithTag(strategyType, tag2);
    }

    private final List<Set<ViewInterfaceMethod>> iterateInterfaces(TypeElement viewInterface) {
        Object object;
        TypeElement it;
        Collection collection;
        Iterable $this$mapTo$iv$iv;
        List<? extends TypeMirror> list = viewInterface.getInterfaces();
        Intrinsics.checkNotNullExpressionValue(list, (String)"viewInterface.interfaces");
        Iterable $this$map$iv = list;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            TypeMirror typeMirror = (TypeMirror)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            void v1 = it;
            Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"it");
            object = this.getTypeAndValidateGenerics((TypeMirror)v1);
            collection.add(object);
        }
        $this$map$iv = (List)destination$iv$iv;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (TypeElement)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            object = this.getMethods(it);
            collection.add(object);
        }
        return (List)destination$iv$iv;
    }

    private final TypeElement getTypeAndValidateGenerics(TypeMirror interfaceMirror) {
        TypeElement superinterface = ExtensionsKt.asTypeElement(interfaceMirror);
        List<? extends TypeMirror> typeArguments = ((DeclaredType)interfaceMirror).getTypeArguments();
        List<? extends TypeParameterElement> typeParameters = superinterface.getTypeParameters();
        boolean bl = typeArguments.size() <= typeParameters.size();
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "Code generation for the interface " + superinterface.getSimpleName() + " failed. Simplify your generics.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        return superinterface;
    }

    private final Set<ViewInterfaceMethod> combineMethods(Set<ViewInterfaceMethod> methods, List<? extends Set<ViewInterfaceMethod>> superInterfaces) {
        Set<ViewInterfaceMethod> superInterfaceMethods = this.combineMethodsFromSuperinterfaces(superInterfaces);
        return SetsKt.plus(methods, (Iterable)superInterfaceMethods);
    }

    private final Set<ViewInterfaceMethod> combineMethodsFromSuperinterfaces(List<? extends Set<ViewInterfaceMethod>> superInterfaceMethods) {
        boolean bl = false;
        Set resultSet = new LinkedHashSet();
        for (Set<ViewInterfaceMethod> set : superInterfaceMethods) {
            for (ViewInterfaceMethod method : set) {
                Object element$iv22;
                block3: {
                    boolean isAdded = resultSet.add(method);
                    if (isAdded) continue;
                    Iterable $this$first$iv = resultSet;
                    boolean $i$f$first = false;
                    for (Object element$iv22 : $this$first$iv) {
                        ViewInterfaceMethod it = (ViewInterfaceMethod)element$iv22;
                        boolean bl2 = false;
                        if (!Intrinsics.areEqual((Object)it, (Object)method)) continue;
                        break block3;
                    }
                    throw (Throwable)new NoSuchElementException("Collection contains no element matching the predicate.");
                }
                ViewInterfaceMethod contained = (ViewInterfaceMethod)element$iv22;
                contained.setSuperInterfaceClash(method);
            }
        }
        return resultSet;
    }

    private final void reportSuperinterfaceMethodsClash(ViewInterfaceMethod methodA, ViewInterfaceMethod methodB) {
        if (Intrinsics.areEqual((Object)methodA.getStrategy(), (Object)methodB.getStrategy()) ^ true && methodA.getStrategy() != null && methodB.getStrategy() != null) {
            Messager messager = MvpCompiler.Companion.getMessager();
            StringBuilder stringBuilder = new StringBuilder().append("Strategy clash in superinterfaces of ");
            TypeElement typeElement = this.viewInterfaceElement;
            if (typeElement == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"viewInterfaceElement");
            }
            StringBuilder stringBuilder2 = stringBuilder.append(typeElement).append(". ").append("Interface ").append(methodB.getEnclosingInterfaceElement().toString()).append(" defines ").append(methodB.getSignature()).append(' ').append("with strategy ").append((Object)methodB.getStrategy().getStrategyClass().getSimpleName()).append(", ").append("but ").append(methodA.getEnclosingInterfaceElement().toString()).append(" defines this method ").append("with strategy ").append((Object)methodA.getStrategy().getStrategyClass().getSimpleName()).append(". ").append("Override this method in ");
            TypeElement typeElement2 = this.viewInterfaceElement;
            if (typeElement2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"viewInterfaceElement");
            }
            CharSequence charSequence = stringBuilder2.append(typeElement2).append(" to choose appropriate strategy").toString();
            TypeElement typeElement3 = this.viewInterfaceElement;
            if (typeElement3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"viewInterfaceElement");
            }
            messager.printMessage(Diagnostic.Kind.ERROR, charSequence, typeElement3);
        }
    }

    private final void addUniqueSuffixToMethodsWithTheSameName(List<ViewStateMethod> methods) {
        boolean bl = false;
        Map methodsCounter = new LinkedHashMap();
        for (ViewStateMethod method : methods) {
            int counter;
            Integer n = (Integer)methodsCounter.get(method.getName());
            int n2 = counter = n != null ? n : 0;
            if (counter > 0) {
                method.setUniqueSuffix(String.valueOf(counter));
            }
            methodsCounter.put(method.getName(), counter + 1);
        }
    }

    private final TypeElement getInterfaceStateStrategyType(TypeElement viewInterface) {
        AnnotationMirror annotation;
        AnnotationMirror annotationMirror = annotation = this.getStateStrategyAnnotation(viewInterface);
        TypeMirror value2 = annotationMirror != null ? ExtensionsKt.getValueAsTypeMirror(annotationMirror, ViewInterfaceProcessor$getInterfaceStateStrategyType$value$1.INSTANCE) : null;
        return value2 != null && value2.getKind() == TypeKind.DECLARED ? ExtensionsKt.asTypeElement(value2) : null;
    }

    private final void validateSuperInterfaceMethodClashes(Set<ViewInterfaceMethod> viewInterfaceMethods) {
        for (ViewInterfaceMethod method : viewInterfaceMethods) {
            ViewInterfaceMethod viewInterfaceMethod;
            if (method.getSuperInterfaceClash() == null) continue;
            boolean bl = false;
            boolean bl2 = false;
            ViewInterfaceMethod clashed = viewInterfaceMethod;
            boolean bl3 = false;
            this.reportSuperinterfaceMethodsClash(clashed, method);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final List<ViewStateMethod> validateForEmptyStrategies(Set<ViewInterfaceMethod> methods) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = methods;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            ViewStateMethod viewStateMethod;
            void method;
            ViewInterfaceMethod viewInterfaceMethod = (ViewInterfaceMethod)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            if (method.getStrategy() == null) {
                this.reportEmptyStrategy(method.getMethodElement());
                viewStateMethod = method.toViewMethod(new StrategyWithTag(this.frameworkDefaultStrategy, this.defaultTag(method.getMethodElement())));
            } else {
                viewStateMethod = method.toViewMethod();
            }
            ViewStateMethod viewStateMethod2 = viewStateMethod;
            collection.add(viewStateMethod2);
        }
        return (List)destination$iv$iv;
    }

    private final void reportEmptyStrategy(ExecutableElement methodElement) {
        if (!this.disableEmptyStrategyCheck) {
            if (this.enableEmptyStrategyHelper) {
                TypeElement typeElement = this.viewInterfaceElement;
                if (typeElement == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"viewInterfaceElement");
                }
                this.migrationMethods.add(new MigrationMethod(typeElement, methodElement));
            } else {
                String message = "A View method has no strategy! Add @StateStrategyType annotation to this method, or to the View interface. You can also specify default strategy via compiler option.";
                MvpCompiler.Companion.getMessager().printMessage(Diagnostic.Kind.ERROR, message, methodElement);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final AnnotationMirror getStateStrategyAnnotation(Element element) {
        void $this$mapNotNullTo$iv$iv;
        void $this$mapNotNull$iv;
        List enclosed = CollectionsKt.listOfNotNull((Object)ExtensionsKt.getAnnotationMirror(element, Reflection.getOrCreateKotlinClass(StateStrategyType.class)));
        List<? extends AnnotationMirror> list = element.getAnnotationMirrors();
        Intrinsics.checkNotNullExpressionValue(list, (String)"element.annotationMirrors");
        Iterable iterable = list;
        boolean $i$f$mapNotNull = false;
        void var6_5 = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            AnnotationMirror annotationMirror;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            AnnotationMirror it = (AnnotationMirror)element$iv$iv;
            boolean bl2 = false;
            AnnotationMirror annotationMirror2 = it;
            Intrinsics.checkNotNullExpressionValue((Object)annotationMirror2, (String)"it");
            DeclaredType declaredType = annotationMirror2.getAnnotationType();
            Intrinsics.checkNotNullExpressionValue((Object)declaredType, (String)"it.annotationType");
            if (ExtensionsKt.getAnnotationMirror(ExtensionsKt.asTypeElement(declaredType), Reflection.getOrCreateKotlinClass(StateStrategyType.class)) == null) continue;
            boolean bl3 = false;
            boolean bl4 = false;
            AnnotationMirror it$iv$iv = annotationMirror;
            boolean bl5 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List aliased = (List)destination$iv$iv;
        List strategies = CollectionsKt.plus((Collection)enclosed, (Iterable)aliased);
        if (strategies.size() > 1) {
            if (element instanceof ExecutableElement) {
                Messager messager = MvpCompiler.Companion.getMessager();
                StringBuilder stringBuilder = new StringBuilder().append("There's more than one state strategy type defined for method ").append('\'').append((Object)((ExecutableElement)element).getSimpleName()).append('(');
                List<? extends VariableElement> list2 = ((ExecutableElement)element).getParameters();
                Intrinsics.checkNotNullExpressionValue(list2, (String)"element.parameters");
                messager.printMessage(Diagnostic.Kind.ERROR, stringBuilder.append(CollectionsKt.joinToString$default((Iterable)list2, null, null, null, (int)0, null, (Function1)getStateStrategyAnnotation.1.INSTANCE, (int)31, null)).append(")'").append(" in interface '").append(((ExecutableElement)element).getEnclosingElement().asType()).append('\'').toString(), element);
            } else if (element instanceof TypeElement) {
                MvpCompiler.Companion.getMessager().printMessage(Diagnostic.Kind.ERROR, "There's more than one state strategy type defined for " + '\'' + ((TypeElement)element).getSimpleName() + '\'', element);
            }
        }
        return (AnnotationMirror)CollectionsKt.firstOrNull((List)strategies);
    }

    private final String defaultTag(ExecutableElement $this$defaultTag) {
        return $this$defaultTag.getSimpleName().toString();
    }

    private final boolean isStatic(Element $this$isStatic) {
        return $this$isStatic.getModifiers().contains((Object)Modifier.STATIC);
    }

    public ViewInterfaceProcessor(boolean disableEmptyStrategyCheck, boolean enableEmptyStrategyHelper, @Nullable String defaultStrategy) {
        this.disableEmptyStrategyCheck = disableEmptyStrategyCheck;
        this.enableEmptyStrategyHelper = enableEmptyStrategyHelper;
        boolean bl = false;
        this.migrationMethods = new ArrayList();
        if (defaultStrategy != null) {
            TypeElement localDefaultStrategy = MvpCompiler.Companion.getElementUtils().getTypeElement(defaultStrategy);
            if (localDefaultStrategy == null) {
                MvpCompiler.Companion.getMessager().printMessage(Diagnostic.Kind.ERROR, "Unable to parse option 'defaultMoxyStrategy'. Check " + defaultStrategy + " exists");
                localDefaultStrategy = DEFAULT_STATE_STRATEGY;
            }
            this.frameworkDefaultStrategy = localDefaultStrategy;
        } else {
            this.frameworkDefaultStrategy = DEFAULT_STATE_STRATEGY;
        }
    }

    static {
        Companion = new Companion(null);
        TypeElement typeElement = MvpCompiler.Companion.getElementUtils().getTypeElement(AddToEndSingleStrategy.class.getCanonicalName());
        Intrinsics.checkNotNullExpressionValue((Object)typeElement, (String)"elementUtils.getTypeElem\u2026class.java.canonicalName)");
        DEFAULT_STATE_STRATEGY = typeElement;
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lmoxy/compiler/viewstate/ViewInterfaceProcessor$Companion;", "", "()V", "DEFAULT_STATE_STRATEGY", "Ljavax/lang/model/element/TypeElement;", "OPTION_DEFAULT_STRATEGY", "", "moxy-compiler"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

