/*
 * Decompiled with CFR 0.152.
 */
package moxy.compiler.viewstate;

import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeSpec;
import java.util.Arrays;
import java.util.List;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import moxy.compiler.ExtensionsKt;
import moxy.compiler.viewstate.entity.MigrationMethod;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0007\u00a8\u0006\b"}, d2={"Lmoxy/compiler/viewstate/EmptyStrategyHelperGenerator;", "", "()V", "generate", "Lcom/squareup/javapoet/JavaFile;", "migrationMethods", "", "Lmoxy/compiler/viewstate/entity/MigrationMethod;", "moxy-compiler"})
public final class EmptyStrategyHelperGenerator {
    public static final EmptyStrategyHelperGenerator INSTANCE;

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    @NotNull
    public static final JavaFile generate(@NotNull List<MigrationMethod> migrationMethods) {
        Intrinsics.checkNotNullParameter(migrationMethods, (String)"migrationMethods");
        Name exampleView = migrationMethods.get(0).getViewInterface().getSimpleName();
        TypeSpec.Builder classBuilder = TypeSpec.classBuilder((String)"EmptyStrategyHelper").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL});
        String javaDoc = StringsKt.trimIndent((String)("\n            This class is generated because 'enableEmptyStrategyHelper' compiler option is set to true.\n            \n            \n            All view methods must have a strategy. Please, add the @StateStrategyType annotation\n            to the methods listed below. You can also set this annotation directly to the View interface.\n            \n            Do not pay attention to compilation errors like\n            'error: " + exampleView + " is abstract; cannot be instantiated'\n            \n            Just use your IDE to navigate to the methods and set the required strategy for them.\n            After you've fixed all the methods, you can remove 'enableEmptyStrategyHelper' option\n            for the current module.\n            \n        "));
        classBuilder.addJavadoc(javaDoc, new Object[0]);
        MethodSpec.Builder methodSpecBuilder = MethodSpec.methodBuilder((String)"getViewStateProviders").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC});
        methodSpecBuilder.addComment("If you are using Intellij IDEA or Android Studio, use Go to declaration (Ctrl/\u2318+B or Ctrl/\u2318+Click)", new Object[0]);
        methodSpecBuilder.addComment("to navigate to '" + ((MigrationMethod)CollectionsKt.first(migrationMethods)).getMethod().getSimpleName() + "()'", new Object[0]);
        for (MigrationMethod migrationMethod : migrationMethods) {
            String statement;
            void viewInterface;
            TypeElement typeElement = migrationMethod.component1();
            ExecutableElement method = migrationMethod.component2();
            String string = "new %s().%s()";
            Object[] objectArray = new Object[]{viewInterface.getQualifiedName(), method.getSimpleName()};
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)String.format(string, Arrays.copyOf(objectArray, objectArray.length)), (String)"java.lang.String.format(this, *args)");
            methodSpecBuilder.addStatement(statement, new Object[0]);
        }
        classBuilder.addMethod(methodSpecBuilder.build());
        TypeSpec typeSpec = classBuilder.build();
        Intrinsics.checkNotNullExpressionValue((Object)typeSpec, (String)"classBuilder.build()");
        return ExtensionsKt.toJavaFile(typeSpec, "moxy");
    }

    private EmptyStrategyHelperGenerator() {
    }

    static {
        EmptyStrategyHelperGenerator emptyStrategyHelperGenerator;
        INSTANCE = emptyStrategyHelperGenerator = new EmptyStrategyHelperGenerator();
    }
}

