/*
 * Decompiled with CFR 0.152.
 */
package moxy;

import android.os.Bundle;
import androidx.annotation.ContentView;
import androidx.annotation.LayoutRes;
import androidx.fragment.app.Fragment;
import moxy.MvpDelegate;
import moxy.MvpDelegateHolder;

public class MvpAppCompatFragment
extends Fragment
implements MvpDelegateHolder {
    private boolean isStateSaved;
    private MvpDelegate<? extends MvpAppCompatFragment> mvpDelegate;

    public MvpAppCompatFragment() {
    }

    @ContentView
    public MvpAppCompatFragment(@LayoutRes int contentLayoutId) {
        super(contentLayoutId);
    }

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.getMvpDelegate().onCreate(savedInstanceState);
    }

    public void onStart() {
        super.onStart();
        this.isStateSaved = false;
        this.getMvpDelegate().onAttach();
    }

    public void onResume() {
        super.onResume();
        this.isStateSaved = false;
        this.getMvpDelegate().onAttach();
    }

    public void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        this.isStateSaved = true;
        this.getMvpDelegate().onSaveInstanceState(outState);
        this.getMvpDelegate().onDetach();
    }

    public void onStop() {
        super.onStop();
        this.getMvpDelegate().onDetach();
    }

    public void onDestroyView() {
        super.onDestroyView();
        this.getMvpDelegate().onDetach();
        this.getMvpDelegate().onDestroyView();
    }

    public void onDestroy() {
        super.onDestroy();
        if (this.getActivity().isFinishing()) {
            this.getMvpDelegate().onDestroy();
            return;
        }
        if (this.isStateSaved) {
            this.isStateSaved = false;
            return;
        }
        boolean anyParentIsRemoving = false;
        for (Fragment parent = this.getParentFragment(); !anyParentIsRemoving && parent != null; parent = parent.getParentFragment()) {
            anyParentIsRemoving = parent.isRemoving();
        }
        if (this.isRemoving() || anyParentIsRemoving) {
            this.getMvpDelegate().onDestroy();
        }
    }

    public MvpDelegate getMvpDelegate() {
        if (this.mvpDelegate == null) {
            this.mvpDelegate = new MvpDelegate((Object)this);
        }
        return this.mvpDelegate;
    }
}

