/*
 * Decompiled with CFR 0.152.
 */
package com.chauthai.swipereveallayout;

import android.os.Bundle;
import com.chauthai.swipereveallayout.SwipeRevealLayout;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class ViewBinderHelper {
    private static final String BUNDLE_MAP_KEY = "ViewBinderHelper_Bundle_Map_Key";
    private Map<String, Integer> mapStates = Collections.synchronizedMap(new HashMap());
    private Map<String, SwipeRevealLayout> mapLayouts = Collections.synchronizedMap(new HashMap());
    private Set<String> lockedSwipeSet = Collections.synchronizedSet(new HashSet());
    private volatile boolean openOnlyOne = false;
    private final Object stateChangeLock = new Object();

    public void bind(final SwipeRevealLayout swipeLayout, final String id) {
        if (swipeLayout.shouldRequestLayout()) {
            swipeLayout.requestLayout();
        }
        this.mapLayouts.values().remove((Object)swipeLayout);
        this.mapLayouts.put(id, swipeLayout);
        swipeLayout.abort();
        swipeLayout.setDragStateChangeListener(new SwipeRevealLayout.DragStateChangeListener(){

            @Override
            public void onDragStateChanged(int state) {
                ViewBinderHelper.this.mapStates.put(id, state);
                if (ViewBinderHelper.this.openOnlyOne) {
                    ViewBinderHelper.this.closeOthers(id, swipeLayout);
                }
            }
        });
        if (!this.mapStates.containsKey(id)) {
            this.mapStates.put(id, 0);
            swipeLayout.close(false);
        } else {
            int state = this.mapStates.get(id);
            if (state == 0 || state == 1 || state == 4) {
                swipeLayout.close(false);
            } else {
                swipeLayout.open(false);
            }
        }
        swipeLayout.setLockDrag(this.lockedSwipeSet.contains(id));
    }

    public void saveStates(Bundle outState) {
        if (outState == null) {
            return;
        }
        Bundle statesBundle = new Bundle();
        for (Map.Entry<String, Integer> entry : this.mapStates.entrySet()) {
            statesBundle.putInt(entry.getKey(), entry.getValue().intValue());
        }
        outState.putBundle(BUNDLE_MAP_KEY, statesBundle);
    }

    public void restoreStates(Bundle inState) {
        if (inState == null) {
            return;
        }
        if (inState.containsKey(BUNDLE_MAP_KEY)) {
            HashMap<String, Integer> restoredMap = new HashMap<String, Integer>();
            Bundle statesBundle = inState.getBundle(BUNDLE_MAP_KEY);
            Set keySet = statesBundle.keySet();
            if (keySet != null) {
                for (String key : keySet) {
                    restoredMap.put(key, statesBundle.getInt(key));
                }
            }
            this.mapStates = restoredMap;
        }
    }

    public void lockSwipe(String ... id) {
        this.setLockSwipe(true, id);
    }

    public void unlockSwipe(String ... id) {
        this.setLockSwipe(false, id);
    }

    public void setOpenOnlyOne(boolean openOnlyOne) {
        this.openOnlyOne = openOnlyOne;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void openLayout(String id) {
        Object object = this.stateChangeLock;
        synchronized (object) {
            this.mapStates.put(id, 2);
            if (this.mapLayouts.containsKey(id)) {
                SwipeRevealLayout layout = this.mapLayouts.get(id);
                layout.open(true);
            } else if (this.openOnlyOne) {
                this.closeOthers(id, this.mapLayouts.get(id));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeLayout(String id) {
        Object object = this.stateChangeLock;
        synchronized (object) {
            this.mapStates.put(id, 0);
            if (this.mapLayouts.containsKey(id)) {
                SwipeRevealLayout layout = this.mapLayouts.get(id);
                layout.close(true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeOthers(String id, SwipeRevealLayout swipeLayout) {
        Object object = this.stateChangeLock;
        synchronized (object) {
            if (this.getOpenCount() > 1) {
                for (Map.Entry<String, Integer> entry : this.mapStates.entrySet()) {
                    if (entry.getKey().equals(id)) continue;
                    entry.setValue(0);
                }
                for (SwipeRevealLayout layout : this.mapLayouts.values()) {
                    if (layout == swipeLayout) continue;
                    layout.close(true);
                }
            }
        }
    }

    private void setLockSwipe(boolean lock, String ... id) {
        if (id == null || id.length == 0) {
            return;
        }
        if (lock) {
            this.lockedSwipeSet.addAll(Arrays.asList(id));
        } else {
            this.lockedSwipeSet.removeAll(Arrays.asList(id));
        }
        for (String s : id) {
            SwipeRevealLayout layout = this.mapLayouts.get(s);
            if (layout == null) continue;
            layout.setLockDrag(lock);
        }
    }

    private int getOpenCount() {
        int total = 0;
        for (int state : this.mapStates.values()) {
            if (state != 2 && state != 3) continue;
            ++total;
        }
        return total;
    }
}

