/*
 * Decompiled with CFR 0.152.
 */
package com.cz.widget.recyclerview.adapter.wrapper.sticky;

import android.graphics.Canvas;
import android.view.ViewGroup;
import androidx.annotation.NonNull;
import androidx.recyclerview.widget.GridLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import androidx.recyclerview.widget.StaggeredGridLayoutManager;
import com.cz.widget.recyclerview.adapter.BaseAdapter;
import com.cz.widget.recyclerview.adapter.wrapper.sticky.StickyCallback;
import com.cz.widget.recyclerview.adapter.wrapper.sticky.StickyGroupingStrategy;
import com.cz.widget.recyclerview.adapter.wrapper.sticky.StickyOverlayViewGroup;
import com.cz.widget.recyclerview.adapter.wrapper.sticky.StickyRecyclerViewScrollListener;
import com.cz.widget.recyclerview.adapter.wrapper.sticky.group.CompareGroupCondition;
import com.cz.widget.recyclerview.adapter.wrapper.sticky.group.GroupCondition;
import java.util.List;

public abstract class StickyAdapter<VH extends RecyclerView.ViewHolder, E>
extends BaseAdapter<VH, E>
implements StickyCallback<E> {
    private RecyclerView recyclerView;
    private StickyGroupingStrategy<StickyAdapter<VH, E>, E> groupingStrategy = StickyGroupingStrategy.of(this);

    public StickyAdapter(@NonNull List<E> itemList) {
        super(itemList);
    }

    public void setCompareCondition(CompareGroupCondition<E> compareCondition) {
        this.groupingStrategy.setCompareCondition(compareCondition);
    }

    public void setCondition(GroupCondition<E> condition) {
        this.groupingStrategy.setCondition(condition);
    }

    public void onAttachedToRecyclerView(final RecyclerView recyclerView) {
        super.onAttachedToRecyclerView(recyclerView);
        this.recyclerView = recyclerView;
        RecyclerView.LayoutManager manager = recyclerView.getLayoutManager();
        if (manager instanceof GridLayoutManager) {
            final GridLayoutManager gridLayoutManager = (GridLayoutManager)manager;
            gridLayoutManager.setSpanSizeLookup(new GridLayoutManager.SpanSizeLookup(){

                public int getSpanSize(int position) {
                    return StickyAdapter.this.isFillStickyHeader(position) ? gridLayoutManager.getSpanCount() : 1;
                }
            });
        }
        StickyOverlayViewGroup stickyOverlayViewGroup = new StickyOverlayViewGroup(recyclerView);
        final ViewGroup overlayView = stickyOverlayViewGroup.getOverlayView();
        recyclerView.addItemDecoration(new RecyclerView.ItemDecoration(){

            public void onDrawOver(@NonNull Canvas c, @NonNull RecyclerView parent, @NonNull RecyclerView.State state) {
                super.onDrawOver(c, parent, state);
                overlayView.draw(c);
            }
        });
        final StickyRecyclerViewScrollListener<StickyAdapter> recyclerViewScrollListener = new StickyRecyclerViewScrollListener<StickyAdapter>(recyclerView, this, stickyOverlayViewGroup);
        recyclerView.addOnScrollListener(new RecyclerView.OnScrollListener(){

            public void onScrolled(@NonNull RecyclerView recyclerView, int dx, int dy) {
                super.onScrolled(recyclerView, dx, dy);
                recyclerViewScrollListener.onScrolled(recyclerView, dx, dy);
            }
        });
        this.groupingStrategy.setOnAdapterDataChangeListener(new StickyGroupingStrategy.OnAdapterDataChangeListener(){

            @Override
            public void onDataChanged() {
                recyclerViewScrollListener.onScrolled(recyclerView, 0, 0);
            }
        });
    }

    public int getSpanCount() {
        RecyclerView.LayoutManager layoutManager;
        int spanCount = 1;
        if (null != this.recyclerView && null != (layoutManager = this.recyclerView.getLayoutManager())) {
            if (layoutManager instanceof GridLayoutManager) {
                GridLayoutManager gridLayoutManager = (GridLayoutManager)layoutManager;
                spanCount = gridLayoutManager.getSpanCount();
            } else if (layoutManager instanceof StaggeredGridLayoutManager) {
                StaggeredGridLayoutManager staggeredGridLayoutManager = (StaggeredGridLayoutManager)layoutManager;
                spanCount = staggeredGridLayoutManager.getSpanCount();
            }
        }
        return spanCount;
    }

    @Override
    public boolean isFillStickyHeader(int position) {
        return this.groupingStrategy.isGroupPosition(position);
    }

    @Override
    public int getStickyViewType(int position) {
        return 0;
    }

    public int getItemViewType(int position) {
        return super.getItemViewType(position);
    }

    @Override
    public StickyGroupingStrategy<StickyAdapter<VH, E>, E> getGroupingStrategy() {
        return this.groupingStrategy;
    }
}

