/*
 * Decompiled with CFR 0.152.
 */
package com.cz.widget.recyclerview.adapter.wrapper.select;

import android.view.View;
import androidx.recyclerview.widget.RecyclerView;
import com.cz.widget.recyclerview.adapter.wrapper.header.HeaderWrapperAdapter;
import com.cz.widget.recyclerview.adapter.wrapper.select.Selectable;
import java.util.ArrayList;
import java.util.List;

public class SelectWrapperAdapter
extends HeaderWrapperAdapter {
    public static final int INVALID_POSITION = -1;
    public static final int CLICK = 0;
    public static final int SINGLE_SELECT = 1;
    public static final int MULTI_SELECT = 2;
    public static final int RECTANGLE_SELECT = 3;
    private int selectPosition = -1;
    private int start = -1;
    private int end = -1;
    private int mode = 0;
    private List<Integer> multiSelectItems = new ArrayList<Integer>();
    private int selectMaxCount = Integer.MAX_VALUE;
    private OnSingleSelectListener singleSelectListener = null;
    private OnMultiSelectListener multiSelectListener = null;
    private OnRectangleSelectListener rectangleSelectListener = null;

    public SelectWrapperAdapter(RecyclerView.Adapter adapter) {
        super(adapter);
    }

    public void setSelectMode(int newMode) {
        int oldMode = this.mode;
        switch (oldMode) {
            case 1: {
                int lastSelectPosition = this.selectPosition;
                this.selectPosition = -1;
                if (-1 == lastSelectPosition) break;
                this.notifyItemChanged(lastSelectPosition);
                break;
            }
            case 2: {
                for (int position : this.multiSelectItems) {
                    this.notifyItemChanged(position);
                }
                this.multiSelectItems.clear();
                break;
            }
            case 3: {
                int s = Math.min(this.start, this.end);
                int e = Math.max(this.start, this.end);
                this.notifyItemRangeChanged(s, e - s + 1);
                this.start = 0;
                this.end = 0;
                break;
            }
        }
        this.start = -1;
        this.end = -1;
        this.selectPosition = -1;
        this.mode = newMode;
    }

    @Override
    public void addHeaderView(View view) {
        super.addHeaderView(view);
        this.updateSelectPosition(1);
    }

    @Override
    public void removeHeaderView(View view) {
        super.removeHeaderView(view);
        this.updateSelectPosition(-1);
    }

    private void updateSelectPosition(int offset) {
        switch (this.mode) {
            case 1: {
                this.selectPosition += offset;
                break;
            }
            case 2: {
                for (int i = 0; i < this.multiSelectItems.size(); ++i) {
                    Integer position = this.multiSelectItems.get(i);
                    this.multiSelectItems.set(i, position + offset);
                }
                break;
            }
            case 3: {
                if (this.start != -1) {
                    this.start += offset;
                }
                if (this.end == -1) break;
                this.end += offset;
            }
        }
    }

    public void setSelectMaxCount(int count) {
        this.selectMaxCount = count;
    }

    public void setMultiSelectItems(List<Integer> list) {
        this.multiSelectItems.clear();
        if (null != list) {
            this.multiSelectItems.addAll(list);
        }
        for (int position : this.multiSelectItems) {
            this.notifyItemChanged(position);
        }
    }

    public void setSingleSelectPosition(int position) {
        int lastPosition = this.selectPosition;
        this.selectPosition = position;
        int headerViewCount = this.getHeaderViewCount();
        if (0 <= lastPosition && lastPosition < this.getItemCount()) {
            this.notifyItemChanged(lastPosition + headerViewCount);
        }
        if (0 <= position && position < this.getItemCount()) {
            this.notifyItemChanged(position + headerViewCount);
        }
    }

    @Override
    public void onBindViewHolder(RecyclerView.ViewHolder holder, int position) {
        super.onBindViewHolder(holder, position);
        int headersCount = this.getHeaderViewCount();
        int footerViewCount = this.getFooterViewCount();
        switch (this.mode) {
            case 1: {
                this.setSelectPosition(holder, position, headersCount, footerViewCount, this.selectPosition == position);
                break;
            }
            case 2: {
                this.setSelectPosition(holder, position, headersCount, footerViewCount, this.multiSelectItems.contains(position));
                break;
            }
            case 3: {
                int s = Math.min(this.start, this.end);
                int e = Math.max(this.start, this.end);
                boolean isSelected = s <= position && position <= e;
                this.setSelectPosition(holder, position, headersCount, footerViewCount, isSelected);
                break;
            }
            default: {
                this.setSelectPosition(holder, position, headersCount, footerViewCount, false);
            }
        }
    }

    protected void setSelectPosition(RecyclerView.ViewHolder holder, int position, int headerCount, int footerCount, boolean select) {
        int start = headerCount;
        int end = this.getItemCount() - footerCount;
        RecyclerView.Adapter adapter = this.getAdapter();
        if (null != adapter && adapter instanceof Selectable && start <= position && position <= end) {
            Selectable selectable = (Selectable)adapter;
            selectable.onSelectItem(holder, position - headerCount, select);
        }
    }

    @Override
    protected boolean onItemClick(View v, int position, int adapterPosition) {
        switch (this.mode) {
            case 2: {
                int lastSize = this.multiSelectItems.size();
                if (this.multiSelectItems.contains(adapterPosition)) {
                    --lastSize;
                    this.multiSelectItems.remove((Object)adapterPosition);
                    this.notifyItemChanged(adapterPosition);
                } else if (this.multiSelectItems.size() < this.selectMaxCount) {
                    this.multiSelectItems.add(adapterPosition);
                    this.notifyItemChanged(adapterPosition);
                }
                if (null == this.multiSelectListener) break;
                this.multiSelectListener.onMultiSelect(v, this.multiSelectItems, lastSize, this.selectMaxCount);
                break;
            }
            case 3: {
                if (-1 != this.start && -1 != this.end) {
                    int s = this.start;
                    int e = this.end;
                    this.end = -1;
                    this.start = -1;
                    this.notifyItemRangeChanged(Math.min(s, e), Math.abs(s - e) + 1);
                    break;
                }
                if (-1 == this.start) {
                    this.start = adapterPosition;
                    this.notifyItemChanged(adapterPosition);
                    break;
                }
                if (-1 != this.end) break;
                this.end = adapterPosition;
                if (null != this.rectangleSelectListener) {
                    this.rectangleSelectListener.onRectangleSelect(this.start, this.end);
                }
                this.notifyItemRangeChanged(Math.min(this.start, this.end), Math.abs(this.start - this.end) + 1);
                break;
            }
            case 1: {
                int last = this.selectPosition;
                this.selectPosition = adapterPosition;
                if (null != this.singleSelectListener) {
                    this.singleSelectListener.onSingleSelect(v, adapterPosition, last);
                }
                if (0 <= this.selectPosition && -1 != last) {
                    this.notifyItemChanged(last);
                }
                this.notifyItemChanged(adapterPosition);
                break;
            }
        }
        return 0 == this.mode;
    }

    public int getSelectPosition() {
        return this.selectPosition;
    }

    public void setRectangleSelectPosition(int start, int end) {
        this.start = start;
        this.end = end;
        this.notifyItemRangeChanged(start, end - start);
    }

    public void setOnSingleSelectListener(OnSingleSelectListener singleSelectListener) {
        this.singleSelectListener = singleSelectListener;
    }

    public void setOnMultiSelectListener(OnMultiSelectListener multiSelectListener) {
        this.multiSelectListener = multiSelectListener;
    }

    public void setOnRectangleSelectListener(OnRectangleSelectListener rectangleSelectListener) {
        this.rectangleSelectListener = rectangleSelectListener;
    }

    public static interface OnRectangleSelectListener {
        public void onRectangleSelect(int var1, int var2);
    }

    public static interface OnMultiSelectListener {
        public void onMultiSelect(View var1, List<Integer> var2, int var3, int var4);
    }

    public static interface OnSingleSelectListener {
        public void onSingleSelect(View var1, int var2, int var3);
    }
}

