/*
 * Decompiled with CFR 0.152.
 */
package com.cz.widget.recyclerview.adapter.wrapper.drag;

import androidx.annotation.NonNull;
import androidx.recyclerview.widget.GridLayoutManager;
import androidx.recyclerview.widget.ItemTouchHelper;
import androidx.recyclerview.widget.RecyclerView;
import androidx.recyclerview.widget.StaggeredGridLayoutManager;
import com.cz.widget.recyclerview.adapter.wrapper.drag.DragCallback;
import com.cz.widget.recyclerview.adapter.wrapper.drag.DragItemTouchHelperCallback;
import com.cz.widget.recyclerview.adapter.wrapper.drag.Moveable;
import com.cz.widget.recyclerview.adapter.wrapper.dynamic.DynamicWrapperAdapter;

public class DragWrapperAdapter
extends DynamicWrapperAdapter
implements DragCallback {
    private final ItemTouchHelper itemTouchHelper = new ItemTouchHelper((ItemTouchHelper.Callback)new DragItemTouchHelperCallback(this));
    private DragCallback delegateCallback;
    private int dragFlag = 0;
    private boolean fixedViewDragEnabled = true;

    public DragWrapperAdapter(@NonNull RecyclerView.Adapter adapter) {
        super(adapter);
    }

    @Override
    public boolean isDragEnable(int position) {
        boolean isFixedView;
        int findPosition = this.findPosition(position);
        boolean bl = isFixedView = -1 != findPosition;
        if (isFixedView) {
            return this.fixedViewDragEnabled;
        }
        if (null != this.delegateCallback) {
            int extraViewCount = this.getExtraViewCount(position);
            return this.delegateCallback.isDragEnable(position - extraViewCount);
        }
        return true;
    }

    @Override
    public boolean isLongPressDragEnabled() {
        if (null != this.delegateCallback) {
            return this.delegateCallback.isLongPressDragEnabled();
        }
        return true;
    }

    public boolean isSwipeDirectionEnabled() {
        if (null != this.delegateCallback) {
            return this.delegateCallback.isLongPressDragEnabled();
        }
        return true;
    }

    @Override
    public int getDragFlag() {
        if (null != this.delegateCallback) {
            return this.delegateCallback.getDragFlag();
        }
        return this.dragFlag;
    }

    @Override
    public void onAttachedToRecyclerView(RecyclerView recyclerView) {
        super.onAttachedToRecyclerView(recyclerView);
        RecyclerView.LayoutManager layoutManager = recyclerView.getLayoutManager();
        this.dragFlag = layoutManager instanceof GridLayoutManager || layoutManager instanceof StaggeredGridLayoutManager ? 15 : 3;
        this.itemTouchHelper.attachToRecyclerView(recyclerView);
    }

    public void move(int oldPosition, int newPosition) {
        this.movePosition(oldPosition, newPosition);
        this.notifyItemMoved(oldPosition, newPosition);
    }

    private void movePosition(int oldPosition, int newPosition) {
        block4: {
            if (this.isHeaderPosition(oldPosition) || this.isFooterPosition(oldPosition) || this.isHeaderPosition(newPosition) || this.isFooterPosition(newPosition)) break block4;
            if (oldPosition < newPosition) {
                for (int i = oldPosition; i < newPosition; ++i) {
                    this.moveInternal(i, i + 1);
                }
            } else {
                for (int i = oldPosition; i > newPosition; --i) {
                    this.moveInternal(i, i - 1);
                }
            }
        }
    }

    private void moveInternal(int oldPosition, int newPosition) {
        boolean endFillColumn;
        int oldIndex = this.findPosition(oldPosition);
        int newIndex = this.findPosition(newPosition);
        boolean startFillColumn = -1 != oldIndex;
        boolean bl = endFillColumn = -1 != newIndex;
        if (startFillColumn && endFillColumn) {
            this.setFixedViewPosition(oldIndex, newPosition);
            this.setFixedViewPosition(newIndex, oldPosition);
        } else if (startFillColumn) {
            this.setFixedViewPosition(oldIndex, newPosition);
        } else if (endFillColumn) {
            this.setFixedViewPosition(newIndex, oldPosition);
        } else {
            RecyclerView.Adapter adapter = this.getAdapter();
            if (adapter instanceof Moveable) {
                Moveable moveable = (Moveable)adapter;
                int oldExtraViewCount = this.getExtraViewCount(oldPosition);
                int startExtraViewCount = this.getExtraViewCount(oldPosition);
                moveable.move(oldPosition - oldExtraViewCount, newPosition - startExtraViewCount);
            }
        }
    }

    public void setFixedViewDragEnabled(boolean fixedViewDragEnabled) {
        this.fixedViewDragEnabled = fixedViewDragEnabled;
    }

    public void setDragDelegate(DragCallback callback) {
        this.delegateCallback = callback;
    }
}

