/*
 * Decompiled with CFR 0.152.
 */
package com.cz.widget.recyclerview.adapter.support.swipe;

import android.content.Context;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.NonNull;
import androidx.recyclerview.widget.GridLayoutManager;
import androidx.recyclerview.widget.ItemTouchHelper;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import androidx.recyclerview.widget.StaggeredGridLayoutManager;
import com.cz.widget.recyclerview.adapter.BaseAdapter;
import com.cz.widget.recyclerview.adapter.support.swipe.SwipeCallback;
import com.cz.widget.recyclerview.adapter.support.swipe.SwipeItemTouchHelperCallback;
import java.util.List;

public abstract class SwipeAdapter<VH extends RecyclerView.ViewHolder, E>
extends BaseAdapter<VH, E>
implements SwipeCallback {
    private SwipeCallback delegateCallback;
    private int dragFlag = 0;

    public SwipeAdapter(@NonNull List<E> itemList) {
        super(itemList);
    }

    public void onAttachedToRecyclerView(@NonNull RecyclerView recyclerView) {
        super.onAttachedToRecyclerView(recyclerView);
        RecyclerView.LayoutManager layoutManager = recyclerView.getLayoutManager();
        if (layoutManager instanceof GridLayoutManager || layoutManager instanceof StaggeredGridLayoutManager) {
            this.dragFlag = 15;
        } else if (layoutManager instanceof LinearLayoutManager) {
            LinearLayoutManager linearLayoutManager = (LinearLayoutManager)layoutManager;
            int orientation = linearLayoutManager.getOrientation();
            this.dragFlag = 1 == orientation ? 12 : 3;
        }
        SwipeItemTouchHelperCallback swipeItemTouchHelperCallback = new SwipeItemTouchHelperCallback(this);
        ItemTouchHelper itemTouchHelper = new ItemTouchHelper((ItemTouchHelper.Callback)swipeItemTouchHelperCallback);
        swipeItemTouchHelperCallback.attachedToRecyclerView(recyclerView);
        itemTouchHelper.attachToRecyclerView(recyclerView);
    }

    public int getSwipeMenuViewType(int position) {
        return 0;
    }

    public abstract View onCreateSwipeMenuView(@NonNull Context var1, @NonNull ViewGroup var2, int var3);

    public abstract void onBindSwipeMenuView(@NonNull Context var1, @NonNull View var2, int var3, int var4);

    @Override
    public int getMoveFlag() {
        if (null != this.delegateCallback) {
            return this.delegateCallback.getMoveFlag();
        }
        return this.dragFlag;
    }

    @Override
    public boolean isSwipeEnable(int position) {
        if (null != this.delegateCallback) {
            return this.delegateCallback.isSwipeEnable(position);
        }
        return true;
    }

    @Override
    public boolean isSwipeDirectionEnabled(int direction) {
        if (null != this.delegateCallback) {
            return this.delegateCallback.isSwipeDirectionEnabled(direction);
        }
        return true;
    }

    public void setDelegateCallback(SwipeCallback delegateCallback) {
        this.delegateCallback = delegateCallback;
    }
}

